
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-xs-12" id="msg">
                <?php echo userdata('msg'); ?>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12">
                <div class="box no-border">
                    <div class="box-header with-border">
                        <h3 class="text-muted text-bold" style="text-align:right; font-size:16px">
                            <a href="<?php echo base_url(); ?>p2p/orders">
                                Pending Trades 
                                <span class="badge bg-black" title="Pending orders" data-toggle="tooltip">
                                    <?php echo $this->Util_model->row_count("p2p_orders", "WHERE (seller_uid=".userdata(UID)." OR buyer_uid=".userdata(UID).") AND status<3"); ?>
                                </span> 
                            </a>
                        </h3>
                    </div>
                    <!-- /.box-header -->
                    <div class="box-body text-center">
                        <div class="table-responsive">
                            <table id="orders" class="table table-bordered table-striped">
                                <thead>
                                <tr>
                                    <th class="text-center">status</th>
                                    <th class="text-center">Amount</th>
                                    <th class="text-center">Converted</th>
                                    <th class="text-center">Rate</th>
                                    <th class="text-center">Receiver</th>
                                    <th class="text-center">Sender</th>
                                    <th class="text-center">Reference</th>
                                    <th class="text-center">Created Date</th>
                                    <th class="text-center"></th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php
                                $s = $this->Db_model->selectGroup("*", "p2p_orders", "WHERE (seller_uid=".userdata(UID)." OR buyer_uid=".userdata(UID).") ORDER BY status, id DESC");
                                if ($s->num_rows() > 0) {
                                    foreach ($s->result_array() as $row) {
                                        $btn = "";
                                        if ($row['status'] == 4) {
                                            $status = "
                                            <span class='badge bg-red'>Cancelled</span>
                                            ";
                                        } else if ($row['status'] == 3) {
                                            $status = "
                                            <span class='badge bg-green'>Completed</span>
                                            ";
                                        } else if ($row['status'] == 2) {
                                            $status = "
                                            <span class='badge bg-yellow'>Awaiting release</span>
                                            ";
                                        } else if ($row['status'] == 1) {
                                            $status = "
                                            <span class='badge bg-yellow'>Awaiting payment</span>
                                            ";
                                            if ($row['buyer_uid'] == userdata(UID)) {
                                                $btn .= "
                                                <a href='".base_url()."p2p/cancel-trade/$row[id]' class='btn btn-danger btn-xs'>Cancel</a> 
                                                ";
                                            }
                                        } else {
                                            $status = "
                                            <span class='badge bg-blue'>Appealed</span>
                                            ";
                                            if ($row['disputed'] == userdata(UID)) {
                                                $btn .= "
                                                <a href='#' class='btn btn-default btn-xs'>Close appeal</a> 
                                                ";
                                            }
                                        }
                                        $btn .= "<a href='".base_url()."p2p/view-order/$row[reference]' class='btn btn-primary btn-xs'><i class='fa fa-eye'></i> View</a>";

                                        $details = "";
                                        if (strstr($row['details'], ',')) {
                                            $detials_row = explode(",", $row['details']);
                                            foreach ($detials_row as $val) {
                                                $details_col = explode("=", $val);
                                                $details .= "
                                                <span class='label label-default'>$details_col[0]</span> $details_col[1]<br>
                                                ";
                                            }
                                        } else {
                                            $details_col = explode("=", $row['details']);
                                            $details .= "
                                                <span class='label label-default'>$details_col[0]</span> $details_col[1]<br>
                                            ";
                                        }

                                        echo "
                                        <tr>
                                            <td>$status</td>
                                            <td>".number_format($row['amount'],2)." USD</td>
                                            <td>$row[converted_amount] $row[currency]</td>
                                            <td>$row[rate] $row[currency]</td>
                                            <td>".$this->Util_model->get_user_info($row['buyer_uid'], 'username', 'profile')."</td>
                                            <td>".$this->Util_model->get_user_info($row['seller_uid'], 'username', 'profile')."</td>
                                            <td>$row[reference]</td>
                                            <td>$row[created_date]</td>
                                            <td>$btn</td>
                                        </tr>
                                        ";
                                    }
                                    
                                    
                                }
                                ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!-- /.box-body -->
                </div>
                <!-- /.box -->
            </div>

            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                <?php if ($this->Util_model->get_user_info(userdata(UID), "duration", "profile") > 0) : ?>
                    <?php $this->load->view("layouts/buy_sell_coin"); ?>
                <?php else : ?>
                    <div class="box box-widget widget-user">
                        <!-- Add the bg color to the header using any of the bg-* classes -->
                        <?php
                        $uid = userdata(UID);
                        $main = $this->Util_model->get_info("user_main", "name, date", "WHERE uid=$uid");
                        $pro = $this->Util_model->get_info("user_profile", "*", "WHERE uid=$uid");
                        $centre = $this->Util_model->get_info("centre", "*", "WHERE cid='".$this->Util_model->get_user_info($uid, "cid", "profile")."'");
                        ?>
                        <div class="widget-user-header bg-yellow-active">
                            <h3 class="widget-user-username"><?php echo $main['name']; ?></h3>
                            <h5 class="widget-user-desc">@<?php echo $pro['username']; ?></h5>
                        </div>
                        <div class="widget-user-image">
                            <img class="img-circle" src="<?php echo base_url().$this->Util_model->picture($uid); ?>" alt="<?php echo $pro['username']; ?>">
                        </div>
                        
                        <div class="box-footer no-padding">
                            <ul class="nav nav-stacked">
                                <li><a href="#">Phone <span class="pull-right text-bold"><?php echo $pro['phone_code'].$pro['phone'] ?></span></a></li>
                                <li><a href="#">Email <span class="pull-right text-bold"><?php echo $pro["email"]; ?></span></a></li>
                                <li><a href="#">Referred by <span class="pull-right text-bold"><?php echo $this->Util_model->get_user_info($this->Util_model->get_user_info($uid, "ref1", "referrer")); ?></span></a></li>
                                <li><a href="#">Registered on <span class="pull-right text-bold"><?php echo $main['date']; ?></span></a></li>
                            </ul>
                        </div>
                    </div>
                    <!-- /.widget-user -->
                <?php endif; ?>
            </div>
        </div>
        <!--/.row-->
    </section>

<!-- DataTables -->
<script src="<?php echo base_url(); ?>assets/plugins/datatables/jquery.dataTables.min.js"></script>
<script src="<?php echo base_url(); ?>assets/plugins/datatables/dataTables.bootstrap.min.js"></script>

<script>
    $(function () {

        $('#orders').DataTable({
            "order":[7, "desc"]
        });

    });
</script>