<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Recommend A Friend
            <small>Let's help you work on your contacts</small>
        </h1>
        <?php echo $breadcrumb; ?>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-xs-12" id="msg">
                <?php echo userdata('msg'); ?>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                <div class="box no-border">
                    <div class="box-header with-border">
                        <h3 class="box-title">Recommend</h3>
                    </div><!-- /.box-header -->
                    <div class="box-body">
                        <?php echo form_open(base_url()."recommend"); ?>
                            <div class="form-group">
                                <lable>First Name <span class="required">*</span></label>
                                <input class="form-control" type="text" name="fname" required>
                            </div>
                            <div class="form-group">
                                <lable>Last Name/Surname</label>
                                <input class="form-control" type="text" name="lname">
                            </div>
                            <div class="form-group">
                                <lable>Phone Number <span class="required">*</span></label>
                                <div class="row">
                                    <div class="col-xs-4" style="padding-right:0px">
                                        <select name="phone_code" class="form-control">
                                            <?php echo $this->Util_model->list_from_table("countries", "phone_code", "phone_code", "", "+234"); ?>
                                        </select>
                                    </div>
                                    <div class="col-xs-8">
                                        <input class="form-control" type="number" name="phone" required>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group">
                                <lable>Who are you to your contact?</label>
                                <select class="form-control" name="relationship">
                                    <option value="friend">Friend</option>
                                    <option value="brother">Brother</option>
                                    <option value="sister">Sister</option>
                                    <option value="father">Father</option>
                                    <option value="mother">Mother</option>
                                    <option value="son">Son</option>
                                    <option value="daughter">Daughter</option>
                                    <option value="husband">Husband</option>
                                    <option value="wife">Wife</option>
                                    <option value="pastor">Pastor</option>
                                    <option value="teacher">Teacher</option>
                                    <option value="co-worker">Co-worker</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <button class="btn btn-primary" type="submit">Submit <i class="fa fa-arrow-right"></i></button>
                            </div>
                        <?php echo form_close(); ?>
                    </div>
                </div>
            </div>
            <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12">
                <div class="box no-border">
                    <div class="box-header with-border">
                        <h3 class="box-title">Recommended
                            <span class="badge bg-purple">
                                <?php $s = $this->Db_model->selectGroup("*", "user_recommend", "WHERE uid=".userdata(UID)); ?>
                                <?php echo number_format($s->num_rows()); ?> Contacts
                            </span>
                        </h3>
                    </div><!-- /.box-header -->
                    <div class="box-body">
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 no-padding top-2x table-responsive">
                            <table id="referralTable" class="table table-bordered table-striped">
                                <thead>
                                <tr>
                                    <th class="text-center">Name</th>
                                    <th class="text-center">Phone Number</th>
                                    <th class="text-center">Relationship</th>
                                    <th class="text-center">Date</th>
                                    <th class="text-center">Status</th>
                                    <th class="text-center"></th>
                                </tr>
                                </thead>
                                <tbody>
                                    <?php 
                                    foreach($s->result_array() as $row) {
                                        if ($row['status'] == 0) {
                                            $status = "<span class='badge bg-black'>None</span>";
                                        } else if ($row['status'] == 1) {
                                            $status = "<span class='badge bg-yellow'>Attended</span>";
                                        }  else if ($row['status'] == 2) {
                                            $status = "<span class='badge bg-blue'>Registered</span>";
                                        }  else if ($row['status'] == 3) {
                                            $status = "<span class='badge bg-green'>Member</span>";
                                        } 
                                        $btn = "<button type='button' class='btn btn-primary btn-xs' id='send-msg' onclick='dialog(\"".base_url()."ajax/recommend-msg\", \"id=$row[id]\", \"gen-modal\", \"sm\")'>Send Msg</button>";
                                        echo "
                                        <tr>
                                            <td>$row[first_name] $row[last_name]</td>
                                            <td>$row[phone_code]$row[phone]</td>
                                            <td>".ucwords($row['relationship'])."</td>
                                            <td>$row[date]</td>
                                            <td>$status</td>
                                            <td>$btn</td>
                                        </tr>
                                        ";
                                    }
                                    ?>
                                </tbody>
                            </table>

                        </div>
                    </div>
                    <div class="box-footer">
                        <b>None: </b>Nothing has been done by this person<br>
                        <b>Attended: </b>Attanded the conference<br>
                        <b>Registered: </b>Registered but not yet active<br> 
                        <b>Member: </b>Registered and have activated the account
                    </div>
                </div>
                <!-- /.box -->
            </div>
        </div>
        <!--/.row-->
    </section>
</div>

<!-- DataTables -->
<script src="<?php echo base_url(); ?>assets/plugins/datatables/jquery.dataTables.min.js"></script>
<script src="<?php echo base_url(); ?>assets/plugins/datatables/dataTables.bootstrap.min.js"></script>
<!-- date-picker -->
<script src="<?php echo base_url(); ?>assets/plugins/datepicker/bootstrap-datepicker.js"></script>

<script>
    $(function () {

        $('#referralTable').DataTable({
            "order":[0, "desc"]
        });
    });
</script>
