<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Sell <?php echo $coin_main['name']; ?> Coin
            <small>Convert your <?php echo $coin_main['symbol']; ?> to fiat</small>
        </h1>
        <?php echo $breadcrumb; ?>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-xs-12" id="msg">
                <?php echo userdata('msg'); ?>
            </div>
        </div>
        <!-- Info boxes -->
        <div class="row">
            <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12">
                <div class="box box-info box-border box-default">
                    <div class="box-body">
                        <div class="nav-tabs-custom">
                            <ul class="nav nav-tabs">
                                <?php 
                                $count = 1;
                                foreach ($coin_net->result_array() as $row) {
                                    $active = ($count == 1) ? "class='active'" : "";
                                    echo "
                                    <li $active><a href='#$row[network]' data-toggle='tab'>$row[network]</a></li>
                                    ";
                                    $count++;
                                }
                                ?>
                            </ul>
                            <div class="tab-content">
                                
                                <?php 
                                    $count = 1;
                                    foreach ($coin_net->result_array() as $row) :
                                        $active = ($count == 1) ? "active" : "";
                                        $count++;
                                ?>
                                        <div class="tab-pane <?php echo $active; ?>" id="<?php echo $row['network']; ?>">
                                            <div class="">
                                                <center class="top-2x bottom-2x">
                                                    <img src="https://api.qrserver.com/v1/create-qr-code/?data=<?php echo $row['address']; ?>&amp;size=150x150" width="150" height="150" style="border:1px solid #000000; box-shadow:0px 0px 5px #000000">
                                                    <h5 class="text-center text-bold top-2x" id="address"><?php echo $row['address']; ?></h5>
                                                    <button class="btn btn-default btn-sm top-1x" type="button" onclick="copyToClipboard($(this), $('#address'))"><i class="fa fa-copy"></i> Copy Address</button>
                                                </center>
                                                <div class="well top-5x">
                                                    <span class="no-display" id="network"><?php echo $row["network"]; ?></span>
                                                    <div class="form-group">
                                                        <div class="input-group">
                                                            <span class="input-group-addon">Sender Address <i class="fa fa-info-circle" title="Go to transaction history and click on the transaction, copy and paste the From (your own wallet address) here" data-toggle="tooltip"></i></span>
                                                            <input class="form-control" id="address" type="text" placeholder="Enter your address" >
                                                        </div>
                                                    </div>
                                                    <div class="form-group">
                                                        <div class="input-group" style="margin-bottom:5px">
                                                            <span class="input-group-addon text-muted">Amount (<?php echo $coin_main['symbol']; ?>)</span>
                                                            <input id="amount" type="number" autocomplete="off" required class="form-control text-center text-muted" min="1" placeholder="Min. <?php echo $coin_main['min']; ?>" onkeyup="convert($(this).val(), )" onblur="convert($(this).val())">
                                                        </div>
                                                    </div>
                                                    <p class="text-center">
                                                        <i class="fa fa-exchange" style="-webkit-transform: rotate(-90deg); -moz-transform: rotate(-90deg); -ms-transform: rotate(-90deg); -o-transform: rotate(-90deg); filter: progid:DXImageTransform.Microsoft.BasicImage(rotation=3);"></i>
                                                    </p>
                                                    <div class="form-group">
                                                        <div class="input-group">
                                                            <span class="input-group-addon text-muted">Amount (USD)</span>
                                                            <input id="usd-amount" type="number" autocomplete="off" required class="form-control text-center text-muted" min="1" placeholder="" onkeyup="convert($(this).val(), 1)" onblur="convert($(this).val(), 1)">
                                                        </div>
                                                    </div>
                                                    <h2 class="text-center"><?php echo USD; ?><span id="total">0.00</span></h2>
                                                    <p class="text-center">Transaction Fee <?php echo USD; ?><span id="fee">0.00</span> (5%) </p>
                                                    <button id="sell-coin" class="btn btn-primary btn-block top-2x" type="button">Sell <?php echo $coin_main['symbol']; ?></button>
                                                </div>
                                            </div>
                                        </div>
                                <?php
                                    endforeach;
                                ?>
                                
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                <?php $this->load->view("layouts/buy_sell_coin"); ?>
            </div>
        </div>
    </section>
</div>

<script>
    $(document).ready(function() {
        var rate = <?php echo $this->Util_model->get_option("dollar_rate"); ?>;
        var coin_price = <?php echo $coin_main['price']; ?>;
        var min_amt = <?php echo $coin_main['min']; ?>;
        var min = (min_amt * coin_price) * rate;
        _("usd-amount").attr("placeholder", "Min. "+numberWithCommas(min.toFixed(2)));

        $("#sell-coin").click (function () {
            if (___("address") == "" || ___("amount") == "" || ___("usd-amount") == "") {
                msg("<i class='fa fa-times-circle'></i> Required field(s) empty", "alert-danger", 1, _("msg"));
            } else if (___("amount") < min_amt) {
                msg("<i class='fa fa-times-circle'></i> <?php echo $coin_main['symbol']; ?> amount less than "+min_amt, "alert-danger", 1, _("msg"));
            } else {
                Swal.fire({
                    title: 'Have you sent the coin?',
                    text: "If you create up to 5 invalid transactions your account will be disabled from selling coin on the system!",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Yes, proceed!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        sell();
                    }
                });
            }
        });
    });
    
    function convert (amt, type) {
        var rate = <?php echo $this->Util_model->get_option("dollar_rate"); ?>;
        var coin_price = <?php echo $coin_main['price']; ?>;
        if (amt > 0) {
            if (type) {
                var crypto = (amt / rate) / coin_price;
                var actual = amt;
                _("amount").val(crypto.toFixed(4));
            } else {
                var usd = (amt * coin_price) * rate;
                var actual = usd;
                _("usd-amount").val(usd.toFixed(2));
            }
            
            var fee = (actual * 0.05);
            actual = actual - fee;
            actual = actual.toString().match(/^-?\d+(?:\.\d{0,2})?/)[0];
            $("#total").text(actual);
            fee = fee.toString().match(/^-?\d+(?:\.\d{0,2})?/)[0];
            $("#fee").text(fee);

        } else if (amt <= 0) {
            if (type) {
                _("amount").val(0);
            } else {
                _("usd-amount").val(0);
            }
            $("#total").text("0.00");
            $("#fee").text("0.00");
        }


        /* if (actual < 25000) {
            $("#crypto-select").addClass("no-display");
        } else if (actual > 100000000) {
            $("#crypto-select").addClass("no-display");
        } else {
            $("#crypto-select").show();
        } */
    }

    function sell() {
        var base_url = "<?php echo base_url(); ?>";
        _("buy-coin").attr("disabled", "disabled");
        _("buy-coin").html("<i class='fa fa-spinner fa-spin'></i> Processing...");
        $.post(base_url+"coin/process-sell/<?php echo $coin_main['id']; ?>", {"network":____("network"), "address":___("address"), "amount":___("amount"), "ngn_amount":___("usd-amount"), "recieve_amount":____("total"), "fee":____("fee")}, function(data) {
            if (data == 1) {
                msg("<i class='fa fa-check-circle'></i> Thank you! Awaiting approval. Please wait!", "alert-success", 1, _("msg"));
                setTimeout(function() {
                    window.location = base_url+"transactions/coin-sell";
                }, 2000);
            } else if (data == 0) {
                msg("<i class='fa fa-times-circle'></i> Sorry, an error occured. Please try again", "alert-danger", 1, _("msg"));
                _("buy-coin").removeAttr("disabled");
                _("buy-coin").html("<i class='fa fa-send'></i> Sell <?php echo $coin_main['symbol']; ?>");
            }
        })
    }
</script>