<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title><?php echo SITE_TITLE; ?> - Sign In</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <link rel="shortcut icon" href="<?php echo base_url(); ?>assets/img/favicon.png" type="image/x-icon">
    <!-- Bootstrap 3.3.6 -->
    <link rel="stylesheet" href="<?php echo base_url(); ?>assets/bootstrap/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="<?php echo base_url(); ?>assets/plugins/font-awesome/css/font-awesome.min.css">
    <!-- Ionicons -->
    <link rel="stylesheet" href="<?php echo base_url(); ?>assets/ionicons-2.0.1/css/ionicons.min.css">
    <!-- Theme style -->
    <link rel="stylesheet" href="<?php echo base_url(); ?>assets/dist/css/AdminLTE.min.css">
    <!-- iCheck -->
    <link rel="stylesheet" href="<?php echo base_url(); ?>assets/plugins/iCheck/square/blue.css">

    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
</head>
<body class="hold-transition register-page" style="background: url('<?php echo base_url(); ?>assets/img/user-background.jpg') center center fixed; background-size:cover">
<div class="register-box">
    <div class="register-logo bottom-2x">
        <?php
        $logo = $this->Util_model->get_option("site_logo");
        if ($logo) {
            $logo = base_url().$logo;
            echo "<a href='".base_url()."'><img src='$logo' class='logo' style='width:90%; height:auto; margin:0px auto;'></a>";
        } else {
            echo "<a href='".base_url()."'><?php echo SITE_TITLE; ?></a>";
        }
        ?>
    </div>

    <div class="register-box-body" style="background-color:#daa517; border-radius:10px; color:#ffffff; box-shadow:0px 0px 10px #000;">
        <div class="col-xs-12 no-padding"><?php echo userdata("msg"); ?></div>
        <p class="login-box-msg">Sign in to start session</p>

        <?php echo form_open(base_url().'sign-in',"id='sign-in-form'"); ?>
        <div class="form-group has-feedback">
            <input type="text" class="form-control" placeholder="Email/Username" name="user" id="email" value="<?php echo set_value('user'); ?>">
            <span class="glyphicon glyphicon-user form-control-feedback"></span>
        </div>
        <div class="form-group has-feedback">
            <div class="input-group">
                <input type="password" class="form-control" placeholder="Password" name="pass" id="pass">
                <span class="input-group-addon" style="cursor: pointer;" onclick="toggle_password(_('pass'), $(this))"><i class="fa fa-eye"></i></span>
            </div>
        </div>
        <div class="row">
            <div class="col-xs-8">
                <a href="<?php echo base_url() ?>users/reset-password" class="text-left" style="color:#ffffff;" title="Reset my account password">Forgot password</a><br>
                <a href="<?php echo base_url(); ?>sign-up" style="color:#ffffff;" class="text-center">Create an account</a>
            </div>
            <div class="col-xs-4">
                <button type="submit" class="btn btn-default pull-right bg-black">Sign In</button>
            </div>
        </div>
        <?php echo form_close(); ?>

    </div>
    <!-- /.form-box -->
</div>
<!-- /.register-box -->

<!-- jQuery 2.2.3 -->
<script src="<?php echo base_url(); ?>assets/plugins/jQuery/jquery-2.2.3.min.js"></script>
<!-- Bootstrap 3.3.6 -->
<script src="<?php echo base_url(); ?>assets/bootstrap/js/bootstrap.min.js"></script>
<!-- iCheck -->
<script src="<?php echo base_url(); ?>assets/plugins/iCheck/icheck.min.js"></script>
<!-- Winz custom js -->
<script src="<?php echo base_url(); ?>assets/dist/js/winz-custom.js"></script>
<script src="<?php echo base_url(); ?>assets/dist/js/winz-ajax.js"></script>

<script>
    $(function () {
        $('input').iCheck({
            checkboxClass: 'icheckbox_square-blue',
            radioClass: 'iradio_square-blue',
            increaseArea: '20%' // optional
        });
    });
</script>
</body>
</html>
