<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title><?php echo SITE_TITLE; ?> - Sign Up</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <link rel="shortcut icon" href="<?php echo base_url(); ?>assets/img/favicon.png" type="image/x-icon">
    <!-- Bootstrap 3.3.6 -->
    <link rel="stylesheet" href="<?php echo base_url(); ?>assets/bootstrap/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="<?php echo base_url(); ?>assets/plugins/font-awesome/css/font-awesome.min.css">
    <!-- Ionicons -->
    <link rel="stylesheet" href="<?php echo base_url(); ?>assets/ionicons-2.0.1/css/ionicons.min.css">
    <!-- Theme style -->
    <link rel="stylesheet" href="<?php echo base_url(); ?>assets/dist/css/AdminLTE.min.css">
    <!-- iCheck -->
    <link rel="stylesheet" href="<?php echo base_url(); ?>assets/plugins/iCheck/square/blue.css">

    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
</head>
<body class="hold-transition register-page" style="background: url('<?php echo base_url(); ?>assets/img/user-background.jpg') center center fixed; background-size:cover">
<div class="register-box">
    <div class="register-logo bottom-2x">
        <?php
        $logo = $this->Util_model->get_option("site_logo");
        if ($logo) {
            $logo = base_url().$logo;
            echo "<a href='".base_url()."'><img src='$logo' class='logo' style='width:90%; height:auto; margin:0px auto;'></a>";
        } else {
            echo "<a href='".base_url()."'><?php echo SITE_TITLE; ?></a>";
        }
        ?>
    </div>

    <div class="register-box-body" style="background-color:#daa517; border-radius:10px; color:#ffffff; box-shadow:0px 0px 10px #000;">
        <div class="col-xs-12 no-padding"><?php echo userdata("msg"); ?></div>
        <p class="login-box-msg">Create An Account</p>

        <?php echo form_open(base_url()."sign-up"); ?>
            <div class="form-group has-feedback">
                <input type="text" name="name" class="form-control" placeholder="Full name" value="<?php echo set_value('name'); ?>">
                <span class="glyphicon glyphicon-user form-control-feedback"></span>
            </div>
            <div class="form-group has-feedback">
                <input type="text" name="username" class="form-control" placeholder="Username" value="<?php echo set_value('username'); ?>">
                <span class="fa fa-at form-control-feedback"></span>
            </div>
            <div class="form-group has-feedback">
                <input type="email" name="email" class="form-control" placeholder="Email" value="<?php echo set_value('email'); ?>">
                <span class="glyphicon glyphicon-envelope form-control-feedback"></span>
            </div>
            <div class="form-group has-feedback">
                <select name="country" class="form-control" onchange="processAjax('<?php echo base_url(); ?>ajax/get-phone-code', 'id='+$(this).val(), _('phone_code'));">
                    <?php echo $this->Util_model->list_from_table("countries", "id", "name", "", "161"); ?>
                </select>
                <span class="fa fa-globe form-control-feedback" style="margin-right: 10px"></span>
            </div>
            <div class="input-group has-feedback" style="margin-bottom: 15px">
                <span class="input-group-addon">+<span id="phone_code">234</span></span>
                <input type="tel" name="phone" class="form-control" placeholder="Phone number" value="<?php echo set_value('phone'); ?>">
                <span class="fa fa-phone form-control-feedback"></span>
            </div>
            <div class="input-group has-feedback" style="margin-bottom: 15px">
                <input type="password" name="password" id="password" class="form-control" placeholder="Password">
                <span class="input-group-addon" style="cursor: pointer;" onclick="toggle_password(_('password'), $(this))"><i class="fa fa-eye"></i></span>
            </div>
            <div class="form-group has-feedback">
                <input type="text" class="form-control" name="ref" id="ref" <?php echo ($ref_id == "")?"":"readonly"; ?> placeholder="Who referred you? (Referral Code)" value="<?php echo ($ref_id == "")?set_value('ref'):$ref_id; ?>">
                <span class="fa fa-sitemap form-control-feedback"></span>
            </div>
            <div class="form-group">
                <div class="checkbox icheck"></div>
                    <label>
                        <input type="checkbox" name="terms"> I agree to the <a href="#" style="color:#ffffff; text-decoration:underline;">terms</a>
                    </label>
                </div>
                <button type="submit" class="btn btn-default btn-block btn-flat bg-black pull-right" style="border-radius:20px;">Register</button>
            </div>
            <div class="col-xs-12 text-center" style="padding-top:5px">
                <a href="<?php echo base_url(); ?>sign-in" class="btn btn-warning btn-sm" style="margin-top:10px">I already have an account</a>
            </div>
        <?php echo form_close(); ?>
        
    </div>
    <!-- /.form-box -->
</div>
<!-- /.register-box -->

<!-- jQuery 2.2.3 -->
<script src="<?php echo base_url(); ?>assets/plugins/jQuery/jquery-2.2.3.min.js"></script>
<!-- Bootstrap 3.3.6 -->
<script src="<?php echo base_url(); ?>assets/bootstrap/js/bootstrap.min.js"></script>
<!-- iCheck -->
<script src="<?php echo base_url(); ?>assets/plugins/iCheck/icheck.min.js"></script>
<!-- Winz custom js -->
<script src="<?php echo base_url(); ?>assets/dist/js/winz-custom.js"></script>
<script src="<?php echo base_url(); ?>assets/dist/js/winz-ajax.js"></script>

<script>
    $(function () {
        $('input').iCheck({
            checkboxClass: 'icheckbox_square-blue',
            radioClass: 'iradio_square-blue',
            increaseArea: '20%' // optional
        });
    });

</script>
</body>
</html>
