
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-xs-12" id="msg">
                <?php echo userdata('msg'); ?>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                <!-- small box -->
                <div class="small-box bg-purple-active text-center">
                    <div class="inner text-center">
                        <h4>Balance</h4>
                        <?php //echo $this->Util_model->get_user_currency(userdata(UID)); ?>
                        <h2><?php echo $this->Main_model->get_balance(userdata(UID), true); ?></h2>
                        <p>This Month <?php echo $this->Main_model->get_balance(userdata(UID), true, false, true); ?></p>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-4 col-sm-6 col-xs-6">
                <!-- small box -->
                <div class="small-box bg-green-active text-center">
                    <div class="inner text-center">
                        <h4>Credit</h4>
                        <?php //echo $this->Util_model->get_user_currency(userdata(UID)); ?>
                        <h2><?php echo NGN.number_format($this->Util_model->sum_field("user_wallet", "amount", "WHERE creditor=".userdata(UID)." AND status=1")); ?></h2>
                        <p>This Month <?php echo NGN.number_format($this->Util_model->sum_field("user_wallet", "amount", "WHERE creditor=".userdata(UID)." AND status=1 AND date LIKE '".date("Y-m")."%'")); ?></p>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-4 col-sm-6 col-xs-6">
                <!-- small box -->
                <div class="small-box bg-red-active text-center">
                    <div class="inner text-center">
                        <h4>Debit</h4>
                        <?php //echo $this->Util_model->get_user_currency(userdata(UID)); ?>
                        <h2><?php echo NGN.number_format($this->Util_model->sum_field("user_wallet", "amount", "WHERE debitor=".userdata(UID)." AND status=1")); ?></h2>
                        <p>This Month <?php echo NGN.number_format($this->Util_model->sum_field("user_wallet", "amount", "WHERE debitor=".userdata(UID)." AND status=1 AND date LIKE '".date("Y-m")."%'")); ?></p>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12">
                <div class="box no-border">
                    <div class="box-header no-padding">
                        <div class="nav-tabs-custom">
                            <ul class="nav nav-tabs">
                                <li <?php if ($pane == "wallet") echo 'class="active"'; ?>><a href="<?php echo base_url(); ?>transactions">Funding</a></li>
                                <li <?php if ($pane == "saving") echo 'class="active"'; ?>><a href="<?php echo base_url(); ?>transactions/saving">Saving</a></li>
                                <li <?php if ($pane == "investment") echo 'class="active"'; ?>><a href="<?php echo base_url(); ?>transactions/investment">Investment</a></li>
                                <li <?php if ($pane == "project") echo 'class="active"'; ?>><a href="<?php echo base_url(); ?>transactions/project">Project</a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped transTable">
                                <thead>
                                <tr>
                                    <th></th>
                                    <th class="text-center">Time</th>
                                    <th class="text-center">Status</th>
                                    <th class="text-center">Amount</th>
                                    <?php if ($pane == "wallet") : ?>
                                    <th class="text-center">Type</th>
                                    <?php endif; ?>
                                    <th class="text-center">From</th>
                                    <th class="text-center">To</th>
                                    <th class="text-center">Reference</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php
                                if ($transactions->num_rows() > 0) {
                                    foreach ($transactions->result_array() as $row) {
                                        $amount = $row['amount'];
                                        $deposit_withdraw = ($row['creditor'] == userdata(UID)) ? "<i class='fa fa-plus text-green'></i>" : "<i class='fa fa-minus text-red'></i>";

                                        if ($row['status'] == 0) {
                                            $status = "<span class='text-red'>Pending</span>";
                                        } else if ($row['status'] == 1) {
                                            $status = "<span class='text-green'>Success</span>";
                                        } else if ($row['status'] == 2) {
                                            $status = "<span class='text-gray'>Failed</span>";
                                        }
                                        
                                        if ($row['debitor'] == 0) {
                                            $from = "Big Real";
                                        } else if ($row['debitor'] == userdata(UID)) {
                                            $from = "Me";
                                        } else {
                                            $from = $this->Util_model->get_user_info($row['debitor'],'username','profile');
                                        }
                                        if ($row['creditor'] == 0) {
                                            $to = "Big Real";
                                        } else if ($row['creditor'] == userdata(UID)) {
                                            $to = "Me";
                                        } else {
                                            $to = $this->Util_model->get_user_info($row['creditor'],'username','profile');
                                        }
                                        echo "
                                            <tr class='text-center'>
                                                <td>$deposit_withdraw</td>
                                                <td>$row[date]</td>
                                                <td>$status</td>
                                                <td>".NGN.number_format($amount, 2)."</td>";
                                                if ($pane == "wallet") {
                                                    echo "<td>$row[type]</td>";
                                                }
                                                echo "
                                                <td>$from</td>
                                                <td>$to</td>
                                                <td>$row[ref]</td>
                                            </tr>\n
                                        ";
                                    }
                                }
                                ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!-- /.box-body -->
                    <div class="box-footer">
                        <small class="text-warning">NB: Slide table left on <i>mobile</i></small>
                    </div>
                    <!--/.box-footer-->
                </div>
                <!-- /.box -->
            </div>

            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                <?php if ($this->Util_model->get_user_info(userdata(UID), "duration", "profile") > 0) : ?>
                    <?php $this->load->view("layouts/buy_sell_coin"); ?>
                <?php else : ?>
                    <div class="box box-widget widget-user">
                        <!-- Add the bg color to the header using any of the bg-* classes -->
                        <?php
                        $uid = userdata(UID);
                        $main = $this->Util_model->get_info("user_main", "name, date", "WHERE uid=$uid");
                        $pro = $this->Util_model->get_info("user_profile", "*", "WHERE uid=$uid");
                        $centre = $this->Util_model->get_info("centre", "*", "WHERE cid='".$this->Util_model->get_user_info($uid, "cid", "profile")."'");
                        ?>
                        <div class="widget-user-header bg-yellow-active">
                            <h3 class="widget-user-username"><?php echo $main['name']; ?></h3>
                            <h5 class="widget-user-desc">@<?php echo $pro['username']; ?></h5>
                        </div>
                        <div class="widget-user-image">
                            <img class="img-circle" src="<?php echo base_url().$this->Util_model->picture($uid); ?>" alt="<?php echo $pro['username']; ?>">
                        </div>
                        
                        <div class="box-footer no-padding">
                            <ul class="nav nav-stacked">
                                <li><a href="#">Phone <span class="pull-right text-bold"><?php echo $pro['phone_code'].$pro['phone'] ?></span></a></li>
                                <li><a href="#">Email <span class="pull-right text-bold"><?php echo $pro["email"]; ?></span></a></li>
                                <li><a href="#">Referred by <span class="pull-right text-bold"><?php echo $this->Util_model->get_user_info($this->Util_model->get_user_info($uid, "ref1", "referrer")); ?></span></a></li>
                                <li><a href="#">Registered on <span class="pull-right text-bold"><?php echo $main['date']; ?></span></a></li>
                            </ul>
                        </div>
                    </div>
                    <!-- /.widget-user -->
                <?php endif; ?>
            </div>
        </div>
        <!--/.row-->
    </section>

<!-- DataTables -->
<script src="<?php echo base_url(); ?>assets/plugins/datatables/jquery.dataTables.min.js"></script>
<script src="<?php echo base_url(); ?>assets/plugins/datatables/dataTables.bootstrap.min.js"></script>
<!-- date-picker -->
<script src="<?php echo base_url(); ?>assets/plugins/datepicker/bootstrap-datepicker.js"></script>

<script>
    $(function () {

        $('.transTable').DataTable({
            "order":[1, "desc"]
        });

    });
</script>
