
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-xs-12" id="msg">
                <?php echo userdata('msg'); ?>
            </div>
        </div>
        <div class="row">
            <div class="s-start-grid col-lg-8 col-md-8 col-sm-12 col-xs-12">
                <div class="box no-border">
                    <div class="box-header no-padding">
                        <div class="nav-tabs-custom tab-warning">
                            <ul class="nav nav-tabs">
                                <li <?php echo ($pane == "self") ? 'class="active"' : ''; ?>><a href="<?php echo base_url(); ?>transfer">To Self</a></li>
                                <li <?php echo ($pane == "someone") ? 'class="active"' : ''; ?>><a href="<?php echo base_url(); ?>transfer/someone">To Someone</a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="box-body">
                        <?php if ($pane == "self") : ?>
                            <?php echo form_open(base_url()."wallet/process-transfer/self"); ?>
                                <div class="form-group">
                                    <label>Receiving Account <span class="required">*</span></label>
                                    <select class="form-control" name="recipient">
                                        <option value="user_wallet_saving">Savings</option>
                                        <option value="user_wallet_investment">Investment</option>
                                        <option value="user_wallet_project">Project</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label>Amount <span class="required">*</span></label>
                                    <div class="input-group">
                                        <span class="input-group-addon">USD</span>
                                        <input class="form-control amount" name="amount" type="number" min="1" placeholder="Enter amount in USD to transfer">
                                    </div>
                                </div>
                                <hr>
                                <div class='form-group'>
                                    <label>Account Password <span class="required">*</span></label>
                                    <input class='form-control' name='password' type='password' placeholder='Verify transaction'>
                                </div>
                                <div class="col-xs-12 top-2x no-padding">
                                    <button class="btn btn-primary btn-block" type="submit">Transfer Fund</button> 
                                </div>
                            <?php echo form_close(); ?>
                        <?php else : ?>
                            <?php echo form_open(base_url()."wallet/process-transfer/someone"); ?>
                                <div class="form-group">
                                    <label>Recipient <span class="required">*</span></label>
                                    <input class="form-control" type="text" placeholder="Username or Email" name="recipient" id="recipient" onblur="if ($(this).val() != '') { verify_recipient('<?php echo base_url(); ?>wallet'); }" required>
                                    <p id="recipient-name"></p>
                                </div>
                                <div class="form-group">
                                    <label>Amount <span class="required">*</span></label>
                                    <div class="input-group">
                                        <span class="input-group-addon">USD</span>
                                        <input class="form-control amount" name="amount" type="number" min="1" placeholder="Enter amount in USD">
                                    </div>
                                </div>
                                <hr>
                                <div class='form-group'>
                                    <label>Account Password <span class="required">*</span></label>
                                    <input class='form-control' name='password' type='password' placeholder='Verify transaction'>
                                </div>
                                <div class="col-xs-12 top-2x no-padding">
                                    <button class="btn btn-primary btn-block" type="submit">Transfer Fund</button> 
                                </div>
                            <?php echo form_close(); ?>
                        <?php endif; ?>
                    </div>
                    <div class="box-footer">
                        <p>
                            <i class="fa fa-info text-green"></i> Note<br><br>
                            <ol>
                                <li>Minimum per transaction is <?php echo number_format($this->Util_model->get_option("transfer_min")); ?> USD ie. you can't transfer below <?php echo number_format($this->Util_model->get_option("transfer_min")); ?> USD in one transaction.</li>
                                <li>Maximum per transaction is <?php echo number_format($this->Util_model->get_option("transfer_max")); ?> USD ie. you can't transfer more than <?php echo number_format($this->Util_model->get_option("transfer_max")); ?> USD in one transaction.</li>
                                <li>Wallet to wallet transfer attracts <?php echo number_format($this->Util_model->get_option("transfer_charge")); ?> USD.</li>
                            </ol>
                        </p>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                <?php $this->load->view("layouts/buy_sell_coin"); ?>
            </div>
        </div>
        <!--/.row-->
    </section>