
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-xs-12" id="msg">
                <?php echo userdata('msg'); ?>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12">
                <div class="box no-border">
                    <div class="box-header with-border">
                        <h3>Withdraw Funds</h3>
                    </div>
                    <!-- /.box-header -->
                    <?php echo form_open(base_url()."wallet/book-withdrawal"); ?>
                    <div class="box-body text-center">
                        <div class="col-lg-2 col-md-2 col-sm-1 col-xs-12"></div>
                        <div class="col-lg-8 col-md-8 col-sm-10 col-xs-12">
                            <div class="form-group">
                                <div class="input-group input-group-lg top-2x">
                                    <span class="input-group-addon">Amount (<?=NGN;?>)</span>
                                    <input class="form-control" name="amount" placeholder="Min. <?=NGN;?>1,000 - <?=NGN;?>500,000" min="1000" max="500000" autocomplete="off" value="<?php echo userdata("amount"); ?>">
                                </div>
                            </div>
                            <button class="btn btn-success btn-lg top-1x bottom-5x" type="submit">Make Withdrawal</a>
                        </div>
                        <div class="col-lg-2 col-md-2 col-sm-1 col-xs-12"></div>
                    </div>
                    <?php echo form_close(); ?>
                    <!-- /.box-body -->
                </div>
                <!-- /.box -->
            </div>

            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                <?php if ($this->Util_model->get_user_info(userdata(UID), "duration", "profile") > 0) : ?>
                    <?php $this->load->view("layouts/buy_sell_coin"); ?>
                <?php else : ?>
                    <div class="box box-widget widget-user">
                        <!-- Add the bg color to the header using any of the bg-* classes -->
                        <?php
                        $uid = userdata(UID);
                        $main = $this->Util_model->get_info("user_main", "name, date", "WHERE uid=$uid");
                        $pro = $this->Util_model->get_info("user_profile", "*", "WHERE uid=$uid");
                        $centre = $this->Util_model->get_info("centre", "*", "WHERE cid='".$this->Util_model->get_user_info($uid, "cid", "profile")."'");
                        ?>
                        <div class="widget-user-header bg-yellow-active">
                            <h3 class="widget-user-username"><?php echo $main['name']; ?></h3>
                            <h5 class="widget-user-desc">@<?php echo $pro['username']; ?></h5>
                        </div>
                        <div class="widget-user-image">
                            <img class="img-circle" src="<?php echo base_url().$this->Util_model->picture($uid); ?>" alt="<?php echo $pro['username']; ?>">
                        </div>
                        
                        <div class="box-footer no-padding">
                            <ul class="nav nav-stacked">
                                <li><a href="#">Phone <span class="pull-right text-bold"><?php echo $pro['phone_code'].$pro['phone'] ?></span></a></li>
                                <li><a href="#">Email <span class="pull-right text-bold"><?php echo $pro["email"]; ?></span></a></li>
                                <li><a href="#">Referred by <span class="pull-right text-bold"><?php echo $this->Util_model->get_user_info($this->Util_model->get_user_info($uid, "ref1", "referrer")); ?></span></a></li>
                                <li><a href="#">Registered on <span class="pull-right text-bold"><?php echo $main['date']; ?></span></a></li>
                            </ul>
                        </div>
                    </div>
                    <!-- /.widget-user -->
                <?php endif; ?>
            </div>
        </div>
        <!--/.row-->
    </section>

<!-- DataTables -->
<script src="<?php echo base_url(); ?>assets/plugins/datatables/jquery.dataTables.min.js"></script>
<script src="<?php echo base_url(); ?>assets/plugins/datatables/dataTables.bootstrap.min.js"></script>

<script>
    $(function () {

        $('#transTable').DataTable({
            "order":[0, "desc"]
        });

        _("fiat-pay").click(function() {
            var amount = ___("fiat-amount");
            if (amount < 1) {
                msg("<i class='fa fa-times-cirlce'></i> Minimum deposit amount is <?php echo USD; ?>1", "alert-danger", 1, _("msg"));
            } else if (amount > 10000) {
                msg("<i class='fa fa-times-cirlce'></i> Maximum deposit amount is <?php echo USD; ?>10,000", "alert-danger", 1, _("msg"));
            } else {
                window.location = "<?php echo base_url(); ?>wallet/initialize-deposit/"+amount;
            }
        })

    });

    function update_withdraw_status (ref, status, type) {
        var type = (!type) ? "merchant" : type;
        $.post('<?php echo base_url(); ?>wallet/withdraw_status', {"reference":ref, "status":status, "type":type}, function () {
            msg("<i class='fa fa-check-circle'></i> Status updated successfully", "alert-success", 1, _('msg'));
            reloadPage(200);
        });
    }

</script>
