/**
 * Created by testing on 8/25/2018.
 */

 function upload_profile_picture () {
    $("#user-img").click();
    $("#user-img").change(function() {
        $("#btn-upload").html("<i class='fa fa-spinner fa-spin'></i> Uploading");
        $("#btn-upload").attr("disabled", "disabled");
        $("#img-submit").click();
    });
}

function add_to_cart (ele, base_url, item_id) {
    ele.html("<i class='fa fa-spinner fa-spin'></i> Adding...");
    ele.attr("disabled", "disabled");
    $.ajax({
        "type"          :   "POST",
        "url"           :   base_url + "store/add_to_cart",
        "dataType"      :   "json",
        "data"          :   {"item_id":item_id},
        "success"       :   function (data) {
            if (data['status']) {
                $("#items_in_cart").text(data['items']);
                msg("<i class='fa fa-check-circle'></i> "+data['message'], "alert-success", 1, $("#msg"));
            } else {
                msg("<i class='fa fa-times-circle'></i> "+data['message'], "alert-danger", 1, $("#msg"));
            }
            ele.html('Buy Now');
            ele.removeAttr("disabled");
        },
        "error"         :   function () {
            msg("<i class='fa fa-times-circle'></i> An error occurred", "alert-danger", 1, $("#msg"));
            ele.html('Buy Now');
            ele.removeAttr("disabled");
        }
    });
}

function add_item_count (base_url, item_id, item_count) {
    $("#cart_list").html("<i class='fa fa-spinner fa-spin'></i> Loading...");
    $.ajax({
        "type"          :   "POST",
        "url"           :   base_url + "store/add_item_count/" + item_id,
        "dataType"      :   "json",
        "data"          :   {"item_count":item_count},
        "success"       :   function (data) {
            if (data['status']) {
                $("#cart_list").html(data['pane']);
            } else {
                $("#cart_list").html(data['pane']);
                msg("<i class='fa fa-times-circle'></i> "+data['message'], "alert-danger", 1, $("#msg"));
            }
        },
        "error"         :   function () {
            msg("<i class='fa fa-times-circle'></i> An error occurred", "alert-danger", 1, $("#msg"));
        }
    });
}

function pay_from_wallet (base_url) {
    if (isNaN(___('wallet-pay'))) {
        msg("<i class='fa fa-times-circle'></i> The value must be a number", "alert-danger", 1, $("#msg"));
    } else {
        $.ajax({
            "type": "POST",
            "url": base_url + "store/wallet_pay",
            "dataType": "json",
            "data": {"selling_price": ____("selling_price"), "wallet_pay": ___("wallet-pay")},
            "success": function (data) {
                if (!data['status']) {
                    msg("<i class='fa fa-times-circle'></i> " + data['message'], "alert-danger", 1, $("#msg"));
                    _("wallet-pay").val("");
                }
                _("total-amt").text(data['selling_price']);
                _("exp-earnings").text(data['exp_earnings']);
            },
            "error": function () {
                msg("<i class='fa fa-times-circle'></i> An error occurred", "alert-danger", 1, $("#msg"));
            }
        });
    }
}

function confirm_order (base_url) {
    if (
        ___("addr-fname") == "" ||
        ___("addr-lname") == "" ||
        ___("addr-phone1") == "" ||
        ___("addr-address") == "" ||
        ___("addr-state") == "" ||
        ___("addr-lga") == ""
    ) {
        msg("<i class='fa fa-times-circle'></i> Required field(s) empty.", "alert-danger", 1, $("#msg"));
        window.location = base_url + "store/checkout#address"
    } else {
        $.ajax({
            "type": "POST",
            "url": base_url + "store/confirm_order",
            "dataType": "json",
            "data": {
                'fname' : ___('addr-fname'),
                'lname' : ___('addr-lname'),
                'phone_code1' : ___('addr-phone1-code'),
                'phone1' : ___('addr-phone1'),
                'phone_code2' : ___('addr-phone2-code'),
                'phone2' : ___('addr-phone2'),
                'address' : ___('addr-address'),
                'landmark' : ___('addr-landmark'),
                'state' : ___('addr-state'),
                'lga' : ___('addr-lga'),
                'paid' : ___('wallet-pay')
            },
            "success": function (data) {
                if (data['status']) {
                    window.location = data['redirect'];
                } else {
                    msg("<i class='fa fa-times-circle'></i> "+data['message'], "alert-danger", 1, $("#msg"));
                }
                //msg(data['name']+" "+data['paid'], "alert-success", 1, $("#msg"));
            },
            "error": function () {
                msg("<i class='fa fa-times-circle'></i> An error occurred", "alert-danger", 1, $("#msg"));
            }
        });
    }
}

function loan_repay_cal () {
    if (isNaN(___("loan-amount") && ___("loan-amount") != "")) {
        msg("<i class='fa fa-times-circle'></i> Amount must be a number", "alert-danger", 1, _("loan-msg"), 1);
        _("loan-amount").val("");
        _("repay-amt").text("0.00");
    } else {
        var amt = (___("loan-amount") == "") ? 0 : ___("loan-amount");
        var per = (amt * 30) / 100;
        var repay = parseFloat(amt) + parseFloat(per);
        _("repay-amt").text(repay);
    }
}

function request_for_loan (base_url) {
    _('loan-request').html("<i class='fa fa-spinner fa-spin'></i> Requesting...");
    _('loan-request').attr("disabled", "disabled");
    if (___("pin") == "") {
        msg("<i class='fa fa-times-circle'></i> PIN field empty", "alert-danger", 1, _("loan-msg"), 1);
        _('loan-request').html("REQUEST FOR LOAN");
        _('loan-request').removeAttr("disabled");
    } else if (isNaN(___("loan-amount")) || ___("loan-amount") == 0) {
        msg("<i class='fa fa-times-circle'></i> Amount must be a number", "alert-danger", 1, _("loan-msg"), 1);
        _('loan-request').html("REQUEST FOR LOAN");
        _('loan-request').removeAttr("disabled");
    } else if (___("loan-amount") < 1000) {
        msg("<i class='fa fa-times-circle'></i> Amount must not be less than NGN 1,000", "alert-danger", 1, _("loan-msg"), 1);
        _('loan-request').html("REQUEST FOR LOAN");
        _('loan-request').removeAttr("disabled");
    } else if (___("loan-amount") > 9999999) {
        msg("<i class='fa fa-times-circle'></i> Amount must not be greater than NGN 9,999,999", "alert-danger", 1, _("loan-msg"), 1);
        _('loan-request').html("REQUEST FOR LOAN");
        _('loan-request').removeAttr("disabled");
    } else {
        $.ajax({
            "type": "POST",
            "url": base_url + "loan/request_loan",
            "dataType": "json",
            "data": {"amount": ___("loan-amount"), "pin": ___("pin")},
            "success": function (data) {
                if (data['status']) {
                    window.location = data['redirect'];
                } else {
                    msg("<i class='fa fa-times-circle'></i> " + data['message'], "alert-danger", 1, $("#loan-msg"), 1);
                    _("loan-amount").val("");
                    _("pin").val("");
                }
                _('loan-request').html("REQUEST FOR LOAN");
                _('loan-request').removeAttr("disabled");
            },
            "error": function () {
                msg("<i class='fa fa-times-circle'></i> An error occurred", "alert-danger", 1, $("#loan-msg"), 1);
                _('loan-request').html("REQUEST FOR LOAN");
                _('loan-request').removeAttr("disabled");
            }
        });
    }
}

function post_testimony (base_url) {
    _('btn-testimony').html("<i class='fa fa-spinner fa-spin'></i> Posting...");
    _('btn-testimony').attr("disabled", "disabled");
    if (___("testimony") == 0) {
        msg("Empty testimony", "", 0, _("testimony-msg"), 1);
        _('btn-testimony').html("Post");
        _('btn-testimony').removeAttr("disabled");
    } else {
        $.post(base_url + "ajax/post_testimony", {"testimony":___("testimony")}, function (data) {
            if (data) {
                msg("Post for review", "", 0, _("testimony-msg"), 1);
                _("testimony").val("");
            } else {
                msg("An error occurd", "", 0, _("testimony-msg"), 1);
            }
            _('btn-testimony').html("Post");
            _('btn-testimony').removeAttr("disabled");
        });
    }
}

function show_more_testimonies (base_url, page, ele) {
    $.post(base_url + "ajax/show_more_testimonies", {"page":page}, function (data) {
        _("testimonies").append(data);
        ele.remove();
    });
}

function alert_modal (header, body, footer, size) {
    $("#gen-modal .modal-dialog").removeClass("modal-sm");
    $("#gen-modal .modal-dialog").removeClass("modal-lg");
    if (size) {
        switch (size) {
            case "sm":
                $("#gen-modal .modal-dialog").addClass("modal-sm");
                break;
            case "lg":
                $("#gen-modal .modal-dialog").addClass("modal-lg");
                break;
        }
    }
    header = "<div class='modal-header'>" +
        "<button class='close' type='button' data-dismiss='modal' arial-label='Close'></button>" +
        "<h4 class='modal-title'>" + header + "</h4>" +
    "</div>";
    body = "<div class='modal-body'>" +
        "<p>" + body + "</p>" +
    "</div>";
    footer = "<div class='modal-footer'>" +
        "<button class='btn pull-left' type='button' data-dismiss='modal'>Close</button>" +
        "<span class='pull-right'>" + footer + "</span>" +
    "</div>";

    $("#gen-modal-content").html(header + body + footer);
    $("#gen-modal").modal("show");
}

function verify_password (process_url) {
    var body = "<p class='text-center'>";
    body += "<i class='fa fa-lock fa-2x'></i><br>";
    body += "<small class='text-muted'>Enter your password to confirm transaction<br></small>";
    body += "</p>";
    body += "<div class='form-group'>";
    body += "<input class='form-control text-center' id='verify-pass' type='password' placeholder='Enter passowrd here'>";
    body += "</div>";
    var footer = "<button class='btn btn-primary' type='button' onclick='if (___(\"verify-pass\") != \"\") { $(this).html(\"Processing...\"); $(this).attr(\"disabled\", \"disabled\"); window.location = \""+process_url+"password=\"+encodeURIComponent(___(\"verify-pass\")); }'>Verify</button>";
    
    alert_modal("Verify Password", body, footer, "sm");
}

