/**
 * Created by testing on 12/24/2019.
 */

function invest_amount (ele, roi, amt_ele) {
    if (isNaN(ele.val()) || ele.val().trim() == "" || ele.val() == 0) {
        amt_ele.text("0.00 MEX");
    } else if (ele.val() > 100000) {
        msg("<i class='fa fa-times-circle'></i> Amount must not be greater than 100000 MEX", "alert-danger", 1, _("msg"));
    } else {
        var total = parseFloat(get_percentage(ele.val(), roi));
        amt_ele.text(numberWithCommas(total)+" MEX");
    }
}

function invest (ele, plan, min) {
    var amount = ___("amt"+plan);
    if (amount > 100000) {
        msg("<i class='fa fa-times-circle'></i> Amount must not be greater than 100000 MEX", "alert-danger", 1, _("msg"));
    } else if (amount >= parseFloat(min)) {
        ele.html("<i class='fa fa-spinner fa-spin'></i> Processing");
        __("btn-invest").attr("disabled", "disabled");
        $.post(base_url+"home/invest", {"plan":plan, "amount":amount}, function (data) {
            if (data['return'] == 1) {
                msg(data['msg'], "alert-success", 1, _("msg"));
                processAjax(base_url+"ajax/get_balance", "", _("main-balance"));
            } else {
                msg(data['msg'], "alert-danger", 1, _("msg"));
            }
            ele.text("Invest");
            __("btn-invest").removeAttr("disabled");
        }, "json");
    } else {
        msg("<i class='fa fa-times-circle'></i> Amount must not be less than "+numberWithCommas(min)+" MEX", "alert-danger", 1, _("msg"));
    }
}

function update_status (table, status, id) {
    $.post(base_url+"ajax/update_status", "table="+table+"&status="+status+"&id="+id, function (data) {
        if (data) {
            msg("<i class='fa fa-check-circle'></i> Updated successfully. <a href='javascript:;' onclick='reloadPage()'>Reload Page</a>", "alert-success", 1, _("msg"));
        } else {
            msg("<i class='fa fa-check-circle'></i> Unsuccessful: An error occurred", "alert-danger", 1, _("msg"));
        }
    });
}

function crypto_payment (amt, method) {
    if (amt == "" || amt < 100) {
        msg("<i class='fa fa-times-circle'></i> Amount must not be less than 200 USD", "alert-danger", 1, _("msg"));
    } else {
        window.location = base_url + "home/crypto_payment/"+amt+"/"+method;
    }
}

function withdraw (ele, amount, method, inputs) {
    ele.html("<i class='fa fa-spinner fa-spin'></i> Processing");
    ele.attr("disabled", "disabled");
    if (amount < 100) {
        msg("<i class='fa fa-times-circle'></i> Withdrawal amount must not be less than 100 USD", "alert-danger", 1, _("msg"));
    } else {
        var details = "";
        var empty_field = 0;
        for (var i=0; i<inputs.length; i++) {
            if (inputs.eq(i).val().trim().length == 0) {
                empty_field++;
            } else {
                details += inputs.eq(i).val() + ", ";
            }
        }
        if (empty_field == 0) {
            $.post(base_url + "home/withdraw-fund", {
                "amount": amount,
                "method": method,
                "details": details
            }, function (data) {
                if (data == 1) {
                    msg("<i class='fa fa-check-circle'></i> Withdrawal booked successfully.", "alert-success", 1, _("msg"));
                    window.location = base_url+"fund-list";
                } else if (data == 0) {
                    msg("<i class='fa fa-times-circle'></i> Insufficient balance. Try later", "alert-danger", 1, _("msg"));
                } else {
                    msg("<i class='fa fa-times-circle'></i> Unable to book withdrawal at the moment. Try later", "alert-danger", 1, _("msg"));
                }
            });
        } else {
            msg("<i class='fa fa-times-circle'></i> Required field(s) is empty", "alert-danger", 1, _("msg"));
        }
    }
    ele.removeAttr("disabled");
    ele.text("Withdraw Fund");
}

function convert_amt (amt, rate, ele, type) {
    if (!type || type == 'buy') {
        if (amt.val().trim() != "" || amt.val().trim() > 0) {
            var converted = amt.val().trim() / rate;
            converted = Math.round(converted, 2);
            ele.text(numberWithCommas(converted));
        } else {
            ele.text(0);
        }
    } else {
        if (amt.val().trim() != "" || amt.val().trim() > 0) {
            var converted = amt.val().trim() * rate;
            converted = Math.round(converted, 2);
            ele.text(numberWithCommas(converted));
        } else {
            ele.text(0);
        }
    }
}

function buy_coin () {
    var amt = _("amt-fiat");
    if (amt.val().trim() == "" || amt.val().trim() > 0) {
        if (amt.val().trim() < 1000) {
            msg("<i class='fa fa-times-circle'></i> Amount must not be less than 1,000 USD", "alert-danger", 1, _("msg"));
        } else if (amt.val().trim() > 200000) {
            msg("<i class='fa fa-times-circle'></i> Amount must not be greater than 200,000 USD", "alert-danger", 1, _("msg"));
        } else {
            _("btn-buy").html("<i class='fa fa-spinner fa-spin'></i> Processing");
            _("btn-buy").attr("disabled", "disabled");
            $.post(base_url + "trade/create_buy_order", {"amount": amt.val().trim()}, function (data) {
                if (!data['status']) {
                    msg("<i class='fa fa-times-circle'></i> "+data['msg'], "alert-danger", 1, _("msg"));
                } else {
                    window.location = base_url + "trade";
                }
            }, 'json');
            _("btn-buy").text("Bank transfer (P2P)");
            _("btn-buy").removeAttr("disabled");
        }
    }
}

function sell_coin () {
    var amt = _("amt-coin");
    if (amt.val().trim() == "" || amt.val().trim() > 0) {
        if (amt.val().trim() < 1000) {
            msg("<i class='fa fa-times-circle'></i> Amount must not be less than 1000 MEX", "alert-danger", 1, _("msg"));
        } else if (amt.val().trim() > 200000) {
            msg("<i class='fa fa-times-circle'></i> Amount must not be greater than 200,000 MEX", "alert-danger", 1, _("msg"));
        } else {
            _("btn-sell").html("<i class='fa fa-spinner fa-spin'></i> Processing");
            _("btn-sell").attr("disabled", "disabled");
            var input = "";
            var error = 1;
            switch (____("method")) {
                case "bank":
                    if (__("input").eq(0).val() == "" || __("input").eq(1).val() == "" || __("input").eq(2).val() == "" || __("input").eq(3).val() == "") {
                        error = 0;
                        msg("<i class='fa fa-times-circle'></i> Required field(s) empty", "alert-danger", 1, _("msg"));
                    } else {
                        error = 1;
                        input = "bank:"+__("input").eq(0).val()+",acct_num:"+__("input").eq(1).val()+",acct_name:"+__("input").eq(2).val()+",password:"+__("input").eq(3).val();
                    }
                    break;
                case "bitcoin":
                    if (__("input").eq(4).val() == "" || __("input").eq(5).val() == "") {
                        error = 0;
                        msg("<i class='fa fa-times-circle'></i> Required field(s) empty", "alert-danger", 1, _("msg"));
                    } else {
                        error = 1;
                        input = "wallet:"+__("input").eq(4).val()+",password:"+__("input").eq(5).val();
                    }
                    break;
                case "ethereum":
                    if (__("input").eq(6).val() == "" || __("input").eq(7).val() == "") {
                        error = 0;
                        msg("<i class='fa fa-times-circle'></i> Required field(s) empty", "alert-danger", 1, _("msg"));
                    } else {
                        error = 1;
                        input = "wallet:"+__("input").eq(6).val()+",password:"+__("input").eq(7).val();
                    }
                    break;
            }
            if (error == 1) {
                if (confirm("You will be charged " + (amt.val() * 0.025) + " MEX commission. Continue?")) {
                    $.post(base_url + "trade/create_sell_order", {
                        "amount": amt.val().trim(),
                        "input": input,
                        "method": ____("method")
                    }, function (data) {
                        if (data['status'] == 0) {
                            msg(data['msg'], "alert-danger", 1, _("msg"));
                        } else {
                            window.location = data['url'];
                        }
                        _("btn-sell").text("Sell Coin");
                        _("btn-sell").removeAttr("disabled");
                    }, 'json');
                } else {
                    _("btn-sell").text("Sell Coin");
                    _("btn-sell").removeAttr("disabled");
                }

            }
        }
    }
}

function post_chat (sender, receiver, trans_id, content, type, btn, ele) {
    if (content.val().trim().length > 0) {
        btn.html("<i class='fa fa-spinner fa-spin'></i>");
        $.post(base_url + "trade/post_chat", {"sender":sender, "receiver":receiver, "trans_id":trans_id, "content":content.val(), "type":type}, function (data) {
            if (data != 0) {
                ele.html(data);
                content.val("");
            }
            btn.html("<i class='fa fa-send'></i> Send");
        });
    }
}

function upload_profile_picture () {
    $("#user-img").click();
    $("#user-img").change(function() {
        $("#btn-upload").html("<i class='fa fa-spinner fa-spin'></i> Uploading");
        $("#btn-upload").attr("disabled", "disabled");
        $("#img-submit").click();
    });
}

function add_to_cart (ele, base_url, item_id) {
    ele.html("<i class='fa fa-spinner fa-spin'></i> Adding...");
    ele.attr("disabled", "disabled");
    var options = "";
    for (var i=0; i<__("options").length; i++) {
        options += __("options").eq(i).text();
        if (i < --__("options").length) {
            options += ",";
        }
    }
    $.ajax({
        "type"          :   "POST",
        "url"           :   base_url + "store/add_to_cart",
        "dataType"      :   "json",
        "data"          :   {"item_id":item_id, "options":options},
        "success"       :   function (data) {
            if (data['status']) {
                $("#items_in_cart").text(data['items']);
                msg("<i class='fa fa-check-circle'></i> "+data['message'], "alert-success", 1, $("#msg"));
            } else {
                msg("<i class='fa fa-times-circle'></i> "+data['message'], "alert-danger", 1, $("#msg"));
            }
            ele.html('Buy Now');
            ele.removeAttr("disabled");
        },
        "error"         :   function () {
            msg("<i class='fa fa-times-circle'></i> An error occurred", "alert-danger", 1, $("#msg"));
            ele.html('Buy Now');
            ele.removeAttr("disabled");
        }
    });
}

function add_item_count (base_url, item_id, item_count) {
    $("#cart_list").html("<i class='fa fa-spinner fa-spin'></i> Loading...");
    $.ajax({
        "type"          :   "POST",
        "url"           :   base_url + "store/add_item_count/" + item_id,
        "dataType"      :   "json",
        "data"          :   {"item_count":item_count},
        "success"       :   function (data) {
            if (data['status']) {
                $("#cart_list").html(data['pane']);
            } else {
                $("#cart_list").html(data['pane']);
                msg("<i class='fa fa-times-circle'></i> "+data['message'], "alert-danger", 1, $("#msg"));
            }
        },
        "error"         :   function () {
            msg("<i class='fa fa-times-circle'></i> An error occurred", "alert-danger", 1, $("#msg"));
        }
    });
}

function confirm_order () {
    if (
        ___("addr-fname") == "" ||
        ___("addr-lname") == "" ||
        ___("addr-phone1") == "" ||
        ___("addr-address") == "" ||
        ___("addr-state") == "" ||
        ___("addr-lga") == ""
    ) {
        msg("<i class='fa fa-times-circle'></i> Required field(s) empty.", "alert-danger", 1, $("#msg"));
        //window.location = base_url + "store/checkout#address"
    } else {
        $.ajax({
            "type": "POST",
            "url": base_url + "store/confirm_order",
            "dataType": "json",
            "data": {
                'fname' : ___('addr-fname'),
                'lname' : ___('addr-lname'),
                'phone_code1' : ___('addr-phone1-code'),
                'phone1' : ___('addr-phone1'),
                'phone_code2' : ___('addr-phone2-code'),
                'phone2' : ___('addr-phone2'),
                'address' : ___('addr-address'),
                'landmark' : ___('addr-landmark'),
                'state' : ___('addr-state'),
                'lga' : ___('addr-lga'),
                'total' : _('total').text()
            },
            "success": function (data) {
                if (data['status']) {
                    window.location = data['redirect'];
                } else {
                    msg("<i class='fa fa-times-circle'></i> "+data['message'], "alert-danger", 1, $("#msg"));
                }
            },
            "error": function () {
                msg("<i class='fa fa-times-circle'></i> An error occurred", "alert-danger", 1, $("#msg"));
            }
        });
    }
}

function submit_rating (sid, rate) {
    _("btn-rate").html("<i class='fa fa-spinner fa-spin'></i> Submitting...");
    $.post(base_url + "store/submit-rating", {"sid":sid, "rate":rate}, function (data) {
        if (data) {
            _("rate-body").html("<i class='fa fa-check-circle text-green'></i> Thanks, rating submitted");
            _("rate-us").remove();
        } else {
            _("rate-body").hmtl("<i class='fa fa-times-circle'></i> Sorry, rating not submitted");
        }
    });
}

function change_region (region) {
    $.post(base_url + "ajax/change_region/", {"region":region}, function (data) {
        if (data) {
            reloadPage();
        } else {
            msg("<i class='fa fa-times-cirle'></i> Error changing region. Try again", "alert-danger", 1, _("msg"));
        }
    })
}

function item_option (val, ele) {
    if (ele.text() != val) {
        ele.text(val);
    }
}
