/**
 * Created by Mr. Winz on 4/16/2018.
 */
/** Payment gateway: paystack, paypal, bitcoin **/

function cards (num) {
    var radio = $('input:radio[name=sel_card]');
    if (!num) {
        var last = radio.length - 1;
        radio[last].checked = true;
    } else {
        num = num - 1;
        radio[num].checked = true;
    }
}

function amount_to_pay (amt, ele) {
    var comm = amt * 1.016;
    if (amt >= 2500) {
        comm = parseFloat(comm) + 100;
    }
    comm = comm.toFixed(2);
    ele.text(comm);
}

function make_payment (base_url) {
    var radio = $('input:radio[name=sel_card]:checked');
    var amount_to_pay = $('#card-amount-to-pay').text().trim();
    var amount = $('#card-amount').val().trim();
    if (radio.val() == 'new') {
        if (amount < 50) {
            msg("<i class='fa fa-times-circle'></i> Amount must not be less than the $50", "alert-danger", 1, $("#msg"));
        } else if (amount > 9999999) {
            msg("<i class='fa fa-times-circle'></i> Amount must not be higher than the $9,999,999", "alert-danger", 1, $("#msg"));
        } else {
            $("#btn-pay-card").html("<i class='fa fa-spinner fa-spin'></i> Processing...");
            $("#btn-pay-card").attr("disabled","disabled");
            $.post(base_url + "wallet/get_public_payment_detail", "account=0", function(data) {
                var handler = PaystackPop.setup({
                    key: data['key'],
                    email: data['email'],
                    amount: amount_to_pay * 100,
                    currency: "USD",
                    callback: function (response) {
                        var save_card;
                        if ($("#save-card").is(":checked")) {
                            save_card = 1;
                        } else {
                            save_card = 0;
                        }
                        $.post(base_url + "wallet/initialize_card_payment", {"amount":amount, "reference":response.reference, "save_card":save_card}, function(res) {
                            if (res['status']) {
                                msg("<i class='fa fa-check-circle'></i> "+res['message'], "alert-success", 1, $("#msg"));
                                setTimeout(function() {
                                    window.location = res['redirect'];
                                }, 2000);
                            } else {
                                msg("<i class='fa fa-times-circle'></i> "+res['message'], "alert-danger", 1, $("#msg"));
                            }
                        }, "json");
                    },
                    onClose: function () {
                        $("#btn-pay-card").html("Pay");
                        $("#btn-pay-card").removeAttr("disabled");
                    }
                });
                handler.openIframe();
            }, "json");
        }
    } else {
        if (amount < 50) {
            msg("<i class='fa fa-times-circle'></i> Amount must not be less than the $50", "alert-danger", 1, $("#msg"));
        } else if (amount > 9999999) {
            msg("<i class='fa fa-times-circle'></i> Amount must not be higher than $9,999,999", "alert-danger", 1, $("#msg"));
        } else {
            $("#btn-pay-card").html("<i class='fa fa-spinner fa-spin'></i> Processing...");
            $("#btn-pay-card").attr("disabled","disabled");
            $.ajax({
                'type'      :   "POST",
                'url'       :   base_url+"wallet/auth_deposit",
                'data'      :   { 'amount':amount, 'amount_to_pay':amount_to_pay, 'card_id':radio.val() },
                'dataType'  :   "json",
                'success'   :   function (data) {
                    if (!data['status']) {
                        msg("<i class='fa fa-times-circle'></i> " + data['message'], "alert-danger", 1, $("#msg"));
                    } else {
                        msg("<i class='fa fa-check-circle'></i> "+data['message'], "alert-success", 1, $("#msg"));
                        setTimeout(function() {
                            window.location = data['redirect'];
                        }, 2000);
                    }
                    $("#btn-pay-card").html("Pay");
                    $("#btn-pay-card").removeAttr("disabled");
                },
                'error'   :   function () {
                    $("#btn-pay-card").html("Pay");
                    $("#btn-pay-card").removeAttr("disabled");
                    msg("<i class='fa fa-times-circle'></i> An error occurred during payment. Try again", "alert-danger", 1, $("#msg"));
                }
            });
        }
    }
}

function delete_card (base_url, id, ele) {
    ele.html("<i class='fa fa-spinner fa-spin'></i>");
    $.post(base_url + "wallet/delete_card", {"id":id}, function(data) {
        $("#user-cards").html(data);
    });
}

function make_other_payment (base_url) {
    var amount_to_pay = $('#other-amount-to-pay').text().trim();
    var amount = $('#other-amount').val().trim();
    if (amount < 50) {
        msg("<i class='fa fa-times-circle'></i> Amount must not be less than the $50", "alert-danger", 1, $("#msg"));
    } else if (amount > 2499) {
        msg("<i class='fa fa-times-circle'></i> Amount must not be higher than the $2,499", "alert-danger", 1, $("#msg"));
    } else {
        $("#btn-pay-other").html("<i class='fa fa-spinner fa-spin'></i> Processing...");
        $("#btn-pay-other").attr("disabled", "disabled");
        window.location = base_url+'paystack/initialize/'+amount;
    }
}

function make_withdrawal (base_url) {
    var radio = $('input:radio[name=sel_card]:checked');
    var amount = $('#amount').val().trim();
    if (radio.val() == 'new') {
        var new_bank = $('.new_bank:eq(0)').val().trim();
        var new_acct_num = $('.new_bank:eq(1)').val().trim();
        var pin = $('.new_bank:eq(2)').val().trim();
        $("#btn-pay").html("<i class='fa fa-spinner fa-spin'></i> Loading");
        $("#btn-pay").attr("disabled","disabled");
        $.post(base_url+"ajax/check-withdraw-amount",{"amount":amount},function(data) {
            var min_amount = data;
            if (new_bank == "" || new_acct_num == "" || pin == "" || pin == 0) {
                $("#btn-pay").removeAttr("disabled");
                $("#btn-pay").text("Withdraw");
                msg("<i class='fa fa-times-circle'></i> Bank, account number or PIN must not be empty.", "alert-danger", 1, $('#msg'));
            } else if (min_amount == 0) {
                $("#btn-pay").removeAttr("disabled");
                $("#btn-pay").text("Withdraw");
                msg("<i class='fa fa-times-circle'></i> Amount must not be less than the minimum withdrawal amount", "alert-danger", 1, $("#msg"));
            } else if (min_amount == 1) {
                $("#btn-pay").removeAttr("disabled");
                $("#btn-pay").text("Withdraw");
                msg("<i class='fa fa-times-circle'></i> Amount must not be higer than the maximum withdrawal amount", "alert-danger", 1, $("#msg"));
            } else {
                $.ajax({
                    'type'      :   "POST",
                    'url'       :   base_url+"ajax/initialize-withdraw",
                    'data'      :   { 'amount':amount, 'bank':new_bank, 'account_num':new_acct_num, 'pin':pin },
                    'dataType'  :   "json",
                    'success'   :   function (data) {
                        $("#btn-pay").removeAttr("disabled");
                        $("#btn-pay").text("Withdraw");
                        if (data['status'] == 0) {
                            msg("<i class='fa fa-times-circle'></i> " + data['message'], "alert-danger", 1, $("#msg"));
                        } else if (data['status'] == 1) {
                            window.location = data['redirect'];
                        }
                    },
                    'error'   :   function () {
                        $("#btn-pay").removeAttr("disabled");
                        $("#btn-pay").text("Withdraw");
                        msg("<i class='fa fa-times-circle'></i> An error occurred during withdrawal. Try again", "alert-danger", 1, $("#msg"));
                    }
                });
            }
        });
    } else {
        if (amount == "") {
            msg("<i class='fa fa-times-circle'></i> Amount must not be empty", "alert-danger", 1, $("#msg"));
        } else {
            $("#btn-pay").html("<i class='fa fa-spinner fa-spin'></i> Loading");
            $("#btn-pay").attr("disabled","disabled");
            $.post(base_url+"ajax/check-withdraw-amount",{"amount":amount},function(data) {
                var min_amount = data;
                if (min_amount == 0) {
                    msg("<i class='fa fa-times-circle'></i> Amount must not be less than the minimum withdrawal amount", "alert-danger", 1, $("#msg"));
                    $("#btn-pay").removeAttr("disabled");
                    $("#btn-pay").text("Withdraw");
                } else if (min_amount == 1) {
                    msg("<i class='fa fa-times-circle'></i> Amount must not be higer than the maximum withdrawal amount", "alert-danger", 1, $("#msg"));
                    $("#btn-pay").removeAttr("disabled");
                    $("#btn-pay").text("Withdraw");
                } else {
                    $.ajax({
                        'type'      :   "POST",
                        'url'       :   base_url+"ajax/initialize-auth-withdraw",
                        'data'      :   { 'amount':amount, 'user_bank_id':radio.val() },
                        'dataType'  :   "json",
                        'success'   :   function (data) {
                            $("#btn-pay").removeAttr("disabled");
                            $("#btn-pay").text("Withdraw");
                            if (data['status'] == 0) {
                                msg("<i class='fa fa-times-circle'></i> " + data['message'], "alert-danger", 1, $("#msg"));
                            } else if (data['status'] == 1) {
                                window.location = data['redirect'];
                            }
                        },
                        'error'   :   function () {
                            $("#btn-pay").removeAttr("disabled");
                            $("#btn-pay").text("Withdraw");
                            msg("<i class='fa fa-times-circle'></i> An error occurred during withdrawal. Try again", "alert-danger", 1, $("#msg"));
                        }
                    });
                }
            });
        }
    }
}

function verify_recipient () {
    var field = _("recipient-name");
    field.html("<i class='fa fa-spinner fa-spin'></i> Verifying recipient");
    processAjax(base_url+"ajax/verify_recipient", "recipient="+___("recipient"), field);
}

function make_transfer () {
    var btn = _("btn-pay");
    var amount = ___('amount');
    if (___("recipient") == "") {
        msg("<i class='fa fa-times-circle'></i> Recipient field must not be left empty", "alert-danger", 1, _('msg'));
    } else if (___("trans_pin") == "") {
        msg("<i class='fa fa-times-circle'></i> PIN field must not be left empty", "alert-danger", 1, _('msg'));
    } else if (amount < 50) {
        msg("<i class='fa fa-times-circle'></i> Amount must not be less than USD 50", "alert-danger", 1, _('msg'));
    } else if (amount > 10000) {
        msg("<i class='fa fa-times-circle'></i> Amount must not be less than USD 50", "alert-danger", 1, _('msg'));
    } else {
        btn.html("<i class='fa fa-spinner fa-spin'></i> Processing");
        btn.attr("disabled", "disabled");
        $.ajax({
            'type'      :   "POST",
            'url'       :   base_url+"ajax/initialize_transfer",
            'data'      :   { 'amount':amount, 'recipient':___("recipient"), 'pin':___("trans_pin") },
            'dataType'  :   "json",
            'success'   :   function (data) {
                $("#btn-pay").removeAttr("disabled");
                $("#btn-pay").text("Transfer");
                if (data['status'] == 0) {
                    msg("<i class='fa fa-times-circle'></i> " + data['message'], "alert-danger", 1, $("#msg"));
                } else if (data['status'] == 1) {
                    window.location = data['redirect'];
                }
            },
            'error'   :   function () {
                $("#btn-pay").removeAttr("disabled");
                $("#btn-pay").text("Transfer");
                msg("<i class='fa fa-times-circle'></i> An error occurred during transfer. Try again", "alert-danger", 1, $("#msg"));
            }
        });
    }
}

function cancel_payment () {
    $(".new_card").val("");
    $("#otp-pane").hide();
    $("#btn-cancel").hide();
    $("#otp").val("");
    $("#btn-pay").text("Top Up Now");
}