<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
$route['default_controller'] = 'admin';
$route['404_override'] = 'general/error404';
$route['translate_uri_dashes'] = TRUE;
$route['sign-up'] = 'users/sign-up';
$route['sign-up/(:any)'] = 'users/sign-up/$1';
$route['sign-in'] = 'users/sign-in';
$route['sign-in/(:any)/(:any)'] = 'users/sign-in/$1/$2';
$route['sign-out'] = 'users/sign-out';
$route['deposit'] = 'wallet/fund';
$route['transaction'] = 'wallet/transaction';
$route['investment/new'] = 'home/new_investment';
$route['investment'] = 'home/investment';
$route['network'] = 'home/network';
$route['transfer'] = 'wallet/transfer';
$route['send-receive'] = 'home/send_receive';
$route['connects'] = 'home/connects';
$route['about-us'] = "general/about-us";
$route['services'] = 'general/services';
$route['news'] = 'general/news';
$route['s/(:any)'] = 'store/view_store/$1/active';
$route['s/(:any)/active'] = 'store/view_store/$1/active';
$route['s/(:any)/pending'] = 'store/view_store/$1/pending';
$route['s/(:any)/cancelled'] = 'store/view_store/$1/cancelled';
$route['s/(:any)/sales'] = 'store/view_store/$1/sales';
$route['s/(:any)/orders'] = 'store/view_store/$1/orders';
$route['s/(:any)/add-item'] = 'store/view_store/$1/add_item';
$route['blog/(:num)/(:any)/(:any)'] = 'general/blog/$1/$3';
$route['blog/(:num)/(:any)'] = 'general/blog/$1';
$route['loan'] = 'home/loan';
$route['terms_conditions'] = 'general/terms_conditions';


// For Associates
$route['associate'] = 'associate/dashboard';