<?php

/**
 * Created by PhpStorm.
 * User: testing
 * Date: 8/15/2019
 * Time: 12:57 AM
 */
class Admin extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->Util_model->log_redirect();
    }

    public function index () {
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="#"><i class="fa fa-dashboard"></i> Dashboard</a></li>
        </ol>
        ';
        $data['tab'] = "dashboard";
        $data['main_content'] = 'admin/home';
        $this->load->view('layouts/main',$data);
    }

    public function users () {
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="'.base_url().'admin"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li><a href="#"><i class="fa fa-users"></i> Users</a></li>
        </ol>
        ';
        $data['style'] = "<link rel='stylesheet' href='".base_url()."assets/plugins/datatables/datatables.min.css'>";
        $data['tab'] = "users";
        $data['main_content'] = 'admin/users';
        $this->load->view('layouts/main',$data);
    }



    ########################AIRTIME TO CASH##################################

    public function airtime_cash_orders () {
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="#"><i class="fa fa-refresh"></i> Airtime To Cash</a></li>
        </ol>
        ';
        $data['tab'] = "airtime_cash_orders";
        $data['main_content'] = 'admin/airtime_cash_orders';
        $this->load->view('layouts/main',$data);
    }

    public function airtime_cash_settings () {
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="#"><i class="fa fa-refresh"></i> Airtime To Cash</a></li>
        </ol>
        ';
        $data['tab'] = "airtime_cash_settings";
        $data['main_content'] = 'admin/airtime_cash_settings';
        $this->load->view('layouts/main',$data);
    }

    public function airtime_cash_convert () {
        if ($this->Db_model->update("airtime_to_cash", ["status"=>2], "WHERE id=$_POST[id]")) {
            $details = $this->Util_model->get_info("airtime_to_cash", "*", "WHERE id=$_POST[id]");
            if ($this->Util_model->get_info("airtime_to_cash", "method", "WHERE id=$_POST[id]") == "Wallet") {
                $this->Main_model->add_to_wallet($details['amount_received'], $details['uid'], 0, "Conversion of airtime to cash", "Conversion of airtime to cash", "Airtime to cash", $details['id'], "", 1, $details['mid']);
            }
            $this->Main_model->add_to_wallet(get_percentage($details['amount'], $this->Util_model->get_option("airtime_cash_commission")), $details['mid'], 0, "Airtime to cash commission", "Airtime to cash commission", "Airtime to cash commission", $details['id'], "", 1, $details['mid']);
        }
    }

    public function airtime_cash_settings_submit () {
        $count=0;
        for ($i=0; $i<count($_POST['net_id']); $i++) {
            if ($this->Db_model->update("airtime_to_cash_numbers", ["phone"=>$_POST['phone'][$i]], "WHERE id=".$_POST['net_id'][$i])) {
                $count++;
            }
        }
        if ($count == count($_POST['net_id'])) {
            $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> Airtime to cash phone numbers updated successfully", "alert-success", 1));
        } else {
            $rem = count($_POST['net_id']) - $count;
            $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> $rem out of ".count($_POST['net_id'])." phone numbers were not updated. Check and try again.", "alert-danger", 1));
        }
        redirect(base_url()."admin/airtime_cash_settings");
    }

    public function airtime_cash_fee_submit () {
        $count=0;
        for ($i=0; $i<count($_POST['net_id']); $i++) {
            if ($this->Db_model->update("airtime_to_cash_fee", ["charge"=>$_POST['charge'][$i]], "WHERE net_id=".$_POST['net_id'][$i])) {
                $count++;
            }
        }
        if ($count == count($_POST['net_id'])) {
            $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> Airtime to cash fees updated successfully", "alert-success", 1));
        } else {
            $rem = count($_POST['net_id']) - $count;
            $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> $rem out of ".count($_POST['net_id'])." fees were not updated. Check and try again.", "alert-danger", 1));
        }
        redirect(base_url()."admin/airtime-cash-settings");
    }
    
    public function airtime_cash_cancel ($ref) {
        $order = $this->Util_model->get_info("airtime_to_cash", "*", "WHERE reference='$ref'");
        if ($this->Db_model->update("airtime_to_cash", ["status"=>3], "WHERE reference='$ref'")) {
            $this->session->set_flashdata("msg", alert_msg("Airtime to cash order has been cancelled.", "alert-success", 1));
        } else {
            $this->session->set_flashdata("msg", alert_mag("Unsuccessfull: An error occured.", "alert-danger", 1));
        }
        redirect(base_url()."admin/airtime-cash-orders");
    }

    #######################STORE#####################################

    public function store () {
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="#"><i class="fa fa-shopping-cart"></i> Store</a></li>
        </ol>
        ';
        $data['tab'] = "store";
        $data['main_content'] = 'admin/store';
        $this->load->view('layouts/main',$data);
    }

    public function store_item_delete ($id) {
        if ($this->Db_model->delete("store_products", "WHERE id=$id")) {
            $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> Item deleted successfully", "alert-success", 1));
        } else {
            $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Unsuccessful: Unable to delete item.", "alert-danger", 1));
        }
        redirect(base_url()."admin/store");
    }

    public function store_add_category () {
        $this->form_validation->set_rules("category", "Category", "trim|required");

        if ($this->form_validation->run() == true) {
            if ($this->Db_model->insert("store_categories", ["name"=>$this->input->post('category'), "status"=>1])) {
                $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> Category added successfully", "alert-success", 1));
            } else {
                $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Unsuccessful: Unable to add category.", "alert-danger", 1));
            }
        } else {
            $this->session->set_flashdata("msg", validation_errors());
        }
        redirect(base_url()."admin/store");
    }

    public function store_delete_category ($cat_id) {
        if ($this->Db_model->update("store_categories", ["status"=>0], "WHERE id=$cat_id")) {
            $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> Category deleted successfully", "alert-success", 1));
        } else {
            $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Unsuccessful: Error deleting category", "alert-danger", 1));
        }
        redirect(base_url()."admin/store");
    }

    public function store_add_item () {
        $this->form_validation->set_rules('name','Name','trim|required');
        $this->form_validation->set_rules('category','Category','trim|required');
        $this->form_validation->set_rules('price','Price','trim|required');

        if ($this->form_validation->run() == TRUE) {
            $picture = "";
            if (!empty($_FILES['image']['name'][0])) {
                $file = $this->Util_model->file_upload('image');
                if ($file['status']) {
                    $picture = explode("assets", $file['data']['full_path']);
                    $picture = "assets".$picture[1];
                    $resize = $this->Util_model->resize_pic("./".$picture, false, 512, 512);
                    if (!$resize['return']) {
                        $this->session->set_flashdata("msg", alert_msg("An error occured while uploading picture", "alert-danger", 1));
                        redirect(base_url()."admin/store");
                    }
                } else {
                    $this->session->set_flashdata("msg", $file['msg']);
                    redirect(base_url()."admin/store");
                }
            }  else {
                $this->session->set_flashdata("msg", alert_msg("Select a picture for the item. Try again", "alert-danger", 1));
                redirect(base_url()."admin/store");
            }

            $data = array(
                "name"          =>  ucwords($this->input->post("name")),
                "cat_id"        =>  $this->input->post("category"),
                "condition"     =>  ucfirst($this->input->post("condition")),
                "selling_price" =>  $this->input->post("price"),
                "picture"       =>  $picture,
                "status"        =>  1
            );

            if ($this->Db_model->insert("store_products", $data)) {
                $this->session->set_flashdata("msg", alert_msg("Item has been added successfully", "alert-success", 1));
            } else {
                $this->session->set_flashdata("msg", alert_msg("Unsuccessful: Unable to add item.", "alert-danger", 1));
            }

        }  else {
            $this->session->set_flashdata("msg", validation_errors());
        }

        redirect(base_url()."admin/store");
    }

    ##########################MAILER##################################

    public function newsletter () {
        $this->form_validation->set_rules("receiver", "Receiver", "required|trim");
        $this->form_validation->set_rules("subject", "Subject", "required|trim");
        $this->form_validation->set_rules("heading", "Heading", "required|trim");

        if ($this->form_validation->run() == TRUE) {
            $markups = array(
                "[HEADING]" => ucwords($this->input->post("heading")),
                "[PLAIN-TEXT]" => $this->input->post("message"),
                "[BUTTON-HREF]" => (empty($this->input->post("button_href"))) ? base_url() : $this->input->post("button_href"),
                "[BUTTON-TEXT]" => (empty($this->input->post("button_label"))) ? "Visit Our Site" : $this->input->post("button_label"),
                "[FIRST-NAME]" => ""
            );

            if ($this->Mail_model->send_mail($this->input->post("receiver"), $this->input->post("subject"), $markups)) {
                $this->session->set_flashdata('msg', alert_msg("<i class='fa fa-check-circle'></i> Message sent successfully", "alert-success", 1));

            } else {
                $this->session->set_flashdata('msg', alert_msg("<i class='fa fa-times-circle'></i> Error sending message", "alert-danger", 1));
            }
        } else {
            $this->session->set_flashdata("msg", validation_errors());
        }
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="#"><i class="fa fa-envelope"></i> Newsletter</a></li>
        </ol>
        ';
        $data['style'] = "<link href='https://cdn.jsdelivr.net/npm/summernote@0.8.16/dist/summernote.min.css' rel='stylesheet'>";
        $data['tab'] = "newsletter";
        $data['main_content'] = 'admin/newsletter';
        $this->load->view('layouts/main',$data);
    }

    ///////////////////////////////////////ALERT///////////////////////////////////

    public function alerts () {
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="#"><i class="fa fa-info-circle"></i> Alerts</a></li>
        </ol>
        ';
        $data['style'] = "<link href='https://cdn.jsdelivr.net/npm/summernote@0.8.16/dist/summernote.min.css' rel='stylesheet'>";
        $data['tab'] = "alerts";
        $data['main_content'] = 'admin/alerts';
        $this->load->view('layouts/main',$data);
    }

    public function alerts_new () {
        if ($this->Db_model->insert("alerts", ["content"=>$this->input->post('message'), "status"=>1])) {
            $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> Alert added successfully", "alert-success", 1));
        } else {
            $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Unsuccessful: an error occured. Try again later", "alert-danger", 1));
        }
        redirect(base_url()."admin/alerts");
    }

    public function alerts_status ($id, $status) {
        if ($status == 1 || $status == 0) {
            if ($this->Db_model->update("alerts", ["status"=>$status], "WHERE id=$id")) {
                $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> Alert status updated successfully", "alert-success", 1));
            } else {
                $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Unsuccessful: An error occured. Try again later.", "alert-danger", 1));
            }
        } else {
            $this->Db_model->update("alerts", ["status"=>1], "WHERE status=2");
            if ($this->Db_model->update("alerts", ["status"=>2], "WHERE id=$id")) {
                $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> Alert marked for popup successfully", "alert-success", 1));
            } else {
                $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Unsuccessful: An error occured. Try again later.", "alert-danger", 1));
            }
        }

        redirect(base_url()."admin/alerts");
    }

}

?>