<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * Created by PhpStorm.
 * User: testing
 * Date: 8/13/2020
 * Time: 11:59 AM
 */
class Api extends CI_Controller
{

    private $uid = NULL;
    private $status = NULL;

    public function __construct()
    {
        parent::__construct();
        $this->load->helper('json_output_helper');
    }

    public function authenticate($key) {
        $key_ex = explode("_", $key);
        $field = $key_ex[0]."_key";
        if ($this->Util_model->row_count("user_api_key", "WHERE `$field`='$key'") == 1) {
            $this->uid = $this->Util_model->get_info("user_api_key", "uid", "WHERE `$field`='$key'");
            $this->status = $key_ex[0];
            return true;
        } else {
            return false;
        }
    }

    public function generate_key() {
        $param = $_REQUEST;
        $uid = $param['uid'];
        if ($this->Util_model->row_count("user_profile", "WHERE uid=$uid") > 0) {
            if ($this->Util_model->row_count("user_api_key", "WHERE uid=$uid") == 0) {
                $data = [
                    "uid" => $uid,
                    "live_key" => "live_" . md5(rand(11111111, 99999999)),
                    "test_key" => "test_" . md5(rand(11111111, 99999999))
                ];
                if ($this->Db_model->insert("user_api_key", $data)) {
                    $return = [
                        "status" => true,
                        "message" => "API key generated successfully",
                        "live_key" => $data['live_key'],
                        "test_key" => $data['test_key']
                    ];
                } else {
                    $return = [
                        "status" => false,
                        "message" => "Internal server error"
                    ];
                }
            } else {
                $data = [
                    "live_key" => "live_" . md5(rand(11111111, 99999999)),
                    "test_key" => "test_" . md5(rand(11111111, 99999999))
                ];
                if ($this->Db_model->update("user_api_key", $data, "WHERE uid=$uid")) {
                    $return = [
                        "status" => true,
                        "message" => "API key generated successfully",
                        "live_key" => $data['live_key'],
                        "test_key" => $data['test_key']
                    ];
                } else {
                    $return = [
                        "status" => false,
                        "message" => "Internal server error"
                    ];
                }
            }
        } else {
            $return = [
                "status"        =>  false,
                "message"       =>  "User not a registered member"
            ];
        }
        //echo $return;
        json_output(200, $return);
    }

    public function network() {
        $network = array();
        $param = $_REQUEST;
        if ($this->authenticate($param['key'])) {
            $s = $this->Db_model->selectGroup("*", "networks");
            foreach ($s->result_array() as $row) {
                $network[] = [
                    "network_id" => $row['id'],
                    "product_id" => $row['product_id'],
                    "network" => $row['network'],
                    "logo" => base_url() . $row['logo']
                ];
            }
            $return = [
                "status" => 200,
                "message" => "Networks listed successfully",
                "content" => $network
            ];
        } else {
            $return = [
                "status" => 401,
                "message" => "Unable to authenticate user. Try generating a new API key",
                "content" => $network
            ];
        }
        json_output($return['status'], $return);
    }

    public function data_bundle() {
        ###PARAMETERS REQUIRED
        ## key=[api_key]
        ## network_id=[1:MTN, 2:AIRTEL, 3:9MOBILE, 4:GLO
        ###################################################
        $bundle = array();
        $param = $_REQUEST;
        if ($this->authenticate($param['key'])) {
            $s = $this->Db_model->selectGroup("*", "data_bundle", "WHERE network_id=" . $param['network_id'] . " AND status=1");
            if ($s->num_rows() > 0) {
                foreach ($s->result_array() as $row) {
                    $bundle[] = [
                        "bundle_id" => $row['id'],
                        "bundle" => $row['bundle'],
                        "amount" => $row['amount'],
                        "validity" => $row['validity']
                    ];
                }
                $return = [
                    "status" => 200,
                    "message" => "Bundles listed successfully",
                    "network_id" => $param['network_id'],
                    "network" => $this->Util_model->get_info("networks", "network", "WHERE id=" . $param['network_id']),
                    "content" => $bundle
                ];
            } else {
                $return = [
                    "status" => 401,
                    "message" => "Bundle list is empty. Check network ID",
                    "content" => $bundle
                ];
            }
        } else {
            $return = [
                "status" => 401,
                "message" => "Unable to authenticate user. Try generating a new API key",
                "content" => $bundle
            ];
        }
        json_output($return['status'], $return);
    }

    public function balance () {
        $param = $_REQUEST;
        if ($this->authenticate($param['key'])) {
            $balance = $this->Main_model->get_balance($this->uid, false);
            $return = [
                "status" => 200,
                "message" => "Balance fetched successfully",
                "content" => [
                    "raw_balance" => $balance,
                    "formated_balance" => "N" . number_format($balance, 1)
                ]
            ];
        } else {
            $return = [
                "status" => 401,
                "message" => "Unable to authenticate user. Try generating a new API key",
                "content" => []
            ];
        }
        json_output($return['status'], $return);
    }

    public function buy_data () {
        ###PARAMETERS REQUIRED
        ## key=[api_key]
        ## network_id=[1:MTN, 2:AIRTEL, 3:9MOBILE, 4:GLO]
        ## bundle_id=1 etc.
        ## recipient=081727773466
        ## ref=[any reference number you wish. This is optional]
        ###################################################
        $param = $_REQUEST;
        if ($this->authenticate($param['key'])) {
            $balance = $this->Main_model->get_balance($this->uid, false);
            $bundle = $this->Util_model->get_info("data_bundle", "*", "WHERE id='$param[bundle_id]'");
            $amount_to_pay = $bundle['amount'];
            $net_id = $param['network_id'];
            $network = $this->Main_model->get_network($param['recipient']);
            $recipient = $param['recipient'];
            $ref = (!isset($param['ref']) || $param['ref'] == '') ? $this->Util_model->generate_id(1111111111, 9999999999, "user_wallet", "ref", "varchar", true, "fb") : $param['ref'];
            if ($this->status == 'live') {
                if ($balance >= $bundle['amount']) {
                    $debit = $this->Main_model->add_to_wallet(
                        $amount_to_pay,
                        0,
                        $this->uid,
                        "$network[network] $bundle[bundle]",
                        "$network[network] $bundle[bundle]",
                        "Data purchase",
                        $param['bundle_id'],
                        $ref
                    );
                    if ($debit['return']) {
                        if ($this->Util_model->get_info("networks", "auto", "WHERE id=$net_id") == 0) {
                            $data_request = $this->Main_model->initialize_data_request_mannual($this->uid, $recipient, $bundle['id'], $amount_to_pay, 0, $ref);
                        } else {
                            $data_request = $this->Main_model->initialize_data_request($this->uid, $recipient, $bundle['id'], $amount_to_pay, 0, $ref);
                        }
                        if ($data_request['status']) {
                            $status = 200;
                            $msg = $data_request['message'];
                            $content = [
                                "order_id" => $data_request['order_id'],
                                "reference" => $ref,
                                "recipient" => $recipient,
                                "network" => $bundle['network_id'],
                                "bundle_id" => $bundle['id'],
                                "bundle" => $bundle['bundle'],
                                "bundle_amount" => $bundle['amount'],
                                "amount_paid" => $amount_to_pay,
                                "discount" => 0,
                                "coupon" => '',
                                "date" => date_time()
                            ];
                        } else {
                            $this->Db_model->delete("user_wallet", "WHERE debitor=" . $this->uid . " AND ref='$ref'");
                            $status = 401;
                            $msg = $data_request['message'];
                            $content = [];
                        }
                    } else {
                        $status = 500;
                        $msg = "Internal system error";
                        $content = [];
                    }
                }
            } else {
                $status = 200;
                $msg = "Data purchased successfully";
                $content = [
                    "order_id" => rand(11111111, 99999999),
                    "reference" => $ref,
                    "recipient" => $recipient,
                    "network" => $bundle['network_id'],
                    "bundle_id" => $bundle['id'],
                    "bundle" => $bundle['bundle'],
                    "bundle_amount" => $bundle['amount'],
                    "amount_paid" => $amount_to_pay,
                    "discount" => 0,
                    "coupon" => '',
                    "date" => date_time()
                ];
            }
            $return = [
                "status" => $status,
                "message" => $msg,
                "content" => $content
            ];
        } else {
            $return = [
                "status" => 401,
                "message" => "Unable to authenticate user. Try generating a new API key",
                "content" => []
            ];
        }
        json_output($return['status'], $return);
    }

}

