<?php

/**
 * Created by PhpStorm.
 * User: testing
 * Date: 9/25/2020
 * Time: 9:39 PM
 */
class Business extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->Util_model->log_redirect();
    }

    public function index () {
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="'.base_url().'admin"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li><a href="#"><i class="fa fa-briefcase"></i> Business</a></li>
        </ol>
        ';
        $data['active'] = $this->Db_model->selectGroup("*", "merchant_main", "WHERE status=1 OR status=2");
        $data['pending'] = $this->Db_model->selectGroup("*", "merchant_main", "WHERE status=0");
        $data['expired'] = $this->Db_model->selectGroup("*", "merchant_main", "WHERE status=3");
        $data['tab'] = "business";
        $data['main_content'] = 'admin/business';
        $this->load->view('layouts/main',$data);
    }

    public function activate ($mid) {
        if ($this->Util_model->row_count("merchant_business", "WHERE mid=$mid") == 0) {
            $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Merchant business not set", "alert-danger", 1));
        } else if ($this->Util_model->row_count("merchant_account", "WHERE mid=$mid") == 0) {
            $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Merchant account not set", "alert-danger", 1));
        } else {
            $data = [
                "mid"           =>  $mid,
                "start_date"    =>  date_time(),
                "end_date"      =>  get_next_prev_date(date_time(), 60, "next", "Y-m-d H:i:s")
            ];
            if ($this->Db_model->insert("merchant_expiration", $data)) {
                $this->Db_model->update("merchant_main", ["status" => 1], "WHERE mid=$mid");
                $this->Db_model->update("merchant_funding", ["status" => 1], "WHERE mid=$mid AND method='Merchant activation fee'");
                $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> Business activated successfully", "alert-success", 1));
            } else {
                $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> An error occured while activating business", "alert-danger", 1));
            }
        }
        redirect(base_url()."business");
    }

}

?>