<?php

/**
 * Created by PhpStorm.
 * User: testing
 * Date: 8/27/2018
 * Time: 5:11 PM
 */
class Cable extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->Util_model->log_redirect();
    }

    public function cable_orders () {
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="#"><i class="fa fa-tv"></i> Cable</a></li>
        </ol>
        ';
        if (isset($_POST['daterange'])) {
            $data['date'] = $this->input->post('daterange');
        } else {
            $data['date'] = date_time('d');
        }
        $data['tab'] = "cable_orders";
        $data['main_content'] = 'admin/cable_orders';
        $this->load->view('layouts/main',$data);
    }

    public function cable_settings () {
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="#"><i class="fa fa-tv"></i> Cable</a></li>
        </ol>
        ';
        $data['tab'] = "cable_settings";
        $data['main_content'] = 'admin/cable_settings';
        $this->load->view('layouts/main',$data);
    }

    public function cable_settings_submit () {
        $count=0;
        for ($i=0; $i<count($_POST['id']); $i++) {
            if (!empty($_POST['code'][$i]) && !empty($_POST['name'][$i]) && !empty($_POST['amount'][$i])) {
                $data = array(
                    "package_code"  =>  $_POST['code'][$i],
                    "name"          =>  $_POST['name'][$i],
                    "amount"        =>  $_POST['amount'][$i],
                    "status"        =>  $_POST['status'][$i]
                );
                if ($this->Db_model->update("cable_package", $data, "WHERE id=".$_POST['id'][$i])) {
                    $count++;
                }
            }
        }
        if ($count == count($_POST['id'])) {
            $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> All the packages has been updated successfully", "alert-success", 1));
        } else {
            $rem = count($_POST['id']) - $count;
            $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> $rem out of ".count($_POST['bundle'])." packages were not updated due to empty field (code, name and amount). Check and try again.", "alert-danger", 1));
        }
        redirect(base_url()."cable/cable_settings");
    }

    public function cable_settings_new () {
        $this->form_validation->set_rules("code", "Package code", "required|trim");
        $this->form_validation->set_rules("name", "Package name", "required|trim");
        $this->form_validation->set_rules("amount", "Amount", "required|trim|numeric");

        if ($this->form_validation->run() == true) {
            $data = array(
                "cable"             =>  $this->input->post('cable'),
                "package_code"      =>  $this->input->post('code'),
                "name"              =>  $this->input->post('name'),
                "amount"            =>  $this->input->post('amount'),
                "status"            =>  1
            );
            if ($this->Db_model->insert("cable_package", $data)) {
                $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> Package added successfully", "alert-success", 1));
            } else {
                $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Unable to add package. Try again", "alert-danger", 1));
            }
        } else {
            $this->session->set_flashdata("msg", validation_errors());
        }
        redirect(base_url()."cable/cable_settings");
    }

    public function cable_cancel ($ref) {
        $order = $this->Util_model->get_info("cable_purchase", "*", "WHERE reference='$ref'");
        if ($this->Db_model->update("cable_purchase", ["status"=>2], "WHERE reference='$ref'")) {
            $this->Main_model->add_to_wallet(
                $order['amount_paid'],
                $order['uid'],
                0,
                "Refund for cable tv subscription payment",
                "Refund for cable tv subscription payment",
                "Payment Refund",
                "",
                $ref,
                1
            );
            $this->session->set_flashdata("msg", alert_msg("Cable Tv  orders has been cancelled and fund returned.", "alert-success", 1));
        } else {
            $this->session->set_flashdata("msg", alert_msg("Unsuccessfull: An error occured.", "alert-danger", 1));
        }
        redirect(base_url()."cable/cable-orders");
    }

}

?>