<?php

/**
 * Created by PhpStorm.
 * User: testing
 * Date: 8/27/2018
 * Time: 5:11 PM
 */
class Data extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->Util_model->log_redirect();
    }

    public function data_orders () {
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="#"><i class="fa fa-globe"></i> Data</a></li>
        </ol>
        ';
        if (isset($_POST['daterange'])) {
            $data['date'] = $this->input->post('daterange');
        } else {
            $data['date'] = date_time('d');
        }
        $data['style'] = '<link rel="stylesheet" href="'.base_url().'assets/plugins/datepicker/datepicker3.css">';
        $data['tab'] = "data_orders";
        $data['main_content'] = 'admin/data_orders';
        $this->load->view('layouts/main',$data);
    }

    public function data_settings () {
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="#"><i class="fa fa-globe"></i> Data</a></li>
        </ol>
        ';
        $data['tab'] = "data_settings";
        $data['main_content'] = 'admin/data_settings';
        $this->load->view('layouts/main',$data);
    }

    public function data_settings_submit () {
        $count=0;
        for ($i=0; $i<count($_POST['bundle']); $i++) {
            if (!empty($_POST['bundle'][$i]) && !empty($_POST['amount'][$i])) {
                $data = array(
                    "bundle"        =>  $_POST['bundle'][$i],
                    "amount"        =>  $_POST['amount'][$i],
                    "validity"      =>  $_POST['validity'][$i],
                    "status"        =>  $_POST['status'][$i]
                );
                if ($this->Db_model->update("data_bundle", $data, "WHERE id=".$_POST['id'][$i])) {
                    $count++;
                }
            }
        }
        if ($count == count($_POST['bundle'])) {
            $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> All the bundles has been updated successfully", "alert-success", 1));
        } else {
            $rem = count($_POST['bundle']) - $count;
            $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> $rem out of ".count($_POST['bundle'])." were not updated due to empty field (bundle and amount). Check and try again.", "alert-danger", 1));
        }
        redirect(base_url()."data/data_settings");
    }

    public function data_settings_new () {
        $this->form_validation->set_rules("bundle", "Bundle name", "required|trim");
        $this->form_validation->set_rules("amount", "Amount", "required|trim|numeric");
        $this->form_validation->set_rules("validity", "Validity", "required|trim|numeric");

        if ($this->form_validation->run() == true) {
            $data = array(
                "network_id"        =>  $this->input->post('network'),
                "bundle"            =>  $this->input->post('bundle'),
                "amount"            =>  $this->input->post('amount'),
                "validity"          =>  $this->input->post('validity'),
                "status"            =>  1
            );
            if ($this->Db_model->insert("data_bundle", $data)) {
                $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> Bundle added successfully", "alert-success", 1));
            } else {
                $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Unable to add bundle. Try again", "alert-danger", 1));
            }
        } else {
            $this->session->set_flashdata("msg", validation_errors());
        }
        redirect(base_url()."data/data_settings");
    }

    public function data_cancel ($ref) {
        $order = $this->Util_model->get_info("data_purchase", "*", "WHERE reference='$ref'");
        if ($this->Db_model->update("data_purchase", ["status"=>2], "WHERE reference='$ref'")) {
            $this->Main_model->add_to_wallet(
                $order['amount_paid'],
                $order['uid'],
                0,
                "Refund for data purchase payment",
                "Refund for data purchase payment",
                "Payment Refund",
                "",
                $ref,
                1
            );
            $this->session->set_flashdata("msg", alert_msg("Data order has been cancelled and fund returned.", "alert-success", 1));
        } else {
            $this->session->set_flashdata("msg", alert_mag("Unsuccessfull: An error occured.", "alert-danger", 1));
        }
        redirect(base_url()."data/data-orders");
    }

}

?>