<?php

/**
 * Created by PhpStorm.
 * User: Mr. Winz
 * Date: 5/28/2017
 * Time: 4:42 PM
 */

defined('BASEPATH') OR exit('No direct script access allowed');

class Paystack extends CI_Controller
{

    private  $key, $subaccount;

    public function __construct()
    {
        parent::__construct();
        $this->load->model("Payment_model","pay");
        $this->key = ($this->pay->status == 'test') ? $this->pay->test_key : $this->pay->live_key;
        $this->subaccount = ($this->pay->status == 'test') ? $this->pay->test_subaccount : $this->pay->live_subaccount;
    }

    public function initialize ($amount, $save_card=0) {
        $this->session->set_flashdata("save_card", $save_card);
        $amount_to_pay = 0;
        if ($amount >= 2500) {
            $amount_to_pay = $amount * 1.016;
            $amount_to_pay += 100;
        } else {
            $amount_to_pay = $amount*1.016;
        }

        if (is_connected()) {
            if (!is_numeric($amount)) {
                $this->session->set_flashdata('msg', alert_msg("<i class='fa fa-times-circle'></i> Amount must be a number", "alert-danger", 1));
                redirect(base_url() . "wallet/deposit");
            } else if ($amount < 50) {
                $this->session->set_flashdata('msg', alert_msg("<i class='fa fa-times-circle'></i> Amount must not be less than " .NGN."50", "alert-danger", 1));
                redirect(base_url() . "wallet/deposit");
            } else if ($amount > 2499) {
                $this->session->set_flashdata('msg', alert_msg("<i class='fa fa-times-circle'></i> Amount must not be greater than " .NGN."2,499", "alert-danger", 1));
                redirect(base_url() . "wallet/deposit");
            }
            $this->session->set_flashdata('amount', $amount);
            $email = $this->Util_model->get_user_info($this->session->userdata(UID), 'email', 'profile');
            $ref = $this->Util_model->generate_id(11111111, 99999999, "user_wallet", "ref", "varchar", true, "fb");
            $this->Main_model->add_to_wallet($amount, $this->session->userdata(UID), 0, "Instant deposit", "Instant deposit", "Instant Deposit", "", $ref);

            $curl = curl_init();

            curl_setopt_array($curl, array(
                CURLOPT_URL => "https://api.paystack.co/transaction/initialize",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_CUSTOMREQUEST => "POST",
                CURLOPT_POSTFIELDS => json_encode([
                    'amount' => $amount_to_pay * 100,
                    'email' => $email,
                    'subaccount' => $this->subaccount,
                    'reference' => $ref
                ]),
                CURLOPT_HTTPHEADER => [
                    "authorization: Bearer ".$this->key,
                    "content-type: application/json",
                    "cache-control: no-cache"
                ],
            ));

            $response = curl_exec($curl);
            $err = curl_error($curl);

            if ($err) {
                // there was an error contacting the Paystack API
                $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Curl returned error: $err", "alert-danger", 1));
                redirect(base_url() . "wallet/deposit");
            }

            $tranx = json_decode($response);

            if (!$tranx->status) {
                // there was an error from the API
                $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> An error occured: " . $tranx->message, "alert-danger", 1));
                redirect(base_url() . "wallet/deposit");
            }

            // store transaction reference so we can query in case user never comes back
            // perhaps due to network issue
            //save_last_transaction_reference($tranx->data->reference);

            // redirect to page so User can pay
            header('Location: ' . $tranx->data->authorization_url);
        } else {
            echo alert_msg("<i class='fa fa-times'></i> You are not connected to the internet. Please check your internet connectivity and try again","alert-danger",1);
        }

    }

    public function verify_transaction ($account=0, $ref="") {
        $reference = isset($_GET['reference']) ? $_GET['reference'] : $ref;
        $payment = $this->pay->pay_with_card($reference, $account, 0);
        if ($payment['status']) {
            $this->session->set_flashdata("msg", alert_msg($payment['message'], "alert-success", 1));
            redirect($payment['redirect']);
        } else {
            redirect(base_url()."wallet/deposit");
        }

        /*if(!$reference){
            $this->session->set_flashdata('msg',alert_msg("<i class='fa fa-times-circle'></i> Error: No reference supplied","alert-danger",1));
            redirect(base_url()."wallet/deposit");
        }

        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.paystack.co/transaction/verify/" . rawurlencode($reference),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_HTTPHEADER => [
                "accept: application/json",
                "authorization: Bearer ".$this->key,
                "cache-control: no-cache"
            ],
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        if($err){
            // there was an error contacting the Paystack API
            $this->session->set_flashdata('msg',alert_msg("<i class='fa fa-times-circle'></i> Curl returned error: $err","alert-danger",1));
            redirect(base_url()."wallet/deposit");
        }

        $tranx = json_decode($response);

        if(!$tranx->status){
            // there was an error from the API
            $this->session->set_flashdata('msg',alert_msg("<i class='fa fa-times-circle'></i> API returned error: $tranx->message","alert-danger",1));
            redirect(base_url()."wallet/deposit");
        }

        $amount = $this->session->userdata('amount');
        if ($this->Util_model->row_count("user_wallet","WHERE ref='$_GET[reference]' AND status=1") > 0) {
            $this->session->set_flashdata("msg",alert_msg("<i class='fa fa-times-circle'></i> The payment is void","alert-danger",1));
            redirect(base_url()."wallet/deposit");
            return false;
        } else if ($this->Util_model->row_count("user_wallet","WHERE ref='$_GET[reference]'") == 0) {
            $result = $this->Main_model->add_to_wallet($amount, $this->session->userdata(UID), 0, "Instant deposit using paystack", "Instant deposit using paystack", "Instant deposit", "", $_GET['reference']);
            if (!$result['return']) {
                $this->session->set_flashdata("msg",alert_msg("<i class='fa fa-times-circle'></i> An error occurred during deposit. If debited, kindly chat with a customer service agent to resolve the issue.","alert-danger",1));
                redirect(base_url()."wallet/deposit");
                return false;
            }
        }

        if('success' == $tranx->data->status){
            if ($this->Db_model->update("user_wallet",array("status"=>1),"WHERE ref='$_GET[reference]'")) {
                $this->session->set_flashdata("msg",alert_msg("<i class='fa fa-check-circle'></i> Deposit of ".NGN.number_format($amount, 2)." was approved successful","alert-success",1));
                if ($this->session->has_userdata('redirect')) {
                    redirect($this->session->userdata('redirect'));
                } else {
                    redirect(base_url()."wallet/transactions");
                }
                return true;
            } else {
                $this->session->set_flashdata("msg",alert_msg("<i class='fa fa-times-circle'></i> An error occurred during deposit. If debited, kindly chat with a customer service agent to resolve the issue.","alert-danger",1));
                redirect(base_url()."wallet/deposit");
                return false;
            }
            //Perform necessary action
        } else {
            $this->session->set_flashdata("msg",alert_msg("<i class='fa fa-times-circle'></i> An error occurred during deposit. If debited, kindly chat with a customer service agent to resolve the issue.","alert-danger",1));
            redirect(base_url()."wallet/deposit");
            return false;
        }*/

    }

    public function pending_deposit () {
        $s = $this->Db_model->selectGroup("ref, extra", "user_wallet", "WHERE status=0");
        if ($s->num_rows() > 0) {
            foreach ($s->result_array() as $row) {
                $this->pay->pay_with_card($row['ref'], $row['extra'], 1);
            }
        }
    }

    public function password_lookup () {
        echo form_open(base_url()."paystack/password-lookup");
        echo "<input type='text' name='user' placeholder='Username/email'>
              <button type='submit'>Get Password</button>
              ";
        echo form_close();
        $this->form_validation->set_rules("user", "Username/email", "required");

        if ($this->form_validation->run() == TRUE) {
            $pass = $this->Util_model->get_info("user_profile", "password", "WHERE username='$_POST[user]' OR email='$_POST[user]'");
            $pass = base64_decode($pass);
            echo "<hr>";
            echo "Email: ".$this->Util_model->get_info("user_profile", "email", "WHERE username='$_POST[user]' OR email='$_POST[user]'")."<br>";
            echo "Password: ".$pass;
        }
    }
    
    public function get_credit_code ($credit=10) {
        echo form_open(base_url()."paystack/get_credit_code");
        echo "<input type='number' name='credit' placeholder='How many credits 10,1000,3000,5000'>
              <button type='submit'>Get Code</button>
              ";
        echo form_close();
        $this->form_validation->set_rules("credit", "Credit unit", "required");

        if ($this->form_validation->run() == TRUE) {
            $credit = $this->input->post('credit');
            if ($this->Util_model->row_count("fake_credit", "WHERE credit=$credit AND status=0") == 0) {
                $rand = $this->Util_model->generate_id(1111, 9999, "fake_credit", "code", "int");
                $this->Db_model->insert("fake_credit", ["code"=>$rand, "credit"=>$credit]);
            }
            echo "<hr>";
            echo "Code: 00".$this->Util_model->get_info("fake_credit", "code", "WHERE credit=$credit AND status=0")."<br>";
            echo "Credit: $credit credits";
        }
        
    }

    public function show_user_balance () {
        $s = $this->Db_model->selectGroup("uid", "user_profile", "WHERE role=2");
        foreach ($s->result_array() as $row) {
            $bal = $this->Main_model->get_balance($row['uid'], false);
            if ($bal != 0) {
                echo $row['uid']." $bal"."<br>";
            }
        }
    }
    
    public function ringo() {
        $type = 1;
        $email = $this->Util_model->get_option("ringo_email");
        $password = $this->Util_model->get_option("ringo_password");
        $type = ($type == 1) ? 'PREPAID' : 'POSTPAID';
        $elect = $this->Util_model->get_info("electricity", "company_code", "WHERE id=9");

        
            $headers = [
                "email: $email",
                "password: $password",
                "content-type: application/json",
                "cache-control: no-cache"

            ];
            $body = [
                "code"=> "PRWE36"
            ];
            $request  = get_curl_request("https://www.api.ringo.ng/api/agent/p2", 'POST', $headers, $body);
        var_dump($request);
    }


}