<?php

/**
 * Created by PhpStorm.
 * User: Mr. Winz
 * Date: 5/28/2017
 * Time: 4:42 PM
 */

defined('BASEPATH') OR exit('No direct script access allowed');

class Recommend extends CI_Controller
{

    public function __construct() {
        parent::__construct();
    }

    public function index () {
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="#"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li>Recommend</li>
        </ol>
        ';
        
        
        $data['tab'] = "recommend";
        $data['main_content'] = 'admin/recommend';
        $this->load->view('layouts/main',$data);
    }

    public function recommend_msg () {
        $header = "
        <h3>
            Send SMS
            <button type='button' class='close' data-dismiss='modal' aria-label='Close'>
                <span aria-hidden='true'>&times;</span>
            </button>
        </h3>";
        $body = "
        <p>Paste any message template you wish to send accross to the recommended members</p>
        <div class='well'>
            Use any of the formats below to format your text
            <p>
                <b>[FIRST NAME]:</b> For recommended first name<br> <b>[LAST NAME]:</b> For recommended last name<br>
                <b>[FULL NAME]:</b> For recommended full name<br> <b>[PHONE NUMBER]:</b> For recommended phone number<br> 
                <b>[MEMBER NAME]:</b> For the member name<br> <b>[MEMBER RELATIONSHIP]:</b> For member relationship with the recommeded<br>
                <b>[DATE]:</b> For the normal date yyyy-mm-dd<br> <b>[FULL DATE]:</b> For the formatted date 4th Jun, 2021
            </p>
        ";
        $body .= "<textarea class='form-control' name='text' placeholder='Enter your message here...' style='height:90px;'></textarea>";
        $footer = "
        <button class='btn btn-success' type='submit'>Send SMS</button>
        ";
        $view = form_open(base_url()."control/recommend-send-sms/$_POST[id]");
        $view .= "
        <div class='modal-header'>$header</div>
        <div class='modal-body'>$body</div>
        <div class='modal-footer'>$footer</div>
        ";
        $view .= form_close();
        echo $view;
    }

    public function recommend_send_sms ($id) {
        $s = $this->Db_model->selectGroup("*", "user_recommend", "WHERE id=$_POST[id]");
        if ($s->num_rows() > 0) {
            $row = $s->row_array();
            $date = explode(" ", $row['date'])[0];
            $text = trim($_POST['text']);
            $text = str_replace(
                array(
                    "[FIRST NAME]",
                    "[LAST NAME]",
                    "[FULL NAME]",
                    "[PHONE NUMBER]",
                    "[MEMBER NAME]",
                    "[MEMBER RELATIONSHIP]",
                    "[DATE]",
                    "[FULL DATE]"
                ),
                array(
                    $row['first_name'],
                    $row['last_name'],
                    "$row[first_name] $row[last_name]",
                    "$row[phone_code]$row[phone]",
                    $this->Util_model->get_user_info($row['uid']),
                    $row['relationship'],
                    $date,
                    new_date_format($date, "Y-m-d", "dS M, Y")
                ),
                $text
            );
            $recipient = ltrim($row['phone_code'].$row['phone'], '+');
            if (is_connected()) {
                $sent = $this->Main_model->send_sms($recipient, $text);
            } else {
                $sent = true;
            }
            if ($sent) {
                $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> SMS has been sent successfully", "alert-success", 1));
            } else {
                $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Error sending SMS. Try again later", "alert-danger", 1));
            }
        } else {
            $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Error sending SMS. Try again later", "alert-danger", 1));
        }
        redirect(base_url()."control/recommend");
    }

}

?>