<?php

/**
 * Created by PhpStorm.
 * User: testing
 * Date: 9/12/2019
 * Time: 1:08 AM
 */
class Trade extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model("Trade_model", "trade");
    }

    public function index () {
        $this->Util_model->log_redirect();
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="'.base_url().'"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li><i class="fa fa-exchange"></i> Trade</li>
        </ol>
        ';
        $data['tab'] = "trade";
        $data['main_content'] = 'users/trade';
        $this->load->view('layouts/main',$data);
    }

    public function create_buy_order () {
        $this->Util_model->log_redirect();
        $amount = $_POST['amount'] / $this->Util_model->get_option('coin_price');
        $this->trade->create_buy_order($amount);
        echo json_encode(["status"=>true]);
    }

    public function create_sell_order () {
        $this->Util_model->log_redirect();
        $return = $this->trade->create_sell_order($_POST['amount'], $_POST['input'], $_POST['method']);
        echo json_encode($return);
    }

    public function view_trade ($trans_id) {
        $this->Util_model->log_redirect();
        if ($this->Util_model->row_count("trans", "WHERE trans_id='$trans_id' && (buyer=".$this->session->userdata(UID)." || seller=".$this->session->userdata(UID).")") == 0) {
            $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Invalid trade", "alert-danger", 1));
            redirect(base_url()."trade");
        } else {
            $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="'.base_url().'"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li><a href="'.base_url().'trade"><i class="fa fa-exchange"></i> Trade</a></li>
            <li>Trade View</li>
        </ol>
        ';
            $data['style'] = '<link rel="stylesheet" href="'.base_url().'assets/plugins/lightbox/dist/css/lightbox.min.css">';
            $data['trans_id'] = $trans_id;
            $data['tab'] = "trade";
            $data['main_content'] = 'users/trade_view';
            $this->load->view('layouts/main',$data);
        }
    }

    public function post_chat () {
        $this->Util_model->log_redirect();
        if ($this->trade->post_chat($_POST['sender'], $_POST['receiver'], $_POST['trans_id'], $_POST['content'], $_POST['type'])) {
            echo $this->trade->list_chat($_POST['trans_id']);
        } else {
            echo 0;
        }
    }

    public function list_chat () {
        if ($this->session->has_userdata(UID)) {
            echo $this->trade->list_chat($_POST['trans_id']);
        }
    }

    public function trade_time () {
        if ($this->session->has_userdata(UID)) {
            echo date_difference($this->Util_model->get_info("trans", "expiry_date", "WHERE trans_id='$_POST[trans_id]'"), date_time(), "H:i:s");
        }
    }

    public function made_payment ($trans_id) {
        if ($this->session->has_userdata(UID)) {
            $trans = $this->Db_model->select("*", "trans", "WHERE trans_id='$trans_id'");
            if ($trans['buyer'] == $this->session->userdata(UID)) {
                $this->trade->made_payment($trans_id);
            }
        }
        redirect(base_url()."trade/view-trade/$trans_id");
    }

    public function release ($trans_id) {
        $this->Util_model->log_redirect();
        $trans = $this->Db_model->select("*", "trans", "WHERE trans_id='$trans_id'");
        if ($trans['seller'] == $this->session->userdata(UID)) {
            if ($this->trade->release_trade($trans_id)) {
                $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-checks-circle'></i> MEXcoin released to the buyer", "alert-success", 1));
            } else {
                $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> An error occurred. Try again.", "alert-danger", 1));
            }
        }
        redirect(base_url()."trade/view-trade/$trans_id");
    }

    public function cancel_trade ($trans_id) {
        $this->Util_model->log_redirect();
        $buyer = $this->Util_model->get_info("trans", "buyer", "WHERE trans_id='$trans_id'");
        if ($buyer == $this->session->userdata(UID)) {
            if ($this->trade->cancel_trade($trans_id)) {
                $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-checks-circle'></i> Trade cancelled successfully", "alert-success", 1));
            } else {
                $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> An error occurred. Try again.", "alert-danger", 1));
            }
        }
        redirect(base_url()."trade/view-trade/$trans_id");
    }

    public function trade_time_up () {
        $this->trade->trade_time_up($_POST['trans_id']);
    }

    public function dispute_trade ($trans_id) {
        if ($this->trade->dispute_trade($trans_id)) {
            $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-checks-circle'></i> Trade sent for dispute. Send your complain to dispute@mexonaire.com", "alert-success", 1));
        } else {
            $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> An error occurred. Try again.", "alert-danger", 1));
        }
        redirect(base_url()."trade");
    }

    public function upload_picture($sender, $receiver, $trans_id){
        $this->Util_model->log_redirect();
        if (!empty($_FILES['image']['name'][0])) {
            $config = array(
                'upload_path' => "./assets/img/uploads/",
                'allowed_types' => 'jpg|gif|png',
                'max_size' => 1024,
                'file_name' => date("U"),
                'file_ext_tolower' => TRUE,
                'overwrite' => TRUE
            );

            $this->load->library('upload', $config);

            if ($this->upload->do_upload("image")) {
                $img_data = $this->upload->data();
                $upload_path = "assets/img/uploads/" . $img_data['file_name'];
                $this->Db_model->insert("chat", ["sender"=>$sender, "receiver"=>$receiver, "content"=>$upload_path, "type"=>"image", "ref"=>$trans_id]);
            }
        }
        redirect(base_url()."trade/view-trade/$trans_id");
    }

}

?>