<?php

/**
 * Created by PhpStorm.
 * User: testing
 * Date: 3/9/2020
 * Time: 4:05 AM
 */
class Wallet extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->Util_model->log_redirect();
        $this->load->model("Payment_model", "pay");
    }

    public function transactions () {
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="#"><i class="fa fa-exchange"></i> Transaction</a></li>
        </ol>
        ';
        if (isset($_POST['daterange'])) {
            $data['date'] = $this->input->post('daterange');
        } else {
            $data['date'] = date_time('d');
        }
        $data['system'] = $this->Db_model->selectGroup("*", "user_wallet", "WHERE date LIKE '$data[date]%' ORDER BY id DESC, status");
        $data['merchant'] = $this->Db_model->selectGroup("*", "merchant_wallet", "WHERE date LIKE '$data[date]%' ORDER BY id DESC, status");
        $data['tab'] = "transactions";
        $data['main_content'] = 'admin/transactions';
        $this->load->view('layouts/main',$data);
    }

    public function topup () {
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="#"><i class="fa fa-money"></i> Top Up Account</a></li>
        </ol>
        ';
        $data['tab'] = "fund";
        $data['main_content'] = 'admin/topup';
        $this->load->view('layouts/main',$data);
    }

    public function topup_merchant () {
        $this->form_validation->set_rules("mid", "Merchant ID", "required|trim|numeric");
        $this->form_validation->set_rules("amount", "Amount", "required|trim");

        if ($this->form_validation->run() == TRUE) {
            $mid = $this->input->post("mid");
            if ($this->Util_model->row_count("merchant_main", "WHERE mid=$mid") > 0) {
                if ($this->input->post("type") == 'add') {
                    if ($this->Main_model->add_to_merchant_wallet($this->input->post("amount"), $mid, 0, "", "", "Admin top up", "", "", 1)['return']) {
                        $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-checks-circle'></i> Merchant fund topped up successful", "alert-success", 1));
                    } else {
                        $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> An error occured topping up merchant account", "alert-danger", 1));
                    }
                } else {
                    if ($this->Main_model->add_to_merchant_wallet($this->input->post("amount"), 0, $mid, "", "", "Admin reduction", "", "", 1)['return']) {
                        $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-checks-circle'></i> Merchant fund reduction was successful", "alert-success", 1));
                    } else {
                        $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> An error occured reducing merchant fund", "alert-danger", 1));
                    }
                }
            } else {
                $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Merchant doesn't exist", "alert-danger", 1));
            }
        } else {
            $this->session->set_flashdata("msg", validation_errors());
        }
        redirect(base_url()."wallet/topup");
    }

    public function topup_user () {
        $this->form_validation->set_rules("mid", "Merchant ID", "required|trim");
        $this->form_validation->set_rules("username", "Username", "required|trim");
        $this->form_validation->set_rules("amount", "Amount", "required|trim");

        if ($this->form_validation->run() == TRUE) {
            if ($this->Util_model->row_count("user_profile", "WHERE username='$_POST[username]' AND mid=$_POST[mid]") > 0) {
                $uid = $this->Util_model->get_info("user_profile", "uid", "WHERE username='$_POST[username]' AND mid=$_POST[mid]");
                if ($this->input->post("type") == 'add') {
                    if ($this->Main_model->add_to_wallet($this->input->post("amount"), $uid, 0, $this->input->post('details'), $this->input->post('details'), "Admin top up", "", "", 1, $_POST['mid'])['return']) {
                        $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-checks-circle'></i> Account top up was successful", "alert-success", 1));
                    }
                } else {
                    if ($this->Main_model->add_to_wallet($this->input->post("amount"), 0, $uid, $this->input->post('details'), $this->input->post('details'), "Deduction", "", "", 1, $_POST['mid'])['return']) {
                        $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-checks-circle'></i> Account deduction was successful", "alert-success", 1));
                    }
                }
            } else {
                $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> The user with that username doesn't exist", "alert-danger", 1));
            }
        } else {
            $this->session->set_flashdata("msg", validation_errors());
        }
        redirect(base_url()."wallet/topup");
    }

    public function withdraw_status () {
        if ($this->input->post('type') == "merchant") {
            $this->Db_model->update("user_wallet", ["status"=>$this->input->post('status')], "WHERE ref='$_POST[reference]'");
            $this->Db_model->update("merchant_withdrawal", ["status"=>$this->input->post('status')], "WHERE reference='$_POST[reference]'");
        } else {
            $this->Db_model->update("user_wallet", ["status"=>$this->input->post('status')], "WHERE ref='$_POST[reference]'");
            $this->Db_model->update("user_withdraw", ["status"=>$this->input->post('status')], "WHERE reference='$_POST[reference]'");
        }
    }

    public function withdraw () {
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="#"><i class="fa fa-money"></i> Withdrawals</a></li>
        </ol>
        ';
        $data['merchant'] = $this->Db_model->selectGroup("*", "merchant_withdrawal", "ORDER BY id DESC");
        $data['user'] = $this->Db_model->selectGroup("*", "user_withdraw", "ORDER BY id DESC");
        $data['tab'] = "withdraw";
        $data['main_content'] = 'admin/withdrawals';
        $this->load->view('layouts/main',$data);
    }

    public function funding ()
    {
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="#"><i class="fa fa-money"></i> Funding</a></li>
        </ol>
        ';
        $data['tab'] = "funding";
        $data['main_content'] = 'admin/funding';
        $this->load->view('layouts/main',$data);
    }

    public function user_funding ($id) {
        $fund = $this->Util_model->get_info("funding", "*", "WHERE id=$id");
        if ($this->Db_model->update("user_wallet", ["status" => 1], "WHERE ref='$fund[ref]'")) {
            $this->Db_model->update("funding", ["status" => 1], "WHERE id=$id");
            /*$refID = $this->Util_model->get_info("user_referrer", "refID", "WHERE uid=$fund[uid]");
            if ($refID != 0) {
                if ($this->Util_model->row_count("user_wallet", "WHERE creditor=$fund[uid] AND status=1") == 1) {
                    $bonus = get_percentage($fund['amount'], 5);
                    $data = array(
                        "creditor" => $refID,
                        "debitor" => 0,
                        "amount" => $bonus,
                        "type" => "Referral Bonus",
                        "ref" => $this->Util_model->generate_id(11111111, 99999999, "user_bonus", "ref", "var", true, "fb"),
                        "status" => 1
                    );
                    $this->Db_model->insert("user_bonus", $data);
                }
            }*/
            $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-checks-circle'></i> Account top up was successful", "alert-success", 1));
        } else {
            $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Unsuccessful: An error occured.", "alert-danger", 1));
        }
        redirect(base_url()."wallet/funding");
    }

    public function merchant_funding ($id) {
        $fund = $this->Util_model->get_info("merchant_funding", "*", "WHERE id=$id");
        if ($this->Db_model->update("merchant_wallet", ["status" => 1], "WHERE ref='$fund[ref]'")) {
            $this->Db_model->update("merchant_funding", ["status" => 1], "WHERE id=$id");
            /*$refID = $this->Util_model->get_info("user_referrer", "refID", "WHERE uid=$fund[uid]");
            if ($refID != 0) {
                if ($this->Util_model->row_count("user_wallet", "WHERE creditor=$fund[uid] AND status=1") == 1) {
                    $bonus = get_percentage($fund['amount'], 5);
                    $data = array(
                        "creditor" => $refID,
                        "debitor" => 0,
                        "amount" => $bonus,
                        "type" => "Referral Bonus",
                        "ref" => $this->Util_model->generate_id(11111111, 99999999, "user_bonus", "ref", "var", true, "fb"),
                        "status" => 1
                    );
                    $this->Db_model->insert("user_bonus", $data);
                }
            }*/
            $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-checks-circle'></i> Merchant account top up was successful", "alert-success", 1));
        } else {
            $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Unsuccessful: An error occured.", "alert-danger", 1));
        }
        redirect(base_url()."wallet/funding");
    }

    public function merchant_funding_cancel ($id) {
        if ($this->Db_model->update("merchant_funding", ["status"=>2], "WHERE id=$id")) {
            $ref = $this->Util_model->get_info("merchant_funding", "ref", "WHERE id=$id");
            $this->Db_model->update("merchant_wallet", ["status"=>2], "WHERE ref='$ref'");
            $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-checks-circle'></i> Merchant funding cancelled successful", "alert-success", 1));
        } else {
            $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Unsuccessful: An error occured.", "alert-danger", 1));
        }
        redirect(base_url()."wallet/funding");
    }

    public function funding_cancel ($id) {
        if ($this->Db_model->update("funding", ["status"=>2], "WHERE id=$id")) {
            $ref = $this->Util_model->get_info("funding", "ref", "WHERE id=$id");
            $this->Db_model->update("user_wallet", ["status"=>2], "WHERE ref='$ref'");
            $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-checks-circle'></i> Funding cancelled successful", "alert-success", 1));
        } else {
            $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Unsuccessful: An error occured.", "alert-danger", 1));
        }
        redirect(base_url()."wallet/funding");
    }

    public function bank_transfer () {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.paystack.co/bank/resolve?account_number=$_POST[acct_num]&bank_code=$_POST[bank]",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => array(
                "Authorization: Bearer sk_live_232c201bd88fa1b60a9c856f487f389dcc97e279",
                "Cache-Control: no-cache",
            ),
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);

        if ($err) {
            echo "cURL Error #:" . $err;
        } else {
            echo $response;
        }
    }

    public function bank_withdraw () {
        $this->form_validation->set_rules("bank", "Bank", "trim|required");
        $this->form_validation->set_rules("acct_num", "Account number", "trim|required|exact_length[10]|is_natural|integer");
        $this->form_validation->set_rules("acct_name", "Account name", "trim|required");
        $this->form_validation->set_rules("amount", "Amount", "trim|required|integer");
        $this->form_validation->set_rules("password", "Account password", "trim|required|callback_password_check");

        if ($this->form_validation->run() == TRUE) {
            $amount = $this->input->post("amount");
            if ($amount < 100) {
                $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Amount must not be less than ₦100 and greater than ₦200,000", "alert-danger", 1));
            } else {
                if ($amount < 5000 || $amount > 200000) {
                    $amount_to_receive = $amount - 65;
                } else {
                    $amount_to_receive = $amount * 98.5;
                }
                if ($this->Main_model->check_balance($this->session->userdata(UID), $amount)) {
                    $reference = $this->Util_model->generate_id(11111111, 99999999, "user_wallet", "ref", "varchar", true, 'fb');
                    $debit = $this->Main_model->add_to_wallet(
                        $amount,
                        0,
                        $this->session->userdata(UID),
                        "Bank transfer to $_POST[acct_name] - $_POST[acct_num]",
                        "Bank transfer to $_POST[acct_name] - $_POST[acct_num]",
                        "Bank transfer",
                        "",
                        $reference
                    );
                    if ($debit['return']) {
                        $data = array(
                            "uid" => $this->session->userdata(UID),
                            "reference" => $reference,
                            "amount" => $amount,
                            "amount_received" => $amount_to_receive,
                            "acct_name" => $this->input->post("acct_name"),
                            "acct_num" => $this->input->post("acct_num"),
                            "bank" => $this->input->post("bank"),
                            "status" => 0,
                            "date" => date_time()
                        );
                        if ($this->Db_model->insert("user_withdraw", $data)) {
                            //Send whatsapp notification
                            $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> Bank transfer booked successfully. Your bank account will be credited very soon.", "alert-success", 1));
                        } else {
                            $this->Db_model->delete("user_wallet", "WHERE debitor=" . $this->session->userdata(UID) . " AND ref='$reference'");
                            $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Unsuccessful: An error occured. Try again later.", "alert-danger", 1));
                        }
                    } else {
                        $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Unsuccessful: An error occured. Try again later.", "alert-danger", 1));
                    }
                } else {
                    $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Insufficient balance. <a href='".base_url()."deposit' class='alert-link'>Deposit Now!</a>", "alert-danger", 1));
                }
            }
        } else {
            $this->session->set_flashdata("msg", validation_errors());
        }
        redirect(base_url()."transfer?p=bank");
    }

    public function cancel_withdraw ($reference) {
        $this->Db_model->update("user_wallet", ["status"=>2], "WHERE ref='$reference'");
        $this->Db_model->update("user_withdraw", ["status"=>2], "WHERE reference='$reference'");
        redirect(base_url()."transfer?p=bank");
    }

    public function password_check($password) {
        $this->load->model("users/Users_model", "users");
        if ($this->users->confirm_pass($password)) {
            return true;
        } else {
            $this->form_validation->set_message("password_check","Incorrect password. Try again");
            return false;
        }
    }

    public function transaction () {
        $data['breadcrumb'] = '
        <ol class="breadcrumb">
            <li><a href="'.base_url().'home"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li><i class="fa fa-exchange"></i> Transaction</li>
        </ol>
        ';
        $data['tab'] = "transaction";
        $data['main_content'] = 'users/fund_list';
        $this->load->view('layouts/main',$data);
    }

    public function get_public_payment_detail () {
        $email = $this->Util_model->get_info("user_profile", "email", "WHERE uid=".$this->session->userdata(UID));
        $pay_status = $this->Util_model->get_option("paystack_status");
        if ($_POST['account'] == 0) {
            $key = ($pay_status == 'live') ? $this->Util_model->get_option("paystack_live_pk") : $this->Util_model->get_option("paystack_test_pk");
        } elseif ($_POST['account'] == 1) {
            $key = ($pay_status == 'live') ? $this->Util_model->get_option("paystack_live_pk1") : $this->Util_model->get_option("paystack_test_pk1");
        }
        $return = array(
            "uid"       =>  $this->session->userdata(UID),
            "email"     =>  $email,
            "key"       =>  $key
        );
        echo json_encode($return);
    }

    public function initialize_card_payment () {
        if (!isset($_SESSION[UID])) {
            echo json_encode([
                "status" => false,
                "message" => "Session expired. Refresh page"
            ]);
        } else {
            $tranx = $this->pay->pay_with_card($this->session->userdata(UID), $_POST['amount'], $_POST['reference'], 0, $_POST['save_card']);
            echo json_encode($tranx);
        }
    }

    public function initialize_other_payment () {
        if (!isset($_SESSION[UID])) {
            echo json_encode([
                "status" => false,
                "message" => "Session expired. Refresh page"
            ]);
        } else {
            $tranx = $this->pay->pay_with_other($this->session->userdata(UID), $_POST['amount'], $_POST['reference']);
            echo json_encode($tranx);
        }
    }

    public function verify_recipient () {
        $recipient = (is_numeric($_POST['recipient'])) ? ltrim($_POST['recipient'], 0) : $_POST['recipient'];
        $uid = $this->Util_model->get_info("user_profile", "uid", "WHERE email='$recipient' OR phone='$recipient' OR username='$recipient'");
        if ($uid == NULL) {
            echo "<span class='text-red'><b>Invalid:</b> Recipient not a valid user</span>";
        } else {
            echo "<span class='text-green'><b>Verified:</b> ".$this->Util_model->get_user_info($uid)."</span>";
        }
    }

    public function initialize_transfer () {
        if (!isset($_SESSION[UID])) {
            echo json_encode([
                "status" => 0,
                "message" => "Session expired. Refresh page"
            ]);
        } else {
            $this->load->model("Payment_model", "pay");
            echo $this->pay->wallet_transfer($this->session->userdata(UID), $_POST['amount'], $_POST['recipient'], $_POST['pin']);
        }
    }

    public function submit_otp () {
        if (!isset($_SESSION[UID])) {
            echo json_encode([
                "status" => 0,
                "message" => "Session expired. Refresh page"
            ]);
        } else {
            $this->load->model("Payment_model", "pay");
            echo $this->pay->submit_otp($_POST['otp']);
        }
    }

    public function submit_phone () {
        if (!isset($_SESSION[UID])) {
            echo json_encode([
                "status" => 0,
                "message" => "Session expired. Refresh page"
            ]);
        } else {
            $this->load->model("Payment_model", "pay");
            echo $this->pay->submit_phone($_POST['phone']);
        }
    }

    public function auth_deposit () {
        if (!isset($_SESSION[UID])) {
            echo json_encode([
                "status" => false,
                "message" => "Session expired. Refresh page"
            ]);
        } else {
            $trans = $this->pay->auth_charge($this->session->userdata(UID), $_POST['card_id'], $_POST['amount'], $_POST['amount_to_pay']);
            echo json_encode($trans);
        }
    }

    public function delete_card () {
        $this->Db_model->update("user_card", ["status"=>0], "WHERE id=$_POST[id]");
        echo $this->General_model->user_cards($this->session->userdata(UID));
    }

    public function initialize_withdraw () {
        if (!isset($_SESSION[UID])) {
            echo json_encode([
                "status" => 0,
                "message" => "Session expired. Refresh page"
            ]);
        } else {
            $this->load->model("Payment_model", "pay");
            echo $this->pay->transfer_to_account($this->session->userdata(UID), $_POST['amount'], $_POST['bank'], $_POST['account_num'], $_POST['pin']);
        }
    }

    public function initialize_auth_withdraw () {
        if (!isset($_SESSION[UID])) {
            echo json_encode([
                "status" => 0,
                "message" => "Session expired. Refresh page"
            ]);
        } else {
            $this->load->model("Payment_model", "pay");
            echo $this->pay->auth_transfer_to_account($_POST['user_bank_id'], $_POST['amount']);
        }
    }

    public function get_beneficiaries () {
        $s = $this->Db_model->selectGroup("*", "user_beneficiaries", "WHERE uid=".$this->session->userdata(UID)." AND status=1");
        if ($s->num_rows() == 0) {
            $return = "<p class='text-center text-red'>No beneficiary found</p>";
        } else {
            $return = "";
            foreach ($s->result_array() as $row) {
                $return .= "
                <div class='col-lg-3 col-md-3 col-sm-6 col-xs-12'>
                    <a href='javascript:;' class='btn btn-default btn-sm text-left btn-flat btn-block'>
                        <span onclick=''>
                            ".$this->Util_model->get_info("name", "user_main", "WHERE phone='$row[phone]'")."<br>
                            0
                        </span>
                        <span class='badge bg-red pull-right' onclick=''>
                            <i class='fa fa-trash'></i>
                        </span>
                    </a>

                </div>
                ";
            }
        }
    }

    public function bonus_to_wallet () {
        $bonus = $this->Main_model->get_balance($this->session->userdata(UID), false, true);
        if ($bonus > 0) {
            if ($this->Main_model->add_to_wallet($bonus, $this->session->userdata(UID), 0, "Bonus conversion to wallet", "Bonus conversion to wallet", "bonus", "", "", 1)['return']) {
                $data = array(
                    "creditor"          =>  0,
                    "debitor"           =>  $this->session->userdata(UID),
                    "amount"            =>  $bonus,
                    "type"              =>  "Referral bonus",
                    "ref"               =>  $this->Util_model->generate_id(11111111, 99999999, "user_bonus", "ref", "var", true, 'fb'),
                    "status"            =>  1
                );
                $this->Db_model->insert("user_bonus", $data);
                $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> Bonus funded to your wallet successfully.", "alert-success", 1));
            } else {
                $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> Unsuccessful: An error occured while converting your bonus. Try again", "alert-danger", 1));
            }
        } else {
            $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> You don't have any bonus to covert", "alert-danger", 1));
        }
        redirect(base_url()."home");
    }

    public function book_funding ($method) {
        $this->form_validation->set_rules("bank", "Bank", "trim|required");
        $this->form_validation->set_rules("phone", "Phone number", "trim|required|numeric");
        $this->form_validation->set_rules("amount", "Amount", "trim|required|numeric");
        $this->form_validation->set_rules("reference", "Reference of Narration", "trim|required");

        if ($this->form_validation->run() == true) {
            $bank = $this->input->post('bank');
            $amount = $this->input->post('amount');
            $ref = $this->input->post('reference');
            $transRef = $this->Util_model->generate_id(11111111, 99999999, "funding", "ref", "var", true);
            
            $data = array(
                "uid"       =>  $this->session->userdata(UID),
                "ref"       =>  $transRef,
                "method"    =>  $method,
                "bank"      =>  $bank,
                "phone"     =>  $this->input->post('phone'),
                "reference" =>  $ref,
                "amount"    =>  $amount
            );
            if ($this->Db_model->insert("funding", $data)) {
                $funding_id = $this->Util_model->get_info("funding", "id", "ORDER BY id DESC LIMIT 1");
                $this->Main_model->add_to_wallet($amount, $this->session->userdata(UID), 0, $ref, $ref, "Manual top up", $funding_id, $transRef, 0);
                $additional = "
                <p><b>Username: </b>".$this->Util_model->get_user_info($this->session->userdata(UID), "username", "profile")."</p>
                <p><b>Bank: </b>".$this->Util_model->get_info("banks", "name", "WHERE code='$bank'")."</p>
                <p><b>Reference: </b>$ref</p>
                <p><b>Amount: </b>$amount</p>
                ";
                $this->Mail_model->send_notification("Bank Transfer", "A bank transfer has been made and it requires manual confirmation from you.", "<a href='".base_url()."admin/funding'>Complete Order</a>", $additional, "Admin");
                //Notification
                $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> Funding booked successfully", "alert-success", 1));
            } else {
                $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-times-circle'></i> An error occured. Try later", "alert-danger", 1));
            }
        } else {
            $this->session->set_flashdata("msg", validation_errors());
        }
        redirect(base_url()."deposit");
    } 


}