<?php

/**
 * Created by PhpStorm.
 * User: testing
 * Date: 4/28/2020
 * Time: 2:38 PM
 */
class Admin_model extends CI_Model
{

    public function __construct()
    {
        parent::__construct();
    }

    public function offer_loan ($id) {
        $row = $this->Util_model->get_info("loan_request", "*", "WHERE id=$id");
        $receive = $row['received'];
        $offer = $this->Util_model->get_option("loan_offer") * pow(2, $receive);
        $wallet = $this->Main_model->add_to_wallet(($offer-($offer * 0.1)), $row['uid'], $this->session->userdata(UID), "Loan disbursement from the COVID-19 support", "Loan disbursement from the COVID-19 support", "Loan Disbursement", "", "");
        if ($wallet['return']) {
            $this->Db_model->update("loan_request", ["received"=>($receive+1), "status"=>1], "WHERE id=$id");
            $data = array (
                "uid"               =>  $row['uid'],
                "offer"             =>  $offer,
                "comm"              =>  0.15,
                "duration"          =>  $this->Util_model->get_option("loan_duration"),
                "extra"             =>  $wallet['reference'],
                "offer_date"        =>  date_time()
            );
            if ($this->Db_model->insert("loan_offer", $data)) {
                $return = [
                    "status" => true,
                    "balance" => $this->Main_model->get_balance($this->session->userdata(UID), true)
                ];
            } else {
                $return = [
                    "status" => false,
                    "msg" => "<i class='fa fa-times-circle'></i> An error occured. Try again"
                ];
            }
        } else {
            $return = [
                "status" => false,
                "msg" => "<i class='fa fa-times-circle'></i> An error occured. Try again"
            ];
        }
        return $return;
    }

    public function cancel_loan ($id) {
        $row = $this->Util_model->get_info("loan_offer", "*", "WHERE id=$id");
        if ($this->Db_model->delete("loan_request", "WHERE uid=$row[uid]")) {
            $this->Db_model->update("user_wallet", ["status"=>2], "WHERE ref='$row[extra]'");
            $this->Db_model->update("loan_offer", ["status"=>3], "WHERE id=$id");
            $this->Db_model->delete("user_wallet_bonus", "WHERE ref='$row[extra]'");
            $return = [
                "status" => true,
                "msg"   =>  "<i class='fa fa-check-circle'></i> Loan offer deleted successfully",
                "balance" => $this->Main_model->get_balance($this->session->userdata(UID), true)
            ];
        } else {
            $return = [
                "status" => false,
                "msg" => "<i class='fa fa-times-circle'></i> An error occured. Try again"
            ];
        }
        return $return;
    }

    public function expire_loan ($id) {
        $row = $this->Util_model->get_info("loan_offer", "*", "WHERE id=$id");
        if ($this->Db_model->delete("loan_request", "WHERE uid=$row[uid]")) {
            $this->Db_model->update("loan_offer", ["status"=>4], "WHERE id=$id");
            $this->Db_model->update("user_main", ["status"=>0], "WHERE uid=$row[uid]");
            /*$return = [
                "status" => true,
                "msg"   =>  "<i class='fa fa-check-circle'></i> Loan offer deleted successfully",
                "balance" => $this->Main_model->get_balance($this->session->userdata(UID), true)
            ];*/
        }
    }

    public function reset_loan ($id) {
        $row = $this->Util_model->get_info("loan_offer", "*", "WHERE id=$id");
        if ($this->Db_model->delete("loan_request", "WHERE uid=$row[uid]")) {
            $this->Db_model->update("loan_offer", ["status" => 2, "repayment_date" => date_time()], "WHERE id=$id");
            $this->Db_model->update("user_main", ["status"=>1], "WHERE uid=$row[uid]");
            $return = [
                "status" => true,
                "msg"   =>  "<i class='fa fa-check-circle'></i> Expired loan reset successful",
                "balance" => $this->Main_model->get_balance($this->session->userdata(UID), true)
            ];
        }
    }

    public function bot_transaction () {
        $count = rand(3, 9);
        $type = array("credit", "deposit");
        for ($i=0; $i<$count; $i++) {
            shuffle($type);
            $amount = rand(350, 11999);
            $ref = $this->Util_model->generate_id(1111111111, 9999999999, "user_wallet_ex", "ref", "varchar", true, 'fb');
            $uid = $this->Db_model->selectGroup("user_profile", "uid", "WHERE role=0 ORDER BY RAND() LIMIT 1");
            $this->Main_model->add_to_wallet_ex($amount, $uid, $type[0], $ref);
        }
    }

}