<?php

/**
 * Created by PhpStorm.
 * User: testing
 * Date: 4/25/2020
 * Time: 8:02 PM
 */
class Ads_model extends CI_Model
{

    public function __construct()
    {
        parent::__construct();
    }

    public function list_my_ads ($status="all", $uid="") {
        $uid = $uid == "" ? $this->session->userdata(UID) : $uid;
        if ($status == "all") {
            $s = $this->Db_model->selectGroup("*", "ads", "WHERE uid=$uid");
        } else if ($status == 'featured') {
            $s = $this->Db_model->selectGroup("*", "ads", "WHERE uid=$uid AND featured=1");
        } else {
            switch ($status) {
                case "inactive":
                    $stat = 0; break; //Inactive
                case "active":
                    $stat = 1; break; //Active
                case "sold":
                    $stat = 2; break; //Sold
                case "expired":
                    $stat = 3; break; //Expired
                case "closed":
                    $stat = 4; break; //Closed
                default:
                    $stat = 20; break; //Null
            }
            $s = $this->Db_model->selectGroup("*", "ads", "WHERE uid=$uid AND status=$stat");
        }

        if ($s->num_rows() == 0) {
            $view = "
            <p class='text-danger'>No ads found</p>
            ";
            $pagination = "";
        } else {
            $view = '
            <table id="ads" class="table table-responsive dashboardtable tablemyads">
                <thead>
                <tr>
                    <th>Photo</th>
                    <th>Title</th>
                    <th>Category</th>
                    <th>Ad Status</th>
                    <th>Price</th>
                    <th>Action</th>
                </tr>
                </thead>
                <tbody>
            ';
            $count = 1;
            foreach ($s->result_array() as $row) {
                $featured = "";
                switch ($row['status']) {
                    case "0":
                        $ad_status = '<span class="adstatus adstatusinactive">Inactive</span>';
                        $ad_action = "
                    <a class='btn-action btn-view' href='" . base_url() . "ad/$row[id]/$row[category]/".myUrlEncode($row['title'])."' title='View' data-toggle='tooltip'><i class='lni-eye'></i></a>
                    <a class='btn-action btn-edit' href='" . base_url() . "edit-ad/$row[id]' title='Edit' data-toggle='tooltip'><i class='lni-pencil'></i></a>
                    <a class='btn-action btn-delete' href='#' title='Close' data-toggle='tooltip' onclick='dialog_redirect(\"" . base_url() . "users/change-ad-status/$row[id]/4\", \"sm\", \"Close Ad\", \"Are you sure you want to close this ad?\")'><i class='lni-trash'></i></a>
                    ";
                        $ad_category = 'inactive';
                        break;
                    case "1":
                        if ($row['featured'] == 1) {
                            $show_featured = "no-display";
                            $featured = "<i class='fas fa-star text-blue'></i>";
                        } else {
                            $show_featured = "";
                            $featured = "";
                        }
                        $ad_status = '<span class="adstatus adstatusactive">Active</span>';
                        $ad_action = "
                    <a class='btn-action btn-view' href='" . base_url() . "ad/$row[id]/$row[category]/".myUrlEncode($row['title'])."' title='View' data-toggle='tooltip'><i class='lni-eye'></i></a>
                    <a class='btn-action btn-featured ".$show_featured."' href='#' title='Featured' data-toggle='tooltip' onclick='dialog_redirect(\"" . base_url() . "users/make-featured/$row[id]\", \"sm\", \"Feature Ad\", \"It will cost you ".$this->Util_model->get_option('feature_cost')." credits to feature this Ad.\")'><i class='lni-star'></i></a>
                    <a class='btn-action btn-edit' href='#' title='Sold' data-toggle='tooltip' onclick='dialog_redirect(\"" . base_url() . "users/change-ad-status/$row[id]/2\", \"sm\", \"Sold Ad\", \"Are you sure you want to mark this Ad as sold?\")'><i class='lni-check-mark-circle'></i></a>
                    <a class='btn-action btn-delete' href='#' title='Close' data-toggle='tooltip' onclick='dialog_redirect(\"" . base_url() . "users/change-ad-status/$row[id]/4\", \"sm\", \"Close Ad\", \"Are you sure you want to close this Ad?\")'><i class='lni-trash'></i></a>
                    ";
                        $ad_category = 'active';
                        break;
                    case "2":
                        $ad_status = '<span class="adstatus adstatussold">Sold</span>';
                        $ad_action = "
                    <a class='btn-action btn-view' href='" . base_url() . "ad/$row[id]/$row[category]/".myUrlEncode($row['title'])."' title='View' data-toggle='tooltip'><i class='lni-eye'></i></a>
                    ";
                        $ad_category = 'sold';
                        break;
                    case "3":
                        $ad_status = '<span class="adstatus adstatusexpired">Expired</span>';
                        $ad_action = "
                    <a class='btn-action btn-view' href='" . base_url() . "ad/$row[id]/$row[category]/".myUrlEncode($row['title'])."' title='View' data-toggle='tooltip'><i class='lni-eye'></i></a>
                    ";
                        $ad_category = 'expired';
                        break;
                    case "4":
                        $ad_status = '<span class="adstatus adstatusdeleted">Closed</span>';
                        $ad_action = "
                    <a class='btn-action btn-view' href='" . base_url() . "ad/$row[id]/$row[category]/".myUrlEncode($row['title'])."' title='View' data-toggle='tooltip'><i class='lni-eye'></i></a>
                    ";
                        $ad_category = 'closed';
                        break;
                } // switch
                $thumb = explode(',', $row['pic_url'])[0];
                $display = $count <= 10 ? "" : "no-display";
                $view .= "
                    <tr data-category='ads-list $ad_category' class='$display'>
                        <td class='photo'><img class='img-fluid' src='".base_url()."$thumb' alt='$row[title]'></td>
                        <td data-title='Title'>
                            <h3>$row[title] $featured</h3>
                            <span>Ad ID: $row[id]</span>
                        </td>
                        <td data-title='Category'><span class='adcategories overflow'>".$this->Util_model->get_info("categories", "name", "WHERE slug='$row[category]'")."</span></td>
                        <td data-title='Ad Status'>$ad_status</td>
                        <td data-title='Price'>
                            <h3>".NGN.number_format($row['price'])."</h3>
                        </td>
                        <td data-title='Action'>
                            <div class='btns-actions'>
                                $ad_action
                            </div>
                        </td>
                    </tr>
                ";
                $count++;
            } // Foreach
            $view .= '
                </tbody>
            </table>
            ';
            $pagination = "
                <li class='page-title font-1x text-muted' style='padding:7px 10px 0px'>Pages</li>
            ";
            for ($i=0; $i<$s->num_rows(); $i++) {
                $active = $i == 0 ? "active" : "";
                if ($i == 0 || ($i+1)%10 == 0) {
                    $from = $i;
                    $to = ($i+9);
                    $pagination .= "
                        <li class='page-item'><a class='page-link $active' href='#ads' onclick='pagination(__(\"ads-list\"), \"$from\", \"$to\")'>".($i+1)."</a></li>
                    ";
                }
            }
        }

        return ["listings"=>$view, "pagination"=>$pagination];
    }

    public function home_featured () {
        $s = $this->Db_model->selectGroup("*", "ads", "WHERE featured=1 AND (status=1 OR status=2) ORDER BY RAND()");
        $view = "";
        if ($s->num_rows() > 0) {
            $view = '
            <section class="featured section-padding">
                <div class="container">
                    <div class="row">
                        <div class="col-12 text-center">
                            <div class="heading">
                                <h1 class="section-title">Featured Ads</h1>
                                <h4 class="sub-title">Discover & connect with top-rated local businesses</h4>
                            </div>
                        </div>
                        <div class="col-md-12 wow fadeIn" data-wow-delay="0.5s">
                            <div id="new-products" class="owl-carousel owl-theme">
            ';
            foreach ($s->result_array() as $row) {
                switch ($row['status']) {
                    case "2":
                        $ad_status = "
                        <div class='btn-product bg-sale'>
                            <a href='#'>Sold</a>
                        </div>
                        ";
                        break;
                    default:
                        $ad_status = "";
                        break;
                } // switch
                $thumb = explode(',', $row['pic_url'])[0];
                $view .= "
                                <div class='item'>
                                    <div class='product-item'>
                                        <div class='carousel-thumb'>
                                            <img class='img-fluid' src='".base_url()."$thumb' alt='$row[title]'>
                                            <div class='overlay'>
                                                <div>
                                                    <a class='btn btn-common' href='" . base_url() . "ad/$row[id]/$row[category]/".myUrlEncode($row['title'])."'>View Details</a>
                                                </div>
                                            </div>
                                            $ad_status
                                            <span class='price'>".NGN.number_format($row['price'])."</span>
                                        </div>
                                        <div class='product-content-inner'>
                                            <div class='product-content'>
                                                <h3 class='product-title overflow'><a href='" . base_url() . "ad/$row[id]/$row[category]/".myUrlEncode($row['title'])."'>$row[title]</a></h3>
                                                <span>".$this->Util_model->get_info("categories", "name", "WHERE slug='$row[category]'")."</span>
                                                <div class='icon'>
                                                    <span><i class='lni-heart'></i></span>
                                                </div>
                                            </div>
                                            <div class='card-text clearfix'>
                                                <div class='float-left'>
                                                    <span class='count-review'>
                                                        ".$this->Util_model->get_user_info($row['uid'])."
                                                    </span>
                                                </div>
                                                <div class='float-right'>
                                                    <a class='address' href='#'><i class='lni-map-marker'></i> ".strtoupper($row['campus'])."</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                ";
            }
            $view .= '
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            ';
        }
        return $view;
    }

    function list_ads ($category="all", $keyword="", $uid="", $limit=0, $pagination=true, $col=4) {
        $limit = ($limit == 0) ? "" : "LIMIT $limit";
        $ser = "WHERE status=1";
        $ser .= ($category != "all") ? " AND category='$category'" : "";
        $ser .= ($uid != "") ? " AND uid=$uid" : "";
        if ($keyword != "") {
            $ser .= " AND title LIKE '%$keyword%'";
            if (strstr($keyword, "+")) {
                $keyword_array = explode("+", $keyword);
                foreach ($keyword_array as $keyword) {
                    $ser .= " AND title LIKE '%$keyword%'";
                }
            }
        }
        $ser .= " ORDER BY featured DESC, views DESC, id DESC $limit";
        $s = $this->Db_model->selectGroup("*", "ads", $ser);
        $pagination = "";
        $view = "";
        if ($s->num_rows() == 0) {
            $view = "<div class='well'>No ads found. <a href='".base_url()."users/post-ad'>Post an Ad</a>";
        } else {
            $count = 1;
            foreach ($s->result_array() as $row) {
                $featured = ($row['featured'] == 1) ? "<i class='fa fa-star text-yellow fa-2x'></i>" : "";
                $thumb = (strstr($row['pic_url'], ",")) ? explode(',', $row['pic_url'])[0] : $row['pic_url'];
                $display = $count <= 60 ? "" : "no-display";
                $username = ($this->session->has_userdata(UID)) ? $this->Util_model->get_user_info($this->session->userdata(UID), "username", "profile") : "";
                $view .= "
                    <div class='col-xs-12 col-sm-6 col-md-$col col-lg-$col $display ads-lists'>
                        <div class='card card-product'>
                            <div class='card-header card-header-image' data-header-animation='true'>
                                <a href='" . base_url() . "blog/$row[id]/".myUrlEncode($row['title'])."/$username'>
                                    <img class='img' src='".base_url()."$thumb'>
                                </a>
                            </div>
                            <div class='card-body'>
                                <div class='card-actions text-center'>
                                    <button type='button' class='btn btn-danger btn-link fix-broken-card'>
                                        <i class='material-icons'>build</i> Fix Header!
                                    </button>
                                    <!--<button type='button' class='btn btn-default btn-link' rel='tooltip' data-placement='bottom' title='View'>
                                        <i class='material-icons'>art_track</i>
                                    </button>
                                    <button type='button' class='btn btn-success btn-link' rel='tooltip' data-placement='bottom' title='Edit'>
                                        <i class='material-icons'>edit</i>
                                    </button>
                                    <button type='button' class='btn btn-danger btn-link' rel='tooltip' data-placement='bottom' title='Remove'>
                                        <i class='material-icons'>close</i>
                                    </button>-->
                                    <p class='text-info top-1x'>Share the link and get more credits</p>
                                </div>
                                <h4 class='card-title'>
                                    <a href='" . base_url() . "blog/$row[id]/$row[category]/".myUrlEncode($row['title'])."'>$row[title]</a>
                                </h4>
                                <div class='card-description' style='height: 120px; overflow-y: hidden;'>
                                    $row[description]
                                </div>
                            </div>
                            <div class='card-footer'>
                                <div class='price'>
                                    <h4>".$this->Util_model->get_info("categories", "name", "WHERE slug='$row[category]'")."</h4>
                                </div>
                                <div class='stats'>
                                    <!--<p class='card-category'><i class='material-icons'>place</i> London, UK</p>-->
                                    $featured
                                </div>
                            </div>
                            <div class='card-footer'>
                                <span class='no-display' id='post-link'>" . base_url() . "blog/$row[id]/".myUrlEncode($row['title'])."/$username</span>
                                <button class='btn btn-primary btn-block' onclick='copyToClipboard($(this), _(\"post-link\"))'>Click To Copy Post Link <i class='fa fa-link'></i> </button>
                            </div>
                        </div>
                    </div>
                ";
                $count++;
            }
            if ($pagination) {
                $pagination = "
                    <li class='page-title font-1x text-muted' style='padding:7px 10px 0px'>Pages</li>
                ";
                for ($i=0; $i<$s->num_rows(); $i++) {
                    $active = $i == 0 ? "active" : "";
                    if ($i == 0 || ($i+1)%60 == 0) {
                        $from = $i;
                        $to = ($i+59);
                        $pagination .= "
                        <li class='page-item'><a class='page-link $active' href='#ads' onclick='pagination(__(\"ads-list\"), \"$from\", \"$to\")'>".($i+1)."</a></li>
                    ";
                    }
                }
            }
        }
        return ["listings"=>$view, "pagination"=>$pagination];
    }

}