<?php
/**
 * Created by PhpStorm.
 * User: Mr. Winz
 * Date: 5/24/2017
 * Time: 10:21 AM
 */

defined('BASEPATH') OR exit('No direct script access allowed');

class Payment_model extends CI_Model
{
    public $key;

    public function __construct()
    {
        parent::__construct();
        $this->test_key = $this->Util_model->get_option('paystack_test_sk');
        $this->live_key = $this->Util_model->get_option('paystack_live_sk');
        $this->live_subaccount = $this->Util_model->get_option('paystack_live_subaccount');
        $this->test_subaccount = $this->Util_model->get_option('paystack_test_subaccount');
        $this->test_key1 = $this->Util_model->get_option('paystack_test_sk1');
        $this->live_key1 = $this->Util_model->get_option('paystack_live_sk1');
        $this->live_subaccount1 = $this->Util_model->get_option('paystack_live_subaccount1');
        $this->test_subaccount1 = $this->Util_model->get_option('paystack_test_subaccount1');
        $this->status = $this->Util_model->get_option('paystack_status');
    }

    public function verify_transaction ($reference = NULL, $account=0, $array=false) {
        $reference = (isset($_SESSION['reference'])) ? $this->session->userdata('reference') : $reference;
        if ($account == 0) {
            $key = ($this->status == 'test') ? $this->test_key : $this->live_key;
        } else if ($account == 1) {
            $key = ($this->status == 'test') ? $this->test_key1 : $this->live_key1;
        }
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.paystack.co/transaction/verify/" . rawurlencode($reference),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_HTTPHEADER => [
                "accept: application/json",
                "authorization: Bearer $key",
                "cache-control: no-cache"
            ],
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        if ($array) {
            if($err){
                $return = array("status"=>false, "message"=>"Program delay. Report to the admin", "auth"=>NULL);
            } else {
                $tranx = json_decode($response);

                if ($tranx->data->status == 'success') {
                    $amount = $tranx->data->amount / 100;
                    $amount = ($amount >= 2500) ? $amount - 100  : $amount;
                    $amount = ceil($amount - ($amount * 0.05));
                    $return = array("status"=>true, "message"=>$tranx->message, "email"=>$tranx->data->customer->email, "amount"=>$amount, "auth"=>$tranx->data->authorization, "channel"=>$tranx->data->channel);
                } else {
                    $return = array("status"=>false, "message"=>$tranx->message, "auth"=>$tranx->data->authorization, "channel"=>$tranx->data->channel);
                }

            }
        } else {
            if($err){
                $return = false;
            } else {
                $tranx = json_decode($response);

                if(!$tranx->status){
                    $return = false;
                } else {
                    if ($tranx->data->status == 'success') {
                        $return = true;
                    } else {
                        $return = false;
                    }
                }
            }
        }

        return $return;
    }

    public function verify_pending () {
        $s = $this->Db_model->selectGroup("*", "user_wallet", "WHERE status=0 AND type='Deposit'");
        if ($s->num_rows() > 0) {
            foreach ($s->result_array() as $row) {
                $account = $this->Util_model->get_info("user_card", "account", "WHERE id=".$this->Util_model->get_info("user_wallet", "extra", "WHERE ref='$row[ref]'"));
                $trans = $this->verify_transaction($row['ref'], $account,true);
                if ($trans['status']) {
                    $this->Db_model->update("user_wallet", ["status"=>1], "WHERE id=$row[id]");

                    $auth = $trans['auth'];
                    $data = array (
                        "auth_code"     =>  $auth->authorization_code,
                        "card_type"     =>  rtrim($auth->card_type, " DEBIT"),
                        "bank"          =>  $auth->bank,
                        "country_code"  =>  $auth->country_code,
                        "status"        =>  1
                    );
                    $this->Db_model->update("user_card", $data, "WHERE id=$row[extra]");
                } else {
                    $this->Db_model->update("user_wallet", ["status"=>2], "WHERE id=$row[id]");
                }
            }
        }
    }

    public function pay_with_card ($reference, $account=0, $save_card=1) {
        $tranx = $this->verify_transaction($reference, $account, true);
        if ($tranx['status']) {
            $auth = $tranx['auth'];
            $card_id = "";
            $uid = $this->Util_model->get_info("user_profile", "uid", "WHERE email='$tranx[email]'");
            /*if ($tranx['channel'] == 'card') {
                if ($this->Util_model->row_count("user_card", "WHERE uid=$uid AND `bin`='".$auth->bin . "' AND `last4`='" . $auth->last4 . "' AND account=$account") == 0) {
                    $data = array(
                        "uid" => $uid,
                        "auth_code" => $auth->authorization_code,
                        "bin" => $auth->bin,
                        "last4" => $auth->last4,
                        "expiry_month" => $auth->exp_month,
                        "expiry_year" => $auth->exp_year,
                        "card_type" => $auth->brand,
                        "bank" => $auth->bank,
                        "country_code" => $auth->country_code,
                        "account" => $account
                    );
                    $this->Db_model->insert("user_card", $data);
                } else {
                    $data = array(
                        "auth_code" => $auth->authorization_code,
                        "expiry_month" => $auth->exp_month,
                        "expiry_year" => $auth->exp_year,
                        "card_type" => $auth->brand,
                        "bank" => $auth->bank,
                        "country_code" => $auth->country_code
                    );
                    $this->Db_model->update("user_card", $data, "WHERE uid=$uid AND `bin`='" . $auth->bin . "' AND `last4`='" . $auth->last4 . "' AND account=$account");
                }
                if ($auth->reusable) {
                    $this->Db_model->update("user_card", ["status" => 1], "WHERE uid=$uid AND `bin`='" . $auth->bin . "' AND `last4`='" . $auth->last4 . "' AND account=$account");
                }
                $card_id = $this->Util_model->get_info("user_card", "id", "WHERE uid=$uid AND bin='".$auth->bin."' AND `last4`='".$auth->last4."' AND account=$account");
            }*/
            if ($this->Util_model->row_count("user_wallet", "WHERE ref='$reference'") == 0) {
                $wallet = $this->Main_model->add_to_wallet(
                    $tranx['amount'],
                    $uid,
                    0,
                    "Instant deposit-$tranx[channel]",
                    "Instant deposit-$tranx[channel]",
                    "Instant Deposit",
                    "Paystack",
                    $reference,
                    1
                );
            } else {
                $u_wallet = array(
                    "creditor_desc" =>  "Instant deposit-$tranx[channel]",
                    "debitor_desc"  =>  "Instant deposit-$tranx[channel]",
                    "extra"         =>  "Paystack",
                    "status"        =>  1
                );
                $this->Db_model->update("user_wallet", $u_wallet, "WHERE ref='$reference'");
            }
            $refID = $this->Util_model->get_info("user_referrer", "refID", "WHERE uid=$uid");
            if ($refID != 0) {
                if ($this->Util_model->row_count("user_wallet", "WHERE creditor=$uid AND status=1") == 1) {
                    $bonus = get_percentage($this->Util_model->get_info("user_wallet", "amount", "WHERE ref='$reference'"), 5);
                    $data = array(
                        "creditor" => $refID,
                        "debitor" => 0,
                        "amount" => $bonus,
                        "type" => "Referral Bonus",
                        "ref" => $this->Util_model->generate_id(11111111, 99999999, "user_bonus", "ref", "var", true, "fb"),
                        "status" => 1
                    );
                    $this->Db_model->insert("user_bonus", $data);
                }
            }
            $return = [
                "status"        =>  true,
                "message"       =>  "Transaction approved",
                "redirect"      =>  ($this->session->has_userdata('redirect')) ? $this->session->tempdata('redirect') : base_url() . "transaction"
            ];
        } else {
            $u_wallet = array(
                "status"        =>  2
            );
            $this->Db_model->update("user_wallet", $u_wallet, "WHERE ref='$reference'");
            $return = [
                "status"        =>  false,
                "message"       =>  "Transaction declined. Try again"
            ];
        }
        return $return;
    }

    public function auth_charge($uid, $card_id, $amount, $amount_to_pay) {
        $email = $this->Util_model->get_user_info($uid, "email", "profile");
        $u_card = $this->Util_model->get_info("user_card", "*", "WHERE id=$card_id");

        if (is_connected()) {
            $data = array(
                "email"                 =>  $email,
                "amount"                =>  $amount_to_pay * 100,
                "subaccount"            =>  $this->subaccount,
                "authorization_code"    =>  $u_card['auth_code']
            );

            if ($u_card['account'] == 0) {
                $key = ($this->status == 'test') ? $this->test_key : $this->live_key;
                $subaccount = ($this->status == 'test') ? $this->test_subaccount : $this->live_subaccount;
            } else if ($u_card['account'] == 1) {
                $key = ($this->status == 'test') ? $this->test_key1 : $this->live_key1;
                $subaccount = ($this->status == 'test') ? $this->test_subaccount1 : $this->live_subaccount1;
            }

            $curl = curl_init();

            curl_setopt_array($curl, array(
                CURLOPT_URL => "https://api.paystack.co/transaction/charge_authorization",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_CUSTOMREQUEST => "POST",
                CURLOPT_POSTFIELDS => json_encode($data),
                CURLOPT_HTTPHEADER => [
                    "authorization: Bearer $key",
                    "content-type: application/json",
                    "cache-control: no-cache"
                ],
            ));

            $response = curl_exec($curl);
            $err = curl_error($curl);

            if ($err) {
                $return = json_encode([
                    "status" => 0,
                    "message" => "An error occurred. $err"
                ]);
            } else {
                $response = json_decode($response);
                if (!$response->status) {
                    $return = json_encode([
                        "status" => false,
                        "message" => $response->message
                    ]);
                } else {
                    if ($response->data->status == "failed") {
                        $return = json_encode([
                            "status" => false,
                            "message" => $response->data->gateway_response
                        ]);
                    } else if ($response->data->status == "success") {
                        $tranx = $this->verify_transaction($response->data->reference, $u_card['account'], true);
                        if ($tranx['status']) {
                            $auth = $tranx['auth'];
                            $this->Main_model->add_to_wallet(
                                $amount,
                                $uid,
                                0,
                                "Instant deposit-$tranx[channel]",
                                "Instant deposit-$tranx[channel]",
                                "Deposit",
                                $card_id,
                                $response->data->reference,
                                1
                            );
                            $return = [
                                "status"        =>  true,
                                "message"       =>  "Transaction approved",
                                "redirect"      =>  ($this->session->has_userdata('redirect')) ? $this->session->tempdata('redirect') : base_url() . "wallet/transactions"
                            ];
                        } else {
                            $return = [
                                "status"        =>  false,
                                "message"       =>  "Transaction pending, check back in 5 mins"
                            ];
                        }
                    }
                }
            }
        }
        return $return;
    }

    public function check_expired_cards () {
        $s = $this->Db_model->selectGroup("*", "user_card", "WHERE status=1");
        if ($s->num_rows() > 0) {
            foreach ($s->result_array() as $row) {
                $expiry_date = "$row[expiry_year]-$row[expiry_month]-".get_last_day($row['expiry_year'], $row['expiry_month'])." 23:59:59";
                $current_date = date('Y-m')."-".get_last_day(date('Y'), date('m'))." 23:59:59";
                if (!date_inrange($expiry_date, $current_date)) {
                    $this->Db_model->update("user_card", ["status"=>0], "WHERE id=$row[id]");
                    $this->Mail_model->send_mail($this->Util_model->get_user_info($row['uid'], "email", "profile"), "Card Expired", "
                    Your <b>$row[card_type] card with number $row[card_num] linked to $row[bank]</b> has expired and your account has been downgraded to FREE package. Please make upgrade your account to add a new card. Visit <a href='".base_url()."packages'>www.isebaba.com/packages</a> to upgrade your account now. <br><br> Isebaba Support
                    ");
                }
            }
        }
    }

    public function pay_with_other ($uid, $amount, $reference, $account=1) {
        $tranx = $this->verify_transaction($reference, $account, true);
        if ($tranx['status']) {
            $this->Main_model->add_to_wallet(
                $amount,
                $uid,
                0,
                "Deposit-$tranx[channel]",
                "Deposit-$tranx[channel]",
                "Deposit",
                $tranx['channel'],
                $reference,
                1
            );
            $return = [
                "status"        =>  true,
                "message"       =>  "Transaction approved",
                "redirect"      =>  ($this->session->has_userdata('redirect')) ? $this->session->tempdata('redirect') : base_url() . "wallet/transactions"
            ];
        } else {
            $return = [
                "status"        =>  true,
                "message"       =>  "Transaction declined. Try again"
            ];
        }
        return $return;
    }

    public function transfer_to_account ($uid, $amount, $bank, $account_num, $pin) {
        //$bank = $this->Util_model->get_info("banks", "*", "WHERE id=$bank");
        if ($this->Util_model->row_count("user_bank", "WHERE account_num=$account_num AND bank=$bank AND uid=$uid") > 0) {
            $return = json_encode([
                "status" => 0,
                "message" => "Bank account registered already. Select from the list"
            ]);
        } else if ($this->Util_model->get_user_info($uid, "verified", "profile") == 0) {
            $return = json_encode([
                "status" => 0,
                "message" => "Please verify your email to withdraw cash. <a href='".base_url()."info'>Click here</a>"
            ]);
        } else if ($this->Util_model->get_user_info($uid, "pin", "profile") != $pin) {
            $return = json_encode([
                "status" => 0,
                "message" => "Incorrect transaction PIN. <a href='".base_url()."profile/resend_trans_pin/$uid'>Resend PIN</a>"
            ]);
        } else if ($amount > $this->General_model->get_balance($uid, false)) {
            $return = json_encode([
                "status" => 0,
                "message" => "Insufficient balance"
            ]);
        } else if ($this->Util_model->get_user_info($uid, "verified", "profile") == 0) {
            $return = json_encode([
                "status" => 0,
                "message" => "Verify your email address. <a href='".base_url()."profile/send_email_verification'>Resend verification link</a>"
            ]);
        } else {
            if (is_connected()) {
                $trans_recipient = $this->add_recipient($uid, $bank, $account_num);
                if ($trans_recipient['status']) {
                    if ($amount <= 2500) {
                        $charge = $this->Util_model->get_option("withdrawal_fixed_charge");
                    } else {
                        $charge = $this->Util_model->get_option("withdrawal_percentage_charge");
                        $charge = get_percentage($amount, $charge);
                    }
                    $payout = ($amount - $charge);
                    $payout *= 100;
                    $transfer = $this->initiate_transfer($payout, $trans_recipient['recipient']);
                    if ($transfer == NULL) {
                        $return = json_encode([
                            "status" => 0,
                            "message" => "Your transfer cannot be completed at the moment. Try again later"
                        ]);
                    } else {
                        $this->Main_model->add_to_wallet(
                            $amount,
                            0,
                            $uid,
                            "Withdraw " . $trans_recipient['recipient'],
                            "Withdraw " . $trans_recipient['recipient'],
                            "Withdraw",
                            $this->Util_model->get_info("user_bank", "id", "WHERE account_num='$account_num'"),
                            $transfer,
                            1
                        );
                        $return = json_encode([
                            "status" => 1,
                            "redirect" => base_url() . "transactions"
                        ]);
                        $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> Your withdrawal has been booked for payout", "alert-success", 1));
                    }
                } else {
                    $return = json_encode([
                        "status" => 0,
                        "message" => $trans_recipient['message']
                    ]);
                }
            } else {
                $return = json_encode([
                    "status"    =>  0,
                    "message"   =>  "Connection error: check your internet connectivity"
                ]);
            }
        }
        return $return;
    }

    public function auth_transfer_to_account ($user_bank_id, $amount) {
        $user_bank = $this->Util_model->get_info("user_bank", "*", "WHERE id=$user_bank_id");
        if ($this->Util_model->get_user_info($user_bank['uid'], "verified", "profile") == 0) {
            $return = json_encode([
                "status" => 0,
                "message" => "Verify your email address. <a href='" . base_url() . "profile/send_email_verification'>Resend verification link</a>"
            ]);
        } else {
            if ($amount <= 2500) {
                $charge = $this->Util_model->get_option("withdrawal_fixed_charge");
            } else {
                $charge = $this->Util_model->get_option("withdrawal_percentage_charge");
                $charge = get_percentage($amount, $charge);
            }
            $payout = ($amount - $charge);
            $payout *= 100;
            $transfer = $this->initiate_transfer($payout, $user_bank['recipient']);
            if ($transfer == NULL) {
                $return = json_encode([
                    "status" => 0,
                    "message" => "Your transfer cannot be completed at the moment. Try again later"
                ]);
            } else {
                $this->Main_model->add_to_wallet(
                    $amount,
                    0,
                    $user_bank['uid'],
                    "Withdraw " . $user_bank['recipient'],
                    "Withdraw " . $user_bank['recipient'],
                    "Withdraw",
                    $user_bank['bank'],
                    $transfer,
                    1
                );
                $return = json_encode([
                    "status" => 1,
                    "redirect" => base_url() . "transactions"
                ]);
                $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> Your withdrawal has been booked for payout", "alert-success", 1));
            }
        }
        return $return;
    }

    public function verify_account ($acct, $bank) {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.paystack.co/bank/resolve?account_number=$acct&bank_code=$bank",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => array(
                "Authorization: Bearer ".$this->key,
                "Cache-Control: no-cache",
            ),
        ));

        $response = json_decode(curl_exec($curl));
        $err = curl_error($curl);

        curl_close($curl);

        if ($err) {
            $return = [
                "status"    =>  0,
                "message"   =>  "Account number not verified, you can fill the account name direct if you are sure of the account"
            ];
        } else {
            if (!$response->status) {
                $return = [
                    "status"    =>  0,
                    "message"   =>  "Account number not verified, you can fill the account name direct if you are sure of the account"
                ];
            } else {
                $return = [
                    "status"    =>  1,
                    "message"   =>  $response->data->account_name
                ];
            }
        }
        return json_encode($return);
    }

    public function add_recipient ($uid, $bank, $account_num) {
        $bank_code = $this->Util_model->get_info("banks", "code", "WHERE id=$bank");
        $username = $this->Util_model->get_user_info($uid, "username", "profile");
        $name = $this->Util_model->get_user_info($uid);
        //$currency = $this->Util_model->get_info("countries", "currency", "WHERE id=".$this->Util_model->get_info("banks", "country", "WHERE id=$bank"));
        $data = array (
            "type" => "nuban",
            "name" => $name,
            "description" => "Isebaba: $username",
            "account_number" => $account_num,
            "bank_code" => $bank_code,
            "currency" => 'NGN'
        );

        $account = 0;
        if ($account == 0) {
            $key = ($this->status == 'test') ? $this->test_key : $this->live_key;
        } else if ($account == 1) {
            $key = ($this->status == 'test') ? $this->test_key1 : $this->live_key1;
        }
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.paystack.co/transferrecipient",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => json_encode($data),
            CURLOPT_HTTPHEADER => [
                "authorization: Bearer $key",
                "content-type: application/json",
                "cache-control: no-cache"
            ],
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        $response = json_decode($response);
        if ($response->status) {
            $input = array(
                "uid" => $uid,
                "bank" => $bank,
                "account_num" => $account_num,
                "recipient" => $response->data->recipient_code,
                "status" => ($response->data->active ? 1 : 0)
            );
            if ($this->Util_model->row_count("user_bank", "WHERE uid=$uid AND bank=$bank AND account_num='$account_num'") == 0) {
                $db = $this->Db_model->insert("user_bank", $input);
            } else {
                $db = $this->Db_model->update("user_bank", ["recipient" => $response->data->recipient_code, "status" => $input['status']], "WHERE uid=$uid AND bank=$bank AND account_num='$account_num'");
            }
            if ($db) {
                $return = array("status" => true, "recipient" => $response->data->recipient_code, "active" => $response->data->active);
            } else {
                $return = array("status" => false, "message" => $response->message);
            }
        } else {
            $return = array("status" => false, "message" => $response->message);
        }
        return $return;
    }

    public function initiate_transfer ($amount, $recipient, $source="balance", $reason="IseBaba") {
        $data = array (
            "source"        =>  $source,
            "reason"        =>  $reason,
            "amount"        =>  $amount,
            "recipient"     =>  $recipient,
            "currency"      =>  'NGN'
        );

        $account = 0;
        if ($account == 0) {
            $key = ($this->status == 'test') ? $this->test_key : $this->live_key;
        } else if ($account == 1) {
            $key = ($this->status == 'test') ? $this->test_key1 : $this->live_key1;
        }
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.paystack.co/transfer",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => json_encode($data),
            CURLOPT_HTTPHEADER => [
                "authorization: Bearer $key",
                "content-type: application/json",
                "cache-control: no-cache"
            ],
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        $response = json_decode($response);
        if ($response->status) {
            return $response->data->transfer_code;
        } else {
            return NULL;
        }

    }

    public function finalize_transfer ($trans_code, $otp) {
        $data = array (
            "transfer_code"         =>  $trans_code,
            "otp"                   =>  $otp
        );
        $account = 0;
        if ($account == 0) {
            $key = ($this->status == 'test') ? $this->test_key : $this->live_key;
        } else if ($account == 1) {
            $key = ($this->status == 'test') ? $this->test_key1 : $this->live_key1;
        }
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.paystack.co/transfer",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => json_encode($data),
            CURLOPT_HTTPHEADER => [
                "authorization: Bearer $key",
                "content-type: application/json",
                "cache-control: no-cache"
            ],
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        $response = json_decode($response);
    }

    public function wallet_transfer ($uid, $amount, $recipient, $pin) {
        $recipient = (is_numeric($recipient)) ? ltrim($recipient, 0) : $recipient;
        $recipient_uid = $this->Util_model->get_info("user_profile", "uid", "WHERE email='$recipient' OR phone='$recipient' OR username='$recipient'");
        if ($recipient_uid == NULL) {
            $return = json_encode([
                "status" => 0,
                "message" => "Invalid recipient. Try again"
            ]);
        } else if ($pin != $this->Util_model->get_user_info($uid, "pin", "profile")) {
            $return = json_encode([
                "status" => 0,
                "message" => "Incorrect transaction PIN"
            ]);
        } else if ($uid == $recipient_uid) {
            $return = json_encode([
                "status" => 0,
                "message" => "You can't transfer to own account"
            ]);
        } else if ($amount > $this->General_model->get_balance($uid, false)) {
            $return = json_encode([
                "status" => 0,
                "message" => "Insufficient balance <a href='".base_url()."deposit'>Deposit NOW</a>"
            ]);
        } else {
            $this->Main_model->add_to_wallet(
                10,
                0,
                $uid,
                "Transfer fee",
                "Transfer fee",
                "Transfer Fee",
                "",
                "",
                1
            );
            $amount -= 10;
            $this->Main_model->add_to_wallet(
                $amount,
                $recipient_uid,
                $uid,
                "Transfer from " . $this->Util_model->get_user_info($uid),
                "Transfer to " . $this->Util_model->get_user_info($recipient_uid),
                "Transfer",
                "",
                "",
                1
            );
            $return = json_encode([
                "status" => 1,
                "redirect" => base_url() . "transactions"
            ]);
            $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> Transfer of <b>₦".number_format($amount)."</b> to <b>".$this->Util_model->get_user_info($recipient_uid)."</b> was successful", "alert-success", 1));
        }
        return $return;
    }

}

?>