<?php

/**
 * Created by PhpStorm.
 * User: Mr. Winz
 * Date: 9/5/2018
 * Time: 10:45 PM
 */
class Store_model extends CI_Model
{

    public function __construct()
    {
        parent::__construct();
    }

    public function home_store () {
        $s = $this->Db_model->selectGroup("*", "store_products", "WHERE status=1 ORDER BY id DESC LIMIT 8");
        if ($s->num_rows() > 0) {
            $view = '<ul class="users-list clearfix">';
            foreach ($s->result_array() as $row) {
                $view .= "
                <li>
                    <a href='".base_url()."store/item/$row[id]'><img src='".base_url()."$row[picture]' alt='$row[name]' width='110' height='110'></a>
                    <a class='users-list-name' href='".base_url()."store/product/$row[id]'>$row[name]</a>
                    <span class='users-list-date'>Exp. NGN ".number_format($row['exp_earnings'])."</span>
                </li>
                ";
            }
            $view .= '</ul>';
        } else {
            $view = "<div class='well'>No product at the moment</div>";
        }
        return $view;
    }

    private function list_item_picture ($picture, $link=true, $attributes="") {
        if (strstr($picture, ',')) {
            $slide = "";
            $pic_ex = explode(",", $picture);
            for ($i=1; $i<count($pic_ex); $i++) {
                $slide .= "<a class='example-image-link' href='".base_url()."$pic_ex[$i]' data-lightbox='image-set' data-title=''></a>";
            }
            if ($link) {
                $single_pic = "<a class='example-image-link' href='" . base_url() . "$pic_ex[0]' data-lightbox='image-set' data-title=''><img class='example-image' src='" . base_url() . "$pic_ex[0]' $attributes /></a>";
                $pic_arr = array("single"=>$single_pic, "slide"=>$slide, "count"=>count($pic_ex));
            } else {
                $single_pic = "<img class='example-image' src='".base_url()."$pic_ex[0]' $attributes />";
                $pic_arr = $single_pic;
            }
        } else {
            if ($link) {
                $single_pic = "<a class='example-image-link' href='".base_url()."$picture' data-lightbox='image-set' data-title=''><img class='example-image' src='".base_url()."$picture' $attributes /></a>";
                $slide = "<a class='example-image-link' href='" . base_url() . "$picture' data-lightbox='image-set' data-title=''></a>";
                $pic_arr = array("single"=>$single_pic, "slide"=>$slide, "count"=>1);
            } else {
                $single_pic = "<img class='example-image' src='".base_url()."$picture' $attributes />";
                $pic_arr = $single_pic;
            }
        }
        return $pic_arr;
    }

    public function list_items ($where="WHERE status=1 ORDER BY id DESC") {
        $s = $this->Db_model->selectGroup("*", "store_products", $where);
        if ($s->num_rows() == 0) {
            $view = "<div class='well text-center'>No item found.</div>";
        } else {
            $view = '
            <div class="item-list">
            ';
            foreach ($s->result_array() as $row) {
                //$data = $this->Util_model->get_info("data_bundle", "*", "WHERE id=$row[free_data]");
                $view .= "
                <a class='item-wrap' href='https://wa.link/j8l3bg'>";
                $single_pic = $this->list_item_picture($row['picture'], false);
                $view .= "
                    $single_pic
                    <div class='brand'>
                        ".$this->Util_model->get_info("store_categories", "name", "WHERE id=$row[cat_id]")."
                    </div>
                    <h3 class='name overflow' style='overflow:hidden'>
                        $row[name]
                    </h3>
                    <div class='price-box'>
                        <span class='price'>
                            ₦".number_format($row['selling_price'])."
                        </span>
                        <span class='price exp pull-right' style='text-decoration: none;'>
                            $row[condition]
                        </span>
                    </div>
                </a>
                ";
            }
            $view .= "</div>";
        }
        return $view;
    }

    public function top_selling_items () {
        $s = $this->Db_model->selectGroup("*", "store_sponsored", "WHERE region=".$this->Util_model->get_user_info($this->session->userdata(UID), "region", "profile")." ORDER BY RAND() LIMIT 12");
        $count = 0;
        $view = "";
        if ($s->num_rows() > 0) {
            foreach ($s->result_array() as $row1) {
                $row = $this->Db_model->select("*", "store_products", "WHERE id=$row1[pid]");
                //$data = $this->Util_model->get_info("data_bundle", "*", "WHERE id=$row[free_data]");
                $view .= "
                <a class='item-wrap' href='" . base_url() . "store/item/$row[id]'>";
                $single_pic = $this->list_item_picture($row['picture'], false);
                $view .= "
                    $single_pic
                    <div class='brand'>
                        " . $this->Util_model->get_info("store_main", "name", "WHERE sid=$row[sid]") . "
                    </div>
                    <h3 class='name overflow'>
                        $row[name]
                    </h3>
                        <div class='price-box'>
                            <span class='price'>
                                ₦" . number_format($row['selling_price']) . "
                            </span>
                            <span class='price exp' style='text-decoration: none;'>
                                
                            </span>
                        </div>
                    <div class='free-data'>
                        <i class='fa fa-map-marker'></i> " . $this->Util_model->get_info("regions", "name", "WHERE id=$row[region]") . ", " . $this->Util_model->get_info("states", "name", "WHERE id=$row[state]") . " " . $this->Util_model->get_info('countries', 'name', "WHERE id=$row[country]") . "
                    </div>";
                if ($row['free_shipping'] == 1) :
                    $view .= "
                    <div class='delivery'>
                        
                    </div>
                    ";
                endif;
                $view .= "
                </a>
                ";
                $count++;
            }
        }

        //Check if the number is up to 12 else get random product from product list
        if ($count < 12) {
            $s = $this->Db_model->selectGroup("*", "store_products", "ORDER BY RAND() LIMIT ".(12 - $count));
            if ($s->num_rows() > 0) {
                foreach ($s->result_array() as $row) {
                    //$data = $this->Util_model->get_info("data_bundle", "*", "WHERE id=$row[free_data]");
                    $view .= "
                    <a class='item-wrap' href='".base_url()."store/item/$row[id]'>";
                            $single_pic = $this->list_item_picture($row['picture'], false);
                            $view .= "
                        $single_pic
                        <div class='brand'>
                            ".$this->Util_model->get_info("store_main", "name", "WHERE sid=$row[sid]")."
                        </div>
                        <h3 class='name overflow'>
                            $row[name]
                        </h3>
                            <div class='price-box'>
                                <span class='price'>
                                    ₦".number_format($row['selling_price'])."
                                </span>
                                <span class='price exp' style='text-decoration: none;'>
                                    
                                </span>
                            </div>
                        <div class='free-data'>
                            <i class='fa fa-map-marker'></i> ".$this->Util_model->get_info("regions", "name", "WHERE id=$row[region]").", ".$this->Util_model->get_info("states", "name", "WHERE id=$row[state]")." ".$this->Util_model->get_info('countries', 'name', "WHERE id=$row[country]")."
                        </div>";
                            if ($row['free_shipping'] == 1) :
                                $view .= "
                        <div class='delivery'>
                            
                        </div>
                        ";
                            endif;
                            $view .="
                    </a>
                    ";
                    $count++;
                }
            }
        }
        if ($count == 0) {
            $views = "<p class='text-red'>No product found</p>";
        } else {
            $views = "
                <div class='item-list'>
                    $view
                </div>
                ";
        }
        return $views;
    }

    public function recently_viewed_item ()
    {
        $s = $this->Db_model->selectGroup("*", "store_recently_viewed", "WHERE uid=".$this->session->userdata(UID)." ORDER BY id DESC LIMIT 6");
        $view = "";
        if ($s->num_rows() == 0) {
            $view = "<p class='text-red'>No item viewed yet</p>";
        } else {
            $view .= "<div class='item-list'>";
            foreach ($s->result_array() as $row1) {
                $row = $this->Db_model->select("*", "store_products", "WHERE id=$row1[pid]");
                //$data = $this->Util_model->get_info("data_bundle", "*", "WHERE id=$row[free_data]");
                $view .= "
                <a class='item-wrap' href='" . base_url() . "store/item/$row[id]'>";
                $single_pic = $this->list_item_picture($row['picture'], false);
                $view .= "
                    $single_pic
                    <div class='brand'>
                        " . $this->Util_model->get_info("store_main", "name", "WHERE sid=$row[sid]") . "
                    </div>
                    <h3 class='name overflow'>
                        $row[name]
                    </h3>
                        <div class='price-box'>
                            <span class='price'>
                                ₦" . number_format($row['selling_price']) . "
                            </span>
                            <span class='price exp' style='text-decoration: none;'>
                                
                            </span>
                        </div>
                    <div class='free-data'>
                        <i class='fa fa-map-marker'></i> " . $this->Util_model->get_info("regions", "name", "WHERE id=$row[region]") . ", " . $this->Util_model->get_info("states", "name", "WHERE id=$row[state]") . " " . $this->Util_model->get_info('countries', 'name', "WHERE id=$row[country]") . "
                    </div>";
                if ($row['free_shipping'] == 1) :
                    $view .= "
                    <div class='delivery'>
                        
                    </div>
                    ";
                endif;
                $view .= "
                </a>
                ";
            }
            $view .= "</div>";
        }
        return $view;
    }

    public function single_item ($item_id) {
        $s = $this->Db_model->selectGroup("*", "store_products", "WHERE id=$item_id AND status=1");
        if ($s->num_rows() == 0) {
            $view = "<div class='well text-center'>Item not found.</div>";
        } else {
            $item = $s->row_array();
            $s_main = $this->Util_model->get_info("store_main", "*", "WHERE sid=$item[sid]");
            $s_pro = $this->Util_model->get_info("store_profile", "*", "WHERE sid=$item[sid]");
            $picture = $this->list_item_picture($item['picture']);
            if ($s_main['uid'] == $this->session->userdata(UID)) {
                $btn = "<a href='".base_url()."store/edit-item/$item_id' class='btn btn-primary btn-lg btn-flat'>Edit</a>";
            } else {
                $btn = "<button class='btn btn-warning btn-lg btn-flat' onclick='add_to_cart($(this), \"".base_url()."\", $item_id)'>Buy Now</button>";
            }
            $view ="
            <div class='col-lg-5 col-md-5 col-sm-5 col-xs-12 preview'>
                $picture[single]
                <span class='label label-warning' style='position: absolute; bottom: 10px; right: 20px; font-size: 16px'>
                    <i class='fa fa-image'></i> $picture[count]
                </span>
                <div class='no-display'>
                    $picture[slide]
                </div>
            </div>
            <div class='col-lg-7 col-md-7 col-sm-7 col-xs-12 details-wrapper'>
                <h2 class='title'>
                    $item[name]
                </h2>
                <div class='sub-title overflow'>
                    Store: <a href='".base_url()."s/$s_pro[slug]' class='text-red'>$s_main[name]</a>
                </div>
                <div class='detail-features'>
                    <div class='key-features'>
                        DETAILS
                    </div>
                    <div class='features'>
                        $item[description]
                    </div>";
                    if ($item['options'] != "") :
                    $view .= "
                    <div class='key-features'>
                        SELECT FROM THE OPTIONS
                    </div>";
                        if (strstr($item['options'], "|")) :
                            $options = explode("|", $item['options']);
                            $count = 1;
                            foreach ($options as $opts) {
                                $opt_r = explode("=", $opts);
                                $view .= "
                                <p class='top-1x'>$opt_r[0]</p>
                                <span id='opts-$count' class='options no-display'></span>
                                ";
                                foreach (explode(",", $opt_r[1]) as $opt_l) {
                                    $view .= "<input type='radio' name='$count' value='$opt_l' onchange='item_option($(this).val(), _(\"opts-$count\"))'> $opt_l <br>";
                                }
                                $view .= "
                                ";
                                $count++;
                            }
                        else :
                            $opt_r = explode("=", $item['options']);
                            $view .= "
                                <p>$opt_r[0]</p>
                                <span id='opts-1' class='options no-display'></span>
                                ";
                            foreach (explode(",", $opt_r[1]) as $opt_l) {
                                $view .= "<input type='radio' name='1' value='$opt_l' onchange='item_option($(this).val(), _(\"opts-1\"))'> $opt_l <br>";
                            }
                        endif;
                    endif;
                $view .= "
                </div>
                <div class='details-footer'>
                    <div class='price-box'>
                        <div>
                            <span class='price' style='font-weight: 700; font-size: 20px;'>
                                ₦".number_format($item['selling_price'])."
                            </span>
                        </div>
                        <span class='price exp' style='font-size: 14px'>
                            
                        </span>
                    </div>
                    <div class='action'>
                        $btn
                    </div>
                    <div class='promotion-content'>
                        <div style='color: #F97F51;'><i class='fa fa-map-marker'></i> ".$this->Util_model->get_info("regions", "name", "WHERE id=$item[region]").", ".$this->Util_model->get_info("states", "name", "WHERE id=$item[state]")." ".$this->Util_model->get_info('countries', 'name', "WHERE id=$item[country]")."</div>
                        <div class='delivery'>
                            
                        </div>
                    </div>
                </div>
            </div>
            ";
        }

        //Add to recently viewed item
        if ($this->Util_model->row_count("store_recently_viewed", "WHERE uid=".$this->session->userdata(UID)." AND pid=$item_id") > 0) {
            $this->Db_model->delete("store_recently_viewed", "WHERE uid=".$this->session->userdata(UID)." AND pid=$item_id");
        }
        $this->Db_model->insert("store_recently_viewed", ["uid"=>$this->session->userdata(UID), "pid"=>$item_id]);
        return $view;
    }

    public function branded_items ($item_id) {
        $brand_id = $this->Util_model->get_info("store_products", "*", "WHERE id=$item_id");
        $s = $this->Db_model->selectGroup("*", "store_products", "WHERE (sid=sid OR cat_id=$brand_id[cat_id] OR state=$brand_id[state] OR region=$brand_id[region]) AND id<>$brand_id[id] AND status=1 ORDER BY RAND() LIMIT 6");
        if ($s->num_rows() == 0) {
            $view = "<div class='well text-center'>No item found.</div>";
        } else {
            $view = '
            <div class="item-list">
            ';
            foreach ($s->result_array() as $row) {
                $single_pic = $this->list_item_picture($row['picture'], false);
                $view .= "
                <a class='item-wrap' href='".base_url()."store/item/$row[id]'>
                    $single_pic
                    <div class='brand'>
                        ".$this->Util_model->get_info("store_main", "name", "WHERE sid=$row[sid]")."
                    </div>
                    <div class='name'>
                        $row[name]
                    </div>
                        <div class='price-box'>
                            <span class='price'>
                                ₦".number_format($row['selling_price'])."
                            </span>
                            <span class='price exp' style='text-decoration: none;'>
                                
                            </span>
                        </div>
                    <div class='free-data'>
                        <i class='fa fa-map-marker'></i> ".$this->Util_model->get_info("regions", "name", "WHERE id=$row[region]").", ".$this->Util_model->get_info("states", "name", "WHERE id=$row[state]")." ".$this->Util_model->get_info('countries', 'name', "WHERE id=$row[country]")."
                    </div>
                    <div class='delivery'>
                        
                    </div>
                </a>
                ";
            }
            $view .= "</div>";
        }
        return $view;
    }

    public function list_cart ($uid) {
        $s = $this->Db_model->selectGroup("*", "store_cart", "WHERE uid=$uid");
        if ($s->num_rows() > 0) {
            $view = "
            <table class='table table-bordered'>
                <thead>
                    <th>#</th>
                    <th>ITEM</th>
                    <th class='text-center'>QUANTITY</th>
                    <th class='text-center'>UNIT PRICE</th>
                    <th class='text-center'>SUB TOTAL</th>
                </thead>
                <tbody>
            ";
            $count = 1;
            $total_sp = 0;
            $delivery = 0;
            $sid = 0;
            foreach ($s->result_array() as $row) {
                $ss = $this->Db_model->selectGroup("*", "store_products", "WHERE id=$row[item_id] AND status=1");
                if ($ss->num_rows() == 0) {
                    $view .= "
                    <tr>
                        <td>$count</td>
                        <td colspan='4'>Unavailable</td>
                    </tr>
                    ";
                } else {
                    $item = $ss->row_array();
                    $item_sp = $item['selling_price'] * $row['item_count'];
                    $total_sp += $item_sp;
                    $options = "";

                    for ($i=1; $i<=10; $i++) {
                        $sel = ($i == $row['item_count']) ? "selected='selected'" : "";
                        $options .= "<option value='$i' $sel>$i</option>/n";
                    }
                    $view .= "
                    <tr>
                        <td>$count</td>
                        <td>
                            <table width='100%'>
                                <tr>
                                    <td rowspan='3' valign='top' align='middle' width='10%' style='padding-right:10px'>
                                        ".$this->list_item_picture($item['picture'], false, "style='width: 45px; height: auto' alt='$item[name]'")."
                                    </td>
                                    <td class='text-muted font-xs' width='90%'>".$this->Util_model->get_info("store_main", "name", "WHERE sid=$item[sid]")."</td>
                                </tr>
                                <tr>
                                    <td>
                                        <h5 class='text-bold' style='margin-bottom: 0px;'><a href='".base_url()."store/item/$item[id]'>$item[name]</a></h5>
                                        ".($row['item_options'] != '' ? "<span class='font-sm'>Options: $row[item_options]</span>" : '')."
                                        <small></small>
                                    </td>
                                </tr>
                                <tr>
                                    <td class='text-bold' style='padding-top: 5px'>
                                        <a class='text-red' href='".base_url()."store/remove_from_cart/$row[item_id]'>
                                            <i class='fa fa-trash'></i> REMOVE
                                        </a>
                                    </td>
                                </tr>
                            </table>
                        </td>
                        <td class='text-center'>
                            <select class='form-control' onchange='add_item_count(\"".base_url()."\", $item[id], $(this).val())'>
                                $options
                            </select>
                        </td>
                        <td class='text-center'>
                            <p>₦".number_format($item['selling_price'])."</p>
                        </td>
                        <td class='text-center'>
                            <p>₦".number_format($item_sp)."</p>
                        </td>
                    </tr>
                    ";
                    if ($item['sid'] != $sid) {
                        $delivery = $this->Util_model->get_option("delivery_fee");
                        $sid = $item['sid'];
                    }
                }
                $count++;
            }
            $view .= "
                </tbody>
                <tfoot class='no-border'>
                    <tr>
                        <td colspan='5' class='text-right' style='padding: 40px 10px'>
                            <p class='font-lg'>
                                <span>Subtotal: ₦".number_format($total_sp)."</span><br>
                                <span>Delivery fee: ₦".number_format($delivery)."</span><br>
                                <span class='text-bold' style='font-size: 23px'>Total: <span class='text-yellow'>₦".number_format($total_sp + $delivery)."</span></span>
                            </p>
                            NB: Delivery fee increases when you make your other from different stores.
                        </td>
                    </tr>
                </tfoot>
            </table>
            ";
        } else {
            $view = "<div class='well text-center'>No item found in cart. <a href='".base_url()."store'>Continue shopping</a></div>";
        }
        return $view;
    }

    public function list_mini_cart ($uid) {
        $s = $this->Db_model->selectGroup("*", "store_cart", "WHERE uid=$uid");
        if ($s->num_rows() > 0) {
            $view = "";
            $count = 1;
            $total_sp = 0;
            $total_exp = 0;
            $delivery = 0;
            $sid = 0;
            $view = "<div class='sum'>";
            foreach ($s->result_array() as $row) {
                $ss = $this->Db_model->selectGroup("*", "store_products", "WHERE id=$row[item_id] AND status=1");
                $item = $ss->row_array();
                $item_sp = $item['selling_price'] * $row['item_count'];
                $item_exp = $item_sp * $this->Util_model->get_option('coin_price');
                $total_sp += $item_sp;
                $total_exp += $item_exp;
                if ($item['sid'] != $sid) {
                    $delivery = $this->Util_model->get_option("delivery_fee");
                    $sid = $item['sid'];
                }
                $view .= "
                <div class='prod_sum brdb -pts -pbs -plm -prm'>
                    <div class='col-s -mts'>
                        ".$this->list_item_picture($item['picture'], false, "width='60' height='60' class='lazy image' alt='$item[name]' title='$item[name]'")."
                    </div>
                    <div class='col-l -mts'>
                        <span class='-ellipsis-2'>$item[name]</span>
                        <span class='-mts text-yellow'>
                            ₦".number_format($item['selling_price'], 2)."
                        </span>
                        <div class='-mts'>
                            <span class='text-muted'>Qty:</span>&nbsp;$row[item_count]
                        </div>
                    </div>
                </div>
                ";
            }
            $view .= "
            </div>
            <div class='osh-resume -mtxl -plm -prm'>
                <div class='ft-subtotal color-default -pbm price_row '>
                    <span class='price_col-desc'>Subtotal</span>
                    <span class='price_col-value'>₦".number_format($total_sp, 2)."</span>
                </div>
                <div class='applied-shipping ft-shipping-amount color-default -pbm price_row '>
                    <span class='price_col-desc'>Delivery fee</span>
                    <span class='price_col-value -b'>₦".number_format($delivery)."</span>
                </div>
                <div class='cart-rules js-cart-rules ft-price-cart-rules'></div>
                <div class='total ft-total brdt -ptl text-black -fwm' style='font-size: 17px'> Total
                    <div class='total-value text-yellow'>
                        ₦".number_format(($total = $total_sp + $delivery), 2)."<br>
                    </div>
                </div>
            </div>
            <span class='no-display' id='total'>$total</span>
            <div class='text-center -fwm -fs-14 -upp -mtxxl' style='font-size: 17px'>
                <a class='tex-bold text-yellow' href='".base_url()."store/cart'>Modify Cart</a>
                <button class='btn btn-success btn-flat top-1x font-1x' style='width:100%' onclick='confirm_order()'>Confirm Order</button>
            </div>
            ";
        } else {
            $view = "<p class='text-red' style='padding:10px'>No item found in cart. <a href='".base_url()."store'>Continue shopping</a></p>";
        }
        return $view;
    }

    public function order_total ($uid) {
        $s = $this->Db_model->selectGroup("item_id, item_count", "store_cart", "WHERE uid=$uid");
        $total_sp = 0;
        $total_exp = 0;
        if ($s->num_rows() > 0) {
            foreach ($s->result_array() as $row) {
                $ss = $this->Db_model->selectGroup("selling_price, exp_earnings", "store_products", "WHERE id=$row[item_id] AND status=1");
                if ($ss->num_rows() > 0) {
                    $item = $ss->row_array();
                    $item_sp = $item['selling_price'] * $row['item_count'];
                    $item_exp = $item['exp_earnings'] * $row['item_count'];
                    $total_sp += $item_sp;
                    $total_exp += $item_exp;
                }
            }
        }
        return [
            "selling_price"     =>  $total_sp,
            "exp_earnings"         =>  $total_exp
        ];
    }

    public function get_selling_exp ($selling) {
        $exp = $selling / 6;
        $per = get_percentage($exp, 20);
        $exp += $per;
        return [
            "selling_price"     =>   number_format($selling),
            "exp_earnings"      =>  number_format($exp)
        ];
    }

    public function  confirm_order ($uid, $post) {
        $s = $this->Db_model->selectGroup("item_id, item_count", "store_cart", "WHERE uid=$uid");
        if ($s->num_rows() > 0) {
            $items = "";
            $selling_price = 0;
            $total_sell_price = 0;
            $count = 0;
            $order_no = $this->Util_model->generate_id(11111111, 99999999, "store_order", "order_no");
            foreach ($s->result_array() as $row) {
                $package_no = $this->Util_model->generate_id(11111111, 99999999, "store_order", "package_no");
                $item = $this->Util_model->get_info("store_products", "*", "WHERE id=$row[item_id]");
                $selling_price = ($item['selling_price'] * $row['item_count']);
                $total_sell_price += ($item['selling_price'] * $row['item_count']);
                $data = array(
                    "uid"           =>  $this->session->userdata(UID),
                    "sid"           =>  $item['sid'],
                    "order_no"      =>  $order_no,
                    "package_no"    =>  $package_no,
                    "item"          =>  $row['item_id'],
                    "price"         =>  $item['selling_price'],
                    "pieces"        =>  $row['item_count'],
                    "total"         =>  $selling_price,
                    "expiry"        =>  set_expire_date(24),
                    "status"        =>  1
                );
                if ($this->Db_model->insert("store_order", $data)) {
                    $count++;
                }
            }

            if ($count == $s->num_rows()) {
                $input = array (
                    "uid"           =>  $uid,
                    "order_no"      =>  $order_no,
                    "first_name"    =>  $post['fname'],
                    "last_name"     =>  $post['lname'],
                    "phone_code1"   =>  $post['phone_code1'],
                    "phone1"        =>  ltrim($post['phone1'], 0),
                    "phone_code2"   =>  $post['phone_code2'],
                    "phone2"        =>  ltrim($post['phone2'], 0),
                    "address"       =>  $post['address'],
                    "landmark"      =>  $post['landmark'],
                    "state"         =>  $post['state'],
                    "region"        =>  $post['lga']
                );
                $this->Db_model->insert("store_address", $input);
                $return = [
                    "status"        =>  true,
                    "redirect"      =>  base_url()."store/store-orders"
                ];
                $this->Main_model->update_escrow($this->session->userdata(UID), $total_sell_price);
                $this->Main_model->add_to_wallet(get_percentage($total_sell_price, $this->Util_model->get_option('VAT')), $this->Util_model->get_info("user_profile", "uid", "WHERE role=3 LIMIT 1"), $this->session->userdata(UID), "Purchase VAT", "Purchase VAT", "VAT", $order_no, "", 1);
                $this->Db_model->delete("store_cart", "WHERE uid=".$this->session->userdata(UID));
                $this->session->set_flashdata("msg", alert_msg("<i class='fa fa-check-circle'></i> Order <b>$order_no</b> confirmed successfully and ".number_format($total_sell_price, 2)." held in escrow", "alert-success", 1));
            } else {
                $this->Db_model->delete("store_order", "WHERE order_no='$order_no'");
                $return = [
                    "status"        =>  false,
                    "message"      =>  "Unable to complete order at the moment. Try again later"
                ];
            }
        } else {
            $return = [
                "status"        =>  false,
                "message"      =>  "No item selected"
            ];
        }
        return $return;
    }

    public function list_orders ($sid)
    {
        $s = $this->Db_model->query("SELECT DISTINCT order_no FROM store_order WHERE sid=$sid ORDER BY id DESC");
        if ($s->num_rows() > 0) {
            $view = "
            <div class='box-group' id='accordion'>
            ";
            foreach ($s->result_array() as $row) {
                $view .= "
                <div class='panel box box-default no-border'>
                  <div class='box-header with-border'>
                    <h4 class='box-title'>
                      <a data-toggle='collapse' data-parent='#accordion' href='#$row[order_no]'>
                        Order #$row[order_no]
                      </a>
                    </h4>
                    <span class='label bg-blue-active pull-right'>" . $this->Util_model->row_count("store_order", "WHERE sid=$sid AND order_no=$row[order_no] AND status=1") . " Open order(s)</span>
                  </div>
                  <div id='$row[order_no]' class='panel-collapse collapse'>
                    <div class='box-body table-responsive'>
                ";
                $ss = $this->Db_model->selectGroup("*", "store_order", "WHERE sid=$sid AND order_no=$row[order_no]");
                if ($ss->num_rows() == 0) {
                    $view .= "<p class='text-red'><i class='fa fa-times-circle'></i> No package found on this order</p>";
                } else {
                    $view .= '
                      <table id="dataTable" class="table table-bordered table-striped">
                        <thead>
                        <tr>
                            <th class="text-center">Package No</th>
                            <th class="text-center">Ordered By</th>
                            <th class="text-center">Item</th>
                            <th class="text-center">Sub Price</th>
                            <th class="text-center">Total Price</th>
                            <th class="text-center">Status</th>
                            <th class="text-center">Created</th>
                            <th class="text-center">Delivery</th>
                            <th class="text-center"></th>
                        </tr>
                        </thead>
                        <tbody>';
                    foreach ($ss->result_array() as $row) {
                        if ($row['status'] == 1) {
                            $stat = "<span class='label label-success'>Active</span>";
                            $delivery = date_difference($row['expiry'], date_time(), "j:i:s");
                            $track = "";
                            //$track = " <a href='" . base_url() . "store/extend-delivery/$row[package_no]' class='btn btn-primary btn-xs'>Extend</a>";
                            //$track .= " <a href='" . base_url() . "store/cancel-order/$row[package_no]' class='btn btn-danger btn-xs'>Cancel</a>";
                        } else if ($row['status'] == 0) {
                            $stat = "<span class='label label-danger'>Cancelled</span>";
                            $track = "";
                            $delivery = "Cancelled";
                        } else {
                            $stat = "<span class='label label-primary'>Delivered</span>";
                            $track = "";
                            $delivery = "Delivered";
                        }
                        $view .= "
                            <tr class='text-center font-sm'>
                                <td class='text-bold'>$row[package_no]</td>
                                <td>".$this->Util_model->get_user_info($row['uid'])."</td>
                                <td>" . $this->Util_model->get_info("store_products", "name", "WHERE id=$row[item]") . "<br><small class='text-orange font-sm'>$row[pieces] piece(s)</small></td>
                                <td>" . number_format($row['price'], 2) . " MEX</td>
                                <td>" . number_format($row['total'], 2) . " MEX</td>
                                <td>$stat</td>
                                <td>$row[date]</td>
                                <td>$delivery</td>
                                <td>
                                    <a href='" . base_url() . "store/item/$row[item]' class='btn btn-info btn-xs'>Details</a>
                                    $track 
                                </td>
                            </tr>\n
                        ";
                    }
                    $view .= "
                        </tbody>
                      </table>
                    ";
                }
                $view .= "
                    </div>
                    <div class='box-footer'>
                      <span class='font-sm text-orange'>Slide right on mobile</span> 
                      <a class='btn btn-primary btn-flat btn-sm pull-right' href='".base_url()."store/print_order_invoice/$sid/$row[order_no]'>Print Invoice</a>
                    </div>
                  </div>
                </div>
                ";
            }
        } else {
            $view = "<p class='text-red'><i class='fa fa-times-circle'></i> No order found</p>";
        }
        return $view;
    }

    public function print_invoice ($order_no, $sid) {
        $s = $this->Db_model->selectGroup("*", "store_order", "WHERE sid=$sid AND order_no=$order_no");
        if ($s->num_rows() == 0) {
            $view = "Broken link, try again soon";
        } else {
            $main = $this->Db_model->select("*", "store_main", "WHERE sid=$sid");
            $pro = $this->Db_model->select("*", "store_profile", "WHERE sid=$sid");
            $this->load->library("Fpdf/Fpdf");
            $pdf = new Fpdf();
            $pdf->SetMargins(0, 0);
            $pdf->AddPage();
            $pdf->Image(FCPATH."/assets/img/watermark.png",30,80,150,165);
            $pdf->SetFillColor(243, 156, 18); // Fill color
            $pdf->Cell(0, 3, '', 0, 1, '', 1);
            $pdf->SetFillColor(236, 240, 241); // Fill color
            $pdf->Cell(0, 10, '', 0, 1, 'R', 1);
            $pdf->SetFont('times','',14);
            $pdf->Cell(28, 10, '', 0, 0, '', 1);
            $pdf->Cell(145, 10, $main['name'], 0, 0, '', 1);
            $pdf->SetFont('courier','B',18);
            $pdf->SetTextColor(241, 196, 15); // yellow text color
            $pdf->Cell(38, 10, 'INVOICE', 0, 1, 'C', 1);
            $pdf->SetFont('times','',11); // font styles
            $pdf->SetTextColor(44, 62, 80); // midnight blue text color
            $pdf->Cell(28, 10, '', 0, 0, '', 1);
            $pdf->Cell(185, 5, $pro['address'].", ".$this->Util_model->get_info("states", "name", "WHERE id=$pro[state]")." state, ".$this->Util_model->get_info("countries", "name", "WHERE id=$pro[country]"), 0, 1, '', 1);
            //Address
            $pdf->Cell(28, 10, '', 0, 0, '', 1);
            $pdf->Cell(145, 5, 'Phone: '.$this->Util_model->get_info("countries", "phone_code", "WHERE id=$pro[country]")."$pro[phone]", 0, 0, '', 1);
            $pdf->Cell(37, 5, date("jS M, Y"), 0, 1, 'C', 1);
            //Phone
            $pdf->Cell(28, 10, '', 0, 0, '', 1);
            $pdf->Cell(182, 5, "Email: $pro[email]", 0, 1, '', 1);
            //Email
            $pdf->SetFont('times','B',14); // font styles
            $pdf->Cell(173, 15, '', 0, 0, '', 1);
            $pdf->Cell(37, 15, "No. $order_no", '', 1, 'C', 1);
            //invoice no
            $pdf->Cell(0, 10, '', 0, 1);
            //Spacer
            $pdf->SetFont('times','B',12); // font styles
            $pdf->SetDrawColor(189, 195, 199); // Border color
            $pdf->Cell(7, 7, ''); // Left margin
            $pdf->Cell(93, 7, 'BILL TO', 'B');
            $pdf->Cell(10, 7, '', 0);// Center space
            $pdf->Cell(93, 7, 'SHIP TO', 'B');
            $pdf->Cell(7, 7, '', 0, 1); // Right margin
            //Table header
            $uid = $this->Util_model->get_info("store_order", "uid", "WHERE order_no=$order_no AND sid=$sid LIMIT 1");
            $u_main = $this->Db_model->select("*", "user_main", "WHERE uid=$uid");
            $u_pro = $this->Db_model->select("*", "user_profile", "WHERE uid=$uid");
            $s_ship = $this->Db_model->select("*", "store_address", "WHERE order_no=$order_no LIMIT 1");
            $pdf->SetFont('times','',12); // font styles
            $pdf->Cell(7, 5, ''); // Left margin
            $pdf->Cell(93, 5, ucwords($u_main['name']));
            $pdf->Cell(10, 5, '', 0);// Center space
            $pdf->Cell(93, 5, ucwords("$s_ship[first_name] $s_ship[last_name]"));
            $pdf->Cell(7, 5, '', 0, 1); // Right margin
            // Name
            $pdf->Cell(7, 5, ''); // Left margin
            $pdf->Cell(93, 5, $this->Util_model->get_info("regions", "name", "WHERE id=$u_pro[region]").", ".$this->Util_model->get_info("states", "name", "WHERE id=$u_pro[state]")." state, ".$this->Util_model->get_info("countries", "name", "WHERE id=$u_pro[country]"));
            $pdf->Cell(10, 5, '', 0);// Center space
            $pdf->Cell(93, 5, ucfirst("$s_ship[address]"));
            $pdf->Cell(7, 5, '', 0, 1); // Right margin
            // Address
            $pdf->Cell(7, 5, ''); // Left margin
            $pdf->Cell(93, 5, $this->Util_model->get_info("countries", "phone_code", "WHERE id=$u_pro[country]").$u_pro['phone']);
            $pdf->Cell(10, 5, '', 0);// Center space
            $pdf->Cell(93, 5, ucfirst("$s_ship[landmark]"));
            $pdf->Cell(7, 5, '', 0, 1); // Right margin
            // Address 1
            $pdf->Cell(7, 5, ''); // Left margin
            $pdf->Cell(93, 5, $u_pro['email']);
            $pdf->Cell(10, 5, '', 0);// Center space
            $pdf->Cell(93, 5, $this->Util_model->get_info("regions", "name", "WHERE id=$s_ship[region]").", ".$this->Util_model->get_info("states", "name", "WHERE id=$s_ship[state]")." state, ".$this->Util_model->get_info("countries", "name", "WHERE phone_code='$s_ship[phone_code1]'"));
            $pdf->Cell(7, 5, '', 0, 1); // Right margin
            // Address 2
            $pdf->Cell(7, 5, ''); // Left margin
            $pdf->Cell(93, 5, '');
            $pdf->Cell(10, 5, '', 0);// Center space
            $pdf->Cell(93, 5, $s_ship['phone_code1'].$s_ship['phone1'].($s_ship['phone2'] != '' ? ' or '.$s_ship['phone_code2'].$s_ship['phone2'] : ''));
            $pdf->Cell(7, 5, '', 0, 1); // Right margin
            // Address 3
            $pdf->Cell(0, 15, '', 0, 1); // Empty space

            $pdf->SetFont('helvetica','B',10); // font styles
            $pdf->SetFillColor(243, 156, 18); // Fill color
            $pdf->SetDrawColor(243, 156, 18); // Border color
            $pdf->SetTextColor(255, 255, 255); // Text color
            $pdf->Cell(7, 7, ''); // Left margin
            $pdf->Cell(30, 7, 'PACKAGE NO', 1, 0, 'C', 1);
            $pdf->Cell(80, 7, 'DESCRIPTION', 1, 0, 'C', 1);
            $pdf->Cell(20, 7, 'QTY', 1, 0, 'C', 1);
            $pdf->Cell(33, 7, 'UNIT (MEX)', 1, 0, 'C', 1);
            $pdf->Cell(33, 7, 'TOTAL (MEX)', 1, 0, 'C', 1);
            $pdf->Cell(7, 7, '', 0, 1); // Right margin
            // Table header

            $pdf->SetFont('helvetica','',10); // font styles
            $pdf->SetDrawColor(189, 195, 199); // Border color
            $pdf->SetTextColor(0, 0, 0); // Text color

            $count = 1;
            $total = 0;
            foreach ($s->result_array() as $row) {
                if ($count == $s->num_rows()) {
                    $pdf->Cell(7, 7, '', 'L'); // Left margin
                    $pdf->Cell(30, 7, $row['package_no'], 'LB', 0, 'C');
                    $pdf->Cell(80, 7, $this->Util_model->get_info("store_products", "name", "WHERE id=$row[item]"), 'LB', 0, 'L');
                    $pdf->Cell(20, 7, $row['pieces'], 'LB', 0, 'C');
                    $pdf->Cell(33, 7, number_format($row['price'], 2), 'LB', 0, 'R');
                    $pdf->Cell(33, 7, number_format($row['total'], 2), 'LB', 0, 'R');
                    $pdf->Cell(7, 7, '', 'LR', 1); // Right margin
                    // Table content
                } else {
                    $pdf->Cell(7, 7, '', 'L'); // Left margin
                    $pdf->Cell(30, 7, $row['package_no'], 'L', 0, 'C');
                    $pdf->Cell(80, 7, $this->Util_model->get_info("store_products", "name", "WHERE id=$row[item]"), 'L', 0, 'L');
                    $pdf->Cell(20, 7, $row['pieces'], 'L', 0, 'C');
                    $pdf->Cell(33, 7, number_format($row['price'], 2), 'L', 0, 'R');
                    $pdf->Cell(33, 7, number_format($row['total'], 2), 'L', 0, 'R');
                    $pdf->Cell(7, 7, '', 'LR', 1); // Right margin
                    // Table content
                }
                $count++;
                $total += $row['total'];
            }
            $pdf->Cell(7, 9, '', 0); // Left margin
            $pdf->Cell(100, 9, '', 0);
            $pdf->Cell(43, 9, 'SUB TOTAL', 'LT', 0, 'R');
            $pdf->Cell(53, 9, number_format($total, 2), 'TBRL', 0, 'R');
            $pdf->Cell(7, 9, '', 0, 1); // Right margin
            // Subtotal content
            $pdf->Cell(7, 9, '', 0); // Left margin
            $pdf->Cell(100, 9, '', 0);
            $pdf->Cell(43, 9, 'DISCOUNT', 'L', 0, 'R');
            $pdf->Cell(53, 9, '0.00', 'BRL', 0, 'R');
            $pdf->Cell(7, 9, '', 0, 1); // Right margin
            // Discount content
            $vat = get_percentage($total, $this->Util_model->get_option('VAT'));
            $total_vat = $total + $vat;
            $total_vat_ex = $total_vat * $this->Util_model->get_option('VAT');
            $pdf->Cell(7, 9, '', 0); // Left margin
            $pdf->Cell(100, 9, '', 0);
            $pdf->Cell(43, 9, 'VAT', 'L', 0, 'R');
            $pdf->Cell(53, 9, number_format($vat, 2), 'BRL', 0, 'R');
            $pdf->Cell(7, 9, '', 0, 1); // Right margin
            // VAT content
            $pdf->SetFillColor(236, 240, 241); // Fill color
            $pdf->SetFont('helvetica','B',12); // font styles
            $pdf->Cell(7, 3, '', 0); // Left margin
            $pdf->Cell(100, 3, '', 0, 0, 'R');
            $pdf->Cell(43, 3, '', 'LT', 0, 'R');
            $pdf->Cell(53, 3, '', 'TRL', 0, 'RL', 1);
            $pdf->Cell(7, 3, '', 0, 1); // Right margin
            // Balance due
            $pdf->SetFont('helvetica','B',11); // font styles
            $pdf->Cell(7, 3, '', 0); // Left margin
            $pdf->Cell(100, 3, '', 0, 0, 'R');
            $pdf->Cell(43, 3, '', 'L', 0, 'R');
            $pdf->Cell(53, 3, number_format($total_vat, 2)." MEX", 'RL', 0, 'R', 1);
            $pdf->Cell(7, 3, '', 0, 1); // Right margin
            // Balance due
            $pdf->SetFont('helvetica','B',12); // font styles
            $pdf->Cell(7, 3, '', 0); // Left margin
            $pdf->Cell(100, 3, '', 0, 0, 'R');
            $pdf->Cell(43, 3, 'BALANCE DUE', 'L', 0, 'R');
            $pdf->Cell(53, 3, '', 'RL', 0, 'RL', 1);
            $pdf->Cell(7, 3, '', 0, 1); // Right margin
            // Balance due
            $pdf->SetFont('helvetica','',9); // font styles
            $pdf->Cell(7, 3, '', 0); // Left margin
            $pdf->Cell(100, 3, '', 0, 0, 'R');
            $pdf->Cell(43, 3, '', 'L', 0, 'R');
            $pdf->Cell(53, 3, number_format($total_vat_ex, 2)." NGN", 'RL', 0, 'R', 1);
            $pdf->Cell(7, 3, '', 0, 1); // Right margin
            // Balance due1
            $pdf->SetFont('helvetica','',9); // font styles
            $pdf->Cell(7, 3, '', 0); // Left margin
            $pdf->Cell(100, 3, '', 0, 0, 'R');
            $pdf->Cell(43, 3, '', 'LB', 0, 'R');
            $pdf->Cell(53, 3, '', 'BRL', 0, 'R', 1);
            $pdf->Cell(7, 3, '', 0, 1); // Right margin
            // Balance due1
            $pdf->Cell(7, 15, ''); // Left margin
            $pdf->Cell(73, 15, 'Received By');
            $pdf->Cell(50, 15, '', 0);// Center space
            $pdf->Cell(73, 15, 'Approved By');
            $pdf->Cell(7, 15, '', 0, 1); // Right margin
            // Signing remark
            $pdf->Cell(7, 20, ''); // Left margin
            $pdf->Cell(73, 20, '', 'B');
            $pdf->Cell(50, 20, '', 0);// Center space
            $pdf->Cell(73, 20, '', 'B');
            $pdf->Cell(7, 20, '', 0, 1); // Right margin
            // Signing space
            $pdf->Cell(7, 10, ''); // Left margin
            $pdf->Cell(196, 10, "NB: Please send two copies of the invoice, one for the customer the other for the seller to avoid dispute. Thanks");
            $pdf->Cell(7, 10, '', 0, 1); // Right margin
            // Signing space



            $pdf->Image(FCPATH."/$main[pic_url]",4,12,25,25); // Logo
            $pdf->Output();
        }
    }
}

?>