<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Airtime To Cash Orders
            <small>All airtime to cash orders done by users</small>
        </h1>
        <?php echo $breadcrumb; ?>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-xs-12" id="msg">
                <?php echo $this->session->userdata('msg'); ?>
            </div>
        </div>
        <div class="row">
            <div class="col-xs-12">
                <div class="box no-border">
                    <div class="box-header">
                        <h3 class="box-title">Orders</h3>
                    </div>
                    <!-- /.box-header -->
                    <div class="box-body table-responsive">
                        <table id="dataTable" class="table table-bordered table-striped">
                            <thead>
                            <tr>
                                <th class="text-center">Status</th>
                                <th class="text-center">Reference</th>
                                <th class="text-center">Username</th>
                                <th class="text-center">Network</th>
                                <th class="text-center">Amount (Receive)</th>
                                <th class="text-center">Funding</th>
                                <th class="text-center">Phone Number</th>
                                <th class="text-center">Date</th>
                                <th class="text-center"></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php
                            $s = $this->Db_model->selectGroup("*", "airtime_to_cash", "ORDER BY id DESC, status");
                            if ($s->num_rows() > 0) {
                                foreach ($s->result_array() as $row) {
                                    $network = $this->Util_model->get_info("networks", "network", "WHERE id=$row[network]");
                                    if ($row['status'] == 0) {
                                        $status = "<span class='text-yellow'>Awaiting Payment</span>";
                                        $disable = "";
                                    } else if ($row['status'] == 1) {
                                        $status = "<span class='text-yellow'>Awaiting Confirmation</span>";
                                        $disable = "";
                                    } else if ($row['status'] == 2) {
                                        $status = "<span class='text-success'>Completed</span>";
                                        $disable = "disabled";
                                    } else {
                                        $status = "<span class='text-red'>Cancelled</span>";
                                        $disable = "disabled";
                                    }
                                    $amount = number_format($row['amount']);
                                    $amount_received = number_format($row['amount_received']);
                                    $username = $this->Util_model->get_user_info($row['uid'], "username", "profile");

                                    echo "
                                <tr class='text-center'>
                                    <td>$status</td>
                                    <td>$row[reference]</td>
                                    <td>$username</td>
                                    <td>$network</td>
                                    <td>₦$amount (₦$amount_received)</td>
                                    <td>$row[method]</td>
                                    <td>$row[phone_pin]</td>
                                    <td>$row[date]</td>
                                    <td>
                                        <button class='btn btn-success btn-xs' $disable type='button' title='Success' data-toggle='tooltip' onclick='convert_airtime(\"$row[id]\"); $(this).remove();'><i class='fa fa-check'></i> Confirm</button>
                                        <a href='".base_url()."admin/airtime-cash-cancel/$row[reference]' class='btn btn-danger btn-xs' data-toggle='tooltip' $disable> Cancel</a>
                                    </td>
                                </tr>\n
                            ";
                                }
                            }
                            ?>
                            </tbody>
                        </table>
                    </div>
                    <!-- /.box-body -->
                    <div class="box-footer">
                        <small class="text-warning">NB: Slide table left on <i>mobile</i></small>
                    </div>
                    <!--/.box-footer-->
                </div>
                <!-- /.box -->
            </div>
        </div>
        <!--/.row-->
    </section>
</div>

<!-- DataTables -->
<script src="<?php echo base_url(); ?>assets/plugins/datatables/jquery.dataTables.min.js"></script>
<script src="<?php echo base_url(); ?>assets/plugins/datatables/dataTables.bootstrap.min.js"></script>

<script>
    $(function () {

        $('#transTable').DataTable({
            "order":[0, "desc"]
        });

    });

    function convert_airtime (id) {
        if (confirm("Are you sure you want to convert this airtime to cash?\nMake sure that you have received the airtime because you can't undo this later.")) {
            $.post('<?php echo base_url(); ?>admin/airtime_cash_convert', {"id":id}, function () {
                msg("<i class='fa fa-check-circle'></i> Airtime converted successfully", "alert-success", 1, _('msg'));
                reloadPage(200);
            });
        }
    }
</script>
