<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Airtime To Cash Settings
            <small>Manage your airtime to cash phone numbers</small>
        </h1>
        <?php echo $breadcrumb; ?>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-xs-12" id="msg">
                <?php echo $this->session->userdata('msg'); ?>
            </div>
        </div>
        <div class="row">
            <div class="col-xs-12">
                <div class="box no-border">
                    <div class="box-header">
                        <h3 class="box-title">Settings</h3>
                    </div>
                    <!-- /.box-header -->
                    <div class="box-body">
                        <div class="table-responsive">
                            <table class="table table-condensed table-striped">
                                <?php echo form_open(base_url()."admin/airtime_cash_settings_submit"); ?>
                                <thead>
                                <tr>
                                    <th>Network</th>
                                    <th>Phone number</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php
                                $s = $this->Db_model->selectGroup("*", "airtime_to_cash_numbers");
                                if ($s->num_rows() == 0) {
                                    echo "
                                    <tr>
                                        <td colspan='5'>No airtime to cash numbers found</td>
                                    </tr>
                                    ";
                                } else {
                                    foreach ($s->result_array() as $row) {
                                        $network = $this->Util_model->get_info("networks", "network", "WHERE id=$row[network_id]");
                                        echo "
                                            <input type='hidden' name='net_id[]' value='$row[id]'>
                                            <tr>
                                                <td>
                                                    $network
                                                </td>
                                                <td>
                                                    <input class='form-control' type='number' name='phone[]' value='$row[phone]'>
                                                </td>
                                            </tr>
                                        ";
                                    }
                                }
                                ?>
                                </tbody>
                                <tfoot>
                                <tr>
                                    <td colspan='2' align='center'>
                                        <button class='btn btn-success' type='submit'>Update Phone Numbers</button>
                                    </td>
                                </tr>
                                </tfoot>
                                <?php echo form_close(); ?>
                            </table>
                        </div>
                        <hr>
                        <h3>Airtime To Cash Fee (%)</h3>
                        <div class="table-responsive">
                            <table class="table table-condensed table-striped">
                                <?php echo form_open(base_url()."admin/airtime_cash_fee_submit"); ?>
                                <thead>
                                <tr>
                                    <th>Network</th>
                                    <th>Fee (in percentage %)</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php
                                $s = $this->Db_model->selectGroup("*", "airtime_to_cash_fee");
                                if ($s->num_rows() == 0) {
                                    echo "
                                    <tr>
                                        <td colspan='5'>No airtime to cash fee found</td>
                                    </tr>
                                    ";
                                } else {
                                    foreach ($s->result_array() as $row) {
                                        $network = $this->Util_model->get_info("networks", "network", "WHERE id=$row[net_id]");
                                        echo "
                                            <input type='hidden' name='net_id[]' value='$row[id]'>
                                            <tr>
                                                <td>
                                                    $network
                                                </td>
                                                <td>
                                                    <input class='form-control' type='number' name='charge[]' value='$row[charge]'>
                                                </td>
                                            </tr>
                                        ";
                                    }
                                }
                                ?>
                                </tbody>
                                <tfoot>
                                <tr>
                                    <td colspan='2' align='center'>
                                        <button class='btn btn-success' type='submit'>Update Fee</button>
                                    </td>
                                </tr>
                                </tfoot>
                                <?php echo form_close(); ?>
                            </table>
                        </div>
                    </div>
                    <!-- /.box-body -->
                    <div class="box-footer">
                        <small class="text-warning">NB: Slide table left on <i>mobile</i></small>
                    </div>
                    <!--/.box-footer-->
                </div>
                <!-- /.box -->
            </div>
        </div>
        <!--/.row-->
    </section>
</div>

<!-- DataTables -->
<script src="<?php echo base_url(); ?>assets/plugins/datatables/jquery.dataTables.min.js"></script>
<script src="<?php echo base_url(); ?>assets/plugins/datatables/dataTables.bootstrap.min.js"></script>

<script>
    $(function () {

        $('#transTable').DataTable({
            "order":[0, "desc"]
        });

    });

</script>
