<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Airtime Orders
            <small>All airtime purchase orders done by users</small>
        </h1>
        <?php echo $breadcrumb; ?>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-xs-12" id="msg">
                <?php echo $this->session->userdata('msg'); ?>
            </div>
        </div>
        <div class="row">
            <div class="col-xs-12">
                <div class="box no-border">
                    <div class="box-header with-border">
                        <div class="col-md-5 col-sm-12 col-xs-12 pull-right">
                            <?php echo form_open(base_url()."airtime/airtime-orders"); ?>
                            <div class="input-group">
                                <div class="input-group-addon">
                                    <i class="fa fa-calendar"></i>
                                </div>
                                <input type="date" class="form-control pull-right" name="daterange">
                                <div class="input-group-btn">
                                    <button class="btn btn-primary" type="submit">View</button>
                                </div>
                            </div>
                            <!-- /.input group -->
                            <?php echo form_close(); ?>
                        </div>
                    </div>
                    <!-- /.box-header -->
                    <div class="box-body table-responsive">
                        <table id="transTable" class="table table-bordered table-striped">
                            <thead>
                            <tr>
                                <th class="text-center">Status</th>
                                <th class="text-center">Reference</th>
                                <th class="text-center">Business</th>
                                <th class="text-center">Username</th>
                                <th class="text-center">Network</th>
                                <th class="text-center">Recipient</th>
                                <th class="text-center">Amount (Paid)</th>
                                <th class="text-center">Date</th>
                                <th class="text-center"></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php
                            $s = $this->Db_model->selectGroup("*", "airtime_purchase", "WHERE `created_date` LIKE '$date%' ORDER BY id DESC, status");
                            if ($s->num_rows() > 0) {
                                foreach ($s->result_array() as $row) {
                                    $network = $this->Util_model->get_info("networks", "network", "WHERE id=$row[network]");
                                    $amount = number_format($row['amount']);
                                    $amount_paid = number_format($row['amount_paid']);
                                    $username = $this->Util_model->get_user_info($row['uid'], "username", "profile");
                                    $business = $this->Util_model->get_info("merchant_main", "name", "WHERE mid=$row[mid]");

                                    if ($row['status'] == 0) {
                                        $status = "<span class='text-red'>Pending</span>";
                                    } else if ($row['status'] == 1) {
                                        $status = "<span class='text-green'>Completed</span>";
                                    } else if ($row['status'] == 2) {
                                        $status = "<span class='text-gray'>Cancelled</span>";
                                    }
                                    echo "
                            <tr class='text-center'>
                                <td>$status</td>
                                <td>$row[reference]</td>
                                <td><a href='".base_url()."business/view/$row[mid]'>$business</a></td>
                                <td>$username</td>
                                <td>$network</td>
                                <td>$row[recipient]</td>
                                <td>₦$amount (₦$amount_paid)</td>
                                <td>$row[created_date]</td>
                                <td>
                                    <button class='btn btn-success btn-xs' type='button' title='Success' data-toggle='tooltip' onclick='update_status(\"airtime_purchase\",1,\"$row[id]\"); $(this).remove();'><i class='fa fa-check'></i> Complete</button>
                                    <a href='".base_url()."admin/airtime-cancel/$row[reference]' class='btn btn-danger btn-xs' data-toggle='tooltip'> Cancel</a>
                                </td>
                            </tr>\n
                        ";


                                }
                            }
                            ?>
                            </tbody>
                        </table>
                    </div>
                    <!-- /.box-body -->
                    <div class="box-footer">
                        <small class="text-warning">NB: Slide table left on <i>mobile</i></small>
                    </div>
                    <!--/.box-footer-->
                </div>
                <!-- /.box -->
            </div>
        </div>
        <!--/.row-->
    </section>
</div>

<!-- DataTables -->
<script src="<?php echo base_url(); ?>assets/plugins/datatables/jquery.dataTables.min.js"></script>
<script src="<?php echo base_url(); ?>assets/plugins/datatables/dataTables.bootstrap.min.js"></script>
<!-- date-range-picker -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.11.2/moment.min.js"></script>
<script src="<?php echo base_url(); ?>assets/plugins/daterangepicker/daterangepicker.js"></script>

<script>
    $(function () {

        $('#transTable').DataTable({
            "order":[0, "desc"]
        });

    });

    function update_withdraw_status (ref, status) {
        $.post('<?php echo base_url(); ?>admin/withdraw_status', {"reference":ref, "status":status}, function () {
            msg("<i class='fa fa-check-circle'></i> Status updated successfully", "alert-success", 1, _('msg'));
            reloadPage(200);
        });
    }
</script>
