<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Airtime Settings
            <small>Manage your airtime discounts</small>
        </h1>
        <?php echo $breadcrumb; ?>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-xs-12" id="msg">
                <?php echo $this->session->userdata('msg'); ?>
            </div>
        </div>
        <div class="row">
            <div class="col-xs-12">
                <div class="box no-border">
                    <div class="box-header">
                        <h3 class="box-title">Settings</h3>
                    </div>
                    <!-- /.box-header -->
                    <div class="box-body">
                        <div class="table-responsive">
                            <table class="table table-condensed table-striped">
                                <?php echo form_open(base_url()."admin/airtime_settings_submit"); ?>
                                <thead>
                                <tr>
                                    <th>Network</th>
                                    <th>Discount</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php
                                $s = $this->Db_model->selectGroup("*", "airtime_discount");
                                if ($s->num_rows() == 0) {
                                    echo "
                                    <tr>
                                        <td colspan='5'>No airtime discounts found</td>
                                    </tr>
                                    ";
                                } else {
                                    foreach ($s->result_array() as $row) {
                                        $network = $this->Util_model->get_info("networks", "network", "WHERE id=$row[network_id]");
                                        echo "
                                            <input type='hidden' name='net_id[]' value='$row[id]'>
                                            <tr>
                                                <td>
                                                    $network
                                                </td>
                                                <td>
                                                    <input class='form-control' type='number' step='0.01' name='discount[]' value='$row[discount]'>
                                                </td>
                                            </tr>
                                        ";
                                    }
                                }
                                ?>
                                </tbody>
                                <tfoot>
                                <tr>
                                    <td colspan='5' align='center'>
                                        <button class='btn btn-success' type='submit'>Update Airtime Discounts</button>
                                    </td>
                                </tr>
                                </tfoot>
                                <?php echo form_close(); ?>
                            </table>
                        </div>
                    </div>
                    <!-- /.box-body -->
                    <div class="box-footer">
                        <small class="text-warning">NB: Slide table left on <i>mobile</i></small>
                    </div>
                    <!--/.box-footer-->
                </div>
                <!-- /.box -->
            </div>
        </div>
        <!--/.row-->
    </section>
</div>

<!-- DataTables -->
<script src="<?php echo base_url(); ?>assets/plugins/datatables/jquery.dataTables.min.js"></script>
<script src="<?php echo base_url(); ?>assets/plugins/datatables/dataTables.bootstrap.min.js"></script>

<script>
    $(function () {

        $('#transTable').DataTable({
            "order":[0, "desc"]
        });

    });

</script>
