<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Alerts
            <small>All alert messages in the system</small>
        </h1>
        <?php echo $breadcrumb; ?>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-xs-12" id="msg">
                <?php echo $this->session->userdata('msg'); ?>
            </div>
        </div>
        <div class="row">
            <div class="col-xs-12">
                <div class="box no-border">
                    <div class="box-header">
                        Add New Alert
                    </div>
                    <div class="box-body">
                        <div class="col-lg-7 col-md-7 col-sm-12 col-xs-12">
                            <?php echo form_open(base_url()."admin/alerts-new"); ?>
                                <textarea id="summernote" name="message" placeholder="Write the alert here"></textarea>
                                <button class="btn btn-primary" type="submit">Submit</button>
                            <?php echo form_close(); ?>
                        </div>
                    </div>
                </div>

                <div class="box no-border">
                    <div class="box-header">
                        <h3 class="box-title">Alerts</h3>
                    </div>
                    <!-- /.box-header -->
                    <div class="box-body table-responsive">
                        <table class="table table-condensed table-striped">
                            <thead>
                            <tr>
                                <th>Message</th>
                                <th>Status</th>
                                <th></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php
                            $s = $this->Db_model->selectGroup("*", "alerts", "ORDER BY status DESC, id DESC");
                            if ($s->num_rows() == 0) {
                                echo "
                                                <tr>
                                                    <td colspan='5'>No alert found</td>
                                                </tr>
                                                ";
                            } else {
                                foreach ($s->result_array() as $row) {
                                    if ($row['status'] == 0) {
                                        $status = "Inactive";
                                    } else if ($row['status'] == 1) {
                                        $status = "Active";
                                    } else {
                                        $status = "Popup";
                                    }
                                    echo "
                                        <tr>
                                            <td>
                                                ".htmlspecialchars_decode($row['content'])."
                                            </td>
                                            <td>
                                                $status
                                            </td>
                                            <td align='right'>
                                                <div class='btn-group btn-group-xs'>
                                                    <a href='".base_url()."admin/alerts-status/$row[id]/0' class='btn btn-danger'>Deactivate</a>
                                                    <a href='".base_url()."admin/alerts-status/$row[id]/1' class='btn btn-danger'>Activate</a>
                                                </div>
                                                <a href='".base_url()."admin/alerts-status/$row[id]/2' class='btn btn-primary btn-xs'>Popup</a>
                                            </td>
                                        </tr>
                                    ";
                                }
                            }
                            ?>
                            </tbody>
                            <?php echo form_close(); ?>
                        </table>
                    </div>
                    <!-- /.box-body -->
                    <div class="box-footer">
                        <small class="text-warning">NB: Slide table left on <i>mobile</i></small>
                    </div>
                    <!--/.box-footer-->
                </div>
                <!-- /.box -->
            </div>
        </div>
        <!--/.row-->
    </section>
</div>

<script src="https://cdn.jsdelivr.net/npm/summernote@0.8.16/dist/summernote.min.js"></script>
<script>
    $(document).ready(function() {
        $('#summernote').summernote();
    });
</script>