<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Cable Tv Orders
            <small>Manage your cable tv subscriptions</small>
        </h1>
        <?php echo $breadcrumb; ?>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-xs-12" id="msg">
                <?php echo $this->session->userdata('msg'); ?>
            </div>
        </div>
        <div class="row">
            <div class="col-xs-12">
                <div class="box no-border">
                    <div class="box-header with-border">
                        <div class="col-md-5 col-sm-12 col-xs-12 pull-right">
                            <?php echo form_open(base_url()."cable/cable-orders"); ?>
                            <div class="input-group">
                                <div class="input-group-addon">
                                    <i class="fa fa-calendar"></i>
                                </div>
                                <input type="date" class="form-control pull-right" name="daterange">
                                <div class="input-group-btn">
                                    <button class="btn btn-primary" type="submit">View</button>
                                </div>
                            </div>
                            <!-- /.input group -->
                            <?php echo form_close(); ?>
                        </div>
                    </div>
                    <!-- /.box-header -->
                    <div class="box-body table-responsive">
                        <table id="transTable" class="table table-bordered table-striped">
                            <thead>
                            <tr>
                                <th class="text-center">Status</th>
                                <th class="text-center">Reference</th>
                                <th class="text-center">Business</th>
                                <th class="text-center">Username</th>
                                <th class="text-center">Cable</th>
                                <th class="text-center">Package</th>
                                <th class="text-center">Smart card / IUC</th>
                                <th class="text-center">Amount (Paid)</th>
                                <th class="text-center">Date</th>
                                <th class="text-center"></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php
                            $s = $this->Db_model->selectGroup("*", "cable_purchase", "WHERE `created_date` LIKE '$date%' ORDER BY id DESC, status");
                            if ($s->num_rows() > 0) {
                                foreach ($s->result_array() as $row) {
                                    $cable = $this->Util_model->get_info("cable", "name", "WHERE id=$row[cable]");
                                    $package = $this->Util_model->get_info("cable_package", "name", "WHERE package_code='$row[package]'");
                                    $amount = number_format($row['package_amount']);
                                    $amount_paid = number_format($row['amount_paid']);
                                    $username = ($row['uid'] == 1) ? "Guest" : $this->Util_model->get_user_info($row['uid'], "username", "profile");
                                    $business = $this->Util_model->get_info("merchant_main", "name", "WHERE mid=$row[mid]");

                                    if ($row['status'] == 0) {
                                        $status = "<span class='text-red'>Pending</span>";
                                    } else if ($row['status'] == 1) {
                                        $status = "<span class='text-green'>Completed</span>";
                                    } else if ($row['status'] == 2) {
                                        $status = "<span class='text-gray'>Cancelled</span>";
                                    }
                                    echo "
                            <tr class='text-center'>
                                <td>$status</td>
                                <td>$row[reference]</td>
                                <td><a href='".base_url()."business/view/$row[mid]'>$business</a></td>
                                <td>$username</td>
                                <td>$cable</td>
                                <td>$package</td>
                                <td>$row[smart_card_num]</td>
                                <td>₦$amount (₦$amount_paid)</td>
                                <td>$row[created_date]</td>
                                <td>
                                    <button class='btn btn-success btn-xs' type='button' title='Success' data-toggle='tooltip' onclick='update_status(\"cable_purchase\",1,\"$row[id]\"); $(this).remove();'><i class='fa fa-check'></i> Complete</button>
                                    <a href='".base_url()."admin/cable-cancel/$row[reference]' class='btn btn-danger btn-xs' data-toggle='tooltip'> Cancel</a>
                                </td>
                            </tr>\n
                        ";


                                }
                            }
                            ?>
                            </tbody>
                        </table>
                    </div>
                    <!-- /.box-body -->
                    <div class="box-footer">
                        <small class="text-warning">NB: Slide table left on <i>mobile</i></small>
                    </div>
                    <!--/.box-footer-->
                </div>
                <!-- /.box -->
            </div>
        </div>
        <!--/.row-->
    </section>
</div>

<!-- DataTables -->
<script src="<?php echo base_url(); ?>assets/plugins/datatables/jquery.dataTables.min.js"></script>
<script src="<?php echo base_url(); ?>assets/plugins/datatables/dataTables.bootstrap.min.js"></script>

<script>
    $(function () {

        $('#transTable').DataTable({
            "order":[0, "desc"]
        });

    });

</script>
