<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Cable Tv Settings
            <small>Manage all cable tv subscription packages</small>
        </h1>
        <?php echo $breadcrumb; ?>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-xs-12" id="msg">
                <?php echo $this->session->userdata('msg'); ?>
            </div>
        </div>
        <div class="row">
            <div class="col-xs-12">
                <div class="box no-border">
                    <div class="box-header">
                        <h3 class="box-title">Settings</h3>
                    </div>
                    <!-- /.box-header -->
                    <div class="box-body">
                        <div class="nav-tabs-custom">
                            <ul class="nav nav-tabs">
                                <li class="active"><a href="#dstv" data-toggle="tab">DSTv</a></li>
                                <li><a href="#gotv" data-toggle="tab">GOTv</a></li>
                                <li><a href="#startimes" data-toggle="tab">StarTimes</a></li>
                                <li><a href="#new" data-toggle="tab">ADD NEW</a></li>
                            </ul>
                            <div class="tab-content">
                                <div class="tab-pane active" id="dstv">
                                    <h4 class="bottom-2x">DSTV PACKAGES</h4>
                                    <div class="table-responsive">
                                        <table class="table table-condensed table-striped">
                                            <?php echo form_open(base_url()."admin/cable_settings_submit"); ?>
                                            <thead>
                                            <tr>
                                                <th>Code</th>
                                                <th>Name</th>
                                                <th>Price</th>
                                                <th>Status</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <?php
                                            $s = $this->Db_model->selectGroup("*", "cable_package", "WHERE cable=1");
                                            if ($s->num_rows() == 0) {
                                                echo "
                                                <tr>
                                                    <td colspan='4'>No package found, add new package</td>
                                                </tr>
                                                ";
                                            } else {
                                                foreach ($s->result_array() as $row) {
                                                    if ($row['status'] == 0) {
                                                        $status = "
                                                            <option value='0' selected>Inactive</option>
                                                            <option value='1'>Active</option>
                                                        ";
                                                    } else {
                                                        $status = "
                                                            <option value='0'>Inactive</option>
                                                            <option value='1' selected>Active</option>
                                                        ";
                                                    }
                                                    echo "
                                                        <input type='hidden' name='id[]' value='$row[id]'>
                                                        <tr>
                                                            <td>
                                                                <input class='form-control' type='text' name='code[]' value='$row[package_code]'>
                                                            </td>
                                                            <td>
                                                                <input class='form-control' type='text' name='name[]' value='$row[name]' style='width: 200px'>
                                                            </td>
                                                            <td>
                                                                <input class='form-control' type='number' step='0.01' name='amount[]' value='$row[amount]'>
                                                            </td>
                                                            <td>
                                                                <select class='form-control' name='status[]'>
                                                                    $status
                                                                </select>
                                                            </td>
                                                        </tr>
                                                    ";
                                                }
                                            }
                                            ?>
                                            </tbody>
                                            <tfoot>
                                                <tr>
                                                    <td colspan='4' align='center'>
                                                        <button class='btn btn-success' type='submit'>Update Package</button>
                                                    </td>
                                                </tr>
                                            </tfoot>
                                            <?php echo form_close(); ?>
                                        </table>
                                    </div>
                                </div>
                                <!-- /.tab-pane -->
                                <div class="tab-pane" id="gotv">
                                    <h4 class="bottom-2x">GOTV PACKAGES</h4>
                                    <div class="table-responsive">
                                        <table class="table table-condensed table-striped">
                                            <?php echo form_open(base_url()."admin/cable_settings_submit"); ?>
                                            <thead>
                                            <tr>
                                                <th>Code</th>
                                                <th>Name</th>
                                                <th>Price</th>
                                                <th>Status</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <?php
                                            $s = $this->Db_model->selectGroup("*", "cable_package", "WHERE cable=2");
                                            if ($s->num_rows() == 0) {
                                                echo "
                                                <tr>
                                                    <td colspan='4'>No package found, add new package</td>
                                                </tr>
                                                ";
                                            } else {
                                                foreach ($s->result_array() as $row) {
                                                    if ($row['status'] == 0) {
                                                        $status = "
                                                            <option value='0' selected>Inactive</option>
                                                            <option value='1'>Active</option>
                                                        ";
                                                    } else {
                                                        $status = "
                                                            <option value='0'>Inactive</option>
                                                            <option value='1' selected>Active</option>
                                                        ";
                                                    }
                                                    echo "
                                                        <input type='hidden' name='id[]' value='$row[id]'>
                                                        <tr>
                                                            <td>
                                                                <input class='form-control' type='text' name='code[]' value='$row[package_code]'>
                                                            </td>
                                                            <td>
                                                                <input class='form-control' type='text' name='name[]' value='$row[name]' style='width: 200px'>
                                                            </td>
                                                            <td>
                                                                <input class='form-control' type='number' step='0.01' name='amount[]' value='$row[amount]'>
                                                            </td>
                                                            <td>
                                                                <select class='form-control' name='status[]'>
                                                                    $status
                                                                </select>
                                                            </td>
                                                        </tr>
                                                    ";
                                                }
                                            }
                                            ?>
                                            </tbody>
                                            <tfoot>
                                            <tr>
                                                <td colspan='4' align='center'>
                                                    <button class='btn btn-success' type='submit'>Update Package</button>
                                                </td>
                                            </tr>
                                            </tfoot>
                                            <?php echo form_close(); ?>
                                        </table>
                                    </div>
                                </div>
                                <!-- /.tab-pane -->
                                <div class="tab-pane" id="startimes">
                                    <h4 class="bottom-2x">STARTIMES PACKAGES</h4>
                                    <div class="table-responsive">
                                        <table class="table table-condensed table-striped">
                                            <?php echo form_open(base_url()."admin/cable_settings_submit"); ?>
                                            <thead>
                                            <tr>
                                                <th>Code</th>
                                                <th>Name</th>
                                                <th>Price</th>
                                                <th>Status</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <?php
                                            $s = $this->Db_model->selectGroup("*", "cable_package", "WHERE cable=3");
                                            if ($s->num_rows() == 0) {
                                                echo "
                                                <tr>
                                                    <td colspan='4'>No package found, add new package</td>
                                                </tr>
                                                ";
                                            } else {
                                                foreach ($s->result_array() as $row) {
                                                    if ($row['status'] == 0) {
                                                        $status = "
                                                            <option value='0' selected>Inactive</option>
                                                            <option value='1'>Active</option>
                                                        ";
                                                    } else {
                                                        $status = "
                                                            <option value='0'>Inactive</option>
                                                            <option value='1' selected>Active</option>
                                                        ";
                                                    }
                                                    echo "
                                                        <input type='hidden' name='id[]' value='$row[id]'>
                                                        <tr>
                                                            <td>
                                                                <input class='form-control' type='text' name='code[]' value='$row[package_code]'>
                                                            </td>
                                                            <td>
                                                                <input class='form-control' type='text' name='name[]' value='$row[name]' style='width: 200px'>
                                                            </td>
                                                            <td>
                                                                <input class='form-control' type='number' step='0.01' name='amount[]' value='$row[amount]'>
                                                            </td>
                                                            <td>
                                                                <select class='form-control' name='status[]'>
                                                                    $status
                                                                </select>
                                                            </td>
                                                        </tr>
                                                    ";
                                                }
                                            }
                                            ?>
                                            </tbody>
                                            <tfoot>
                                            <tr>
                                                <td colspan='4' align='center'>
                                                    <button class='btn btn-success' type='submit'>Update Package</button>
                                                </td>
                                            </tr>
                                            </tfoot>
                                            <?php echo form_close(); ?>
                                        </table>
                                    </div>
                                </div>
                                <!-- /.tab-pane -->
                                <div class="tab-pane" id="new">
                                    <div class="row">
                                        <?php echo form_open(base_url()."admin/cable_settings_new"); ?>
                                        <div class="col-lg-2 col-md-2 col-sm-6 col-xs-12">
                                            <div class="form-group">
                                                <label>Company <span class="required">*</span> </label>
                                                <select class="form-control" name="cable" required>
                                                    <?php echo $this->Util_model->list_from_table("cable", "id", "name"); ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-lg-2 col-md-2 col-sm-6 col-xs-12">
                                            <div class="form-group">
                                                <label>Package Code <span class="required">*</span> </label>
                                                <input class="form-control" type="text" name="code" required>
                                            </div>
                                        </div>
                                        <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
                                            <div class="form-group">
                                                <label>Package Name <span class="required">*</span> </label>
                                                <input class="form-control" type="text" name="name" required>
                                            </div>
                                        </div>
                                        <div class="col-lg-2 col-md-2 col-sm-6 col-xs-12">
                                            <div class="form-group">
                                                <label>Amount <span class="required">*</span></label>
                                                <input class="form-control" type="number" name="amount" required>
                                            </div>
                                        </div>
                                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                            <div class="form-group">
                                                <label>&nbsp;</label>
                                                <button class="btn btn-success btn-block btn-flat" type="submit">Submit</button>
                                            </div>
                                        </div>
                                        <?php echo form_close(); ?>
                                    </div>
                                </div>
                                <!-- /.tab-pane -->
                            </div>
                            <!-- /.tab-content -->
                        </div>
                        <!-- nav-tabs-custom -->
                    </div>
                    <!-- /.box-body -->
                    <div class="box-footer">
                        <small class="text-warning">NB: Slide table left on <i>mobile</i></small>
                    </div>
                    <!--/.box-footer-->
                </div>
                <!-- /.box -->
            </div>
        </div>
        <!--/.row-->
    </section>
</div>

<!-- DataTables -->
<script src="<?php echo base_url(); ?>assets/plugins/datatables/jquery.dataTables.min.js"></script>
<script src="<?php echo base_url(); ?>assets/plugins/datatables/dataTables.bootstrap.min.js"></script>

<script>
    $(function () {

        $('#transTable').DataTable({
            "order":[0, "desc"]
        });

    });

</script>
