<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Data
            <small>manage data subscription</small>
        </h1>
        <?php echo $breadcrumb; ?>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-xs-12" id="msg">
                <?php echo $this->session->userdata('msg'); ?>
            </div>
        </div>
        <div class="row">
            <div class="col-xs-12">
                <div class="box no-border">
                    <div class="box-body">
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 top-pad-3x bottom-pad-3x bottom-3x td_underline">
                            <?php echo form_open(base_url()."data"); ?>
                            <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                <div class="form-group">
                                    <label>Network <span class="required">*</span></label>
                                    <select class="form-control" name="network" id="network" onchange="_('bundle').html('<option>Loading bundle...</option>'); processAjax('<?php echo base_url(); ?>data/list-bundles/'+$(this).val(), '', _('bundle'))">
                                        <option value="">Select network</option>
                                        <?php echo $this->Util_model->list_from_table("networks", "id", "network"); ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                <div class="form-group">
                                    <label>Bundle <span class="required">*</span></label>
                                    <select class="form-control" name="bundle" id="bundle" onchange="$.post('<?php echo base_url(); ?>data/get-amount/'+$(this).val(), '', function (data) { _('amt-fiat').val(data['fiat']); _('amt-coin').text(data['coin']);}, 'json')">
                                        <option value="">Select network first</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12 bottom-1x">
                                <label>Amount <span class="required">*</span></label>
                                <span class="no-display" id="buy-price"><?php echo $this->Util_model->get_option("coin_price"); ?></span>
                                <div class="input-group">
                                    <span class="input-group-addon">₦</span>
                                    <input class="form-control text-bold text-center" disabled name="amount" required="required" id="amt-fiat" placeholder="Price is based on the bundle" type="number" step="0.01" value="<?php echo set_value('amount'); ?>">
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                <div class="form-group">
                                    <label>Recipient <span class="required">*</span></label>
                                    <input class="form-control" name="recipient" type="tel" placeholder="eg. 08120203636" required="required" value="<?php echo set_value('recipient'); ?>">
                                </div>
                            </div>
                            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 no-padding">
                                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                    <div class="form-group">
                                        <label>Password <span class="required">*</span></label>
                                        <input class="form-control" name="password" type="password" placeholder="Account password" required="required">
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                <button class="btn btn-success pull-right" type="submit" name="buyAirtime">Buy Data</button>
                            </div>
                            <?php echo form_close(); ?>
                        </div>

                        <div class="col-xs-12">
                            <div class="alert alert-info">
                                <h4 class="text-bold">Check data balance</h4>
                                <span class="label label-primary"><b>MTN (SME) >>> *461*4#</b></span>&nbsp;
                                <span class="label label-primary"><b>MTN (GIFTING) >>> *131*4#</b></span>&nbsp;
                                <span class="label label-primary"><b>GLO >>> *127*0#</b></span>&nbsp;
                                <span class="label label-primary"><b>9Mobile >>> *228#</b></span>&nbsp;
                                <span class="label label-primary"><b>Airtel >>> *140#</b></span>&nbsp;
                            </div>

                        </div>

                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 table-responsive">
                            <table id="dataTable" class="table table-bordered table-striped">
                                <thead>
                                <tr>
                                    <th class="text-center">Network</th>
                                    <th class="text-center">Bundle</th>
                                    <th class="text-center">Recipient</th>
                                    <th class="text-center">Amount</th>
                                    <th class="text-center">Discount</th>
                                    <th class="text-center">Date</th>
                                    <th class="text-center">Status</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php
                                $s = $this->Db_model->selectGroup("*", "data_purchase", "WHERE uid=".$this->session->userdata(UID));
                                if ($s->num_rows() > 0) {
                                    foreach ($s->result_array() as $row) {
                                        $network = $this->Util_model->get_info("networks", "network", "WHERE id=$row[network]");
                                        $bundle = $this->Util_model->get_info("data_bundle", "bundle", "WHERE id=$row[bundle]");
                                        if ($row['status'] == 0) {
                                            $status = "<span class='label bg-aqua'>Processing <i class='fa fa-spinner fa-spin'></i> </span>";
                                        } else if ($row['status'] == 1) {
                                            $status = "<span class='label bg-green'>Delivered</span>";
                                        } else {
                                            $status = "<span class='label bg-red'>Cancelled</span>";
                                        }

                                        echo "
                                <tr class='text-center'>
                                    <td>$network</td>
                                    <td>$bundle</td>
                                    <td>0$row[recipient]</td>
                                    <td>₦$row[bundle_amount]</td>
                                    <td>$row[discount]%</td>
                                    <td>$row[status_date]</td>
                                    <td>$status</td>
                                </tr>\n
                            ";
                                    }
                                }
                                ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- DataTables -->
<script src="<?php echo base_url(); ?>assets/plugins/datatables/jquery.dataTables.min.js"></script>
<script src="<?php echo base_url(); ?>assets/plugins/datatables/dataTables.bootstrap.min.js"></script>

<script>
    $(document).ready(function() {
        $('#dataTable').DataTable({
            "paging": true,
            "lengthChange": false,
            "searching": false,
            "ordering": true,
            "info": true,
            "autoWidth": false
        });
    });
</script>

