<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Funding
            <small>Manage fundings by users</small>
        </h1>
        <?php echo $breadcrumb; ?>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-xs-12" id="msg">
                <?php echo $this->session->userdata('msg'); ?>
            </div>
        </div>
        <div class="row">
            <div class="col-xs-12">
                <div class="box no-border">
                    <div class="box-header">
                        <h3 class="box-title">Funding</h3>
                    </div>
                    <!-- /.box-header -->
                    <div class="box-body">
                        <div class="nav-tabs-custom">
                            <ul class="nav nav-tabs">
                                <li class="active"><a href="#merchant" data-toggle="tab">Merchants <span class="badge bg-black"><?php echo count_format($this->Util_model->row_count("merchant_funding", "WHERE status=0")); ?></span></a>  </li>
                                <li><a href="#user" data-toggle="tab">Users <span class="badge bg-black"><?php echo count_format($this->Util_model->row_count("funding", "WHERE status=0")); ?></span></a> </li>
                            </ul>
                            <div class="tab-content table-responsive">
                                <div class="tab-pane active" id="merchant">
                                    <h4 class="bottom-2x">Merchant Funding</h4>
                                    <table class="table table-bordered table-striped transTable">
                                        <thead>
                                        <tr>
                                            <th class="text-center">Status</th>
                                            <th class="text-center">ID</th>
                                            <th class="text-center">Name</th>
                                            <th class="text-center">Method</th>
                                            <th class="text-center">Bank</th>
                                            <th class="text-center">Amount</th>
                                            <th class="text-center">Balance</th>
                                            <th class="text-center">Phone number</th>
                                            <th class="text-center">Narration</th>
                                            <th class="text-center">Date</th>
                                            <th class="text-center"></th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php
                                        $s = $this->Db_model->selectGroup("*", "merchant_funding", "ORDER BY id DESC, status");
                                        if ($s->num_rows() > 0) {
                                            foreach ($s->result_array() as $row) {
                                                $bank = $this->Util_model->get_info("banks", "name", "WHERE code='$row[bank]'");
                                                $amount = number_format($row['amount']);
                                                $name = $this->Util_model->get_info("merchant_main", "name", "WHERE mid=$row[mid]");

                                                if ($row['status'] == 0) {
                                                    $status = "<span class='text-red'>Pending</span>";
                                                } else if ($row['status'] == 1) {
                                                    $status = "<span class='text-green'>Completed</span>";
                                                } else if ($row['status'] == 2) {
                                                    $status = "<span class='text-gray'>Cancelled</span>";
                                                }
                                                echo "
                                                <tr class='text-center'>
                                                    <td>$status</td>
                                                    <td>$row[mid]</td>
                                                    <td>$name</td>
                                                    <td>$row[method]</td>
                                                    <td>$bank</td>
                                                    <td>₦$amount</td>
                                                    <td>".$this->Main_model->get_merchant_balance($row['mid'])."</td>
                                                    <td>$row[phone]</td>
                                                    <td>$row[reference]</td>
                                                    <td>$row[date]</td>
                                                    <td>
                                                        <a href='".base_url()."wallet/merchant-funding/$row[id]' class='btn btn-success btn-xs' data-toggle='tooltip'> Confirm</a>
                                                        <a href='".base_url()."wallet/merchant-funding-cancel/$row[id]' class='btn btn-danger btn-xs' data-toggle='tooltip'> Cancel</a>
                                                    </td>
                                                </tr>\n
                                                ";
                                                }
                                            }
                                            ?>
                                        </tbody>
                                    </table>
                                </div>
                                <div class="tab-pane" id="user">
                                    <h4 class="bottom-2x">User Funding</h4>
                                    <table class="table table-bordered table-striped transTable">
                                        <thead>
                                        <tr>
                                            <th class="text-center">Status</th>
                                            <th class="text-center">Username</th>
                                            <th class="text-center">Method</th>
                                            <th class="text-center">Bank</th>
                                            <th class="text-center">Amount</th>
                                            <th class="text-center">Balance</th>
                                            <th class="text-center">Phone number</th>
                                            <th class="text-center">Narration</th>
                                            <th class="text-center">Date</th>
                                            <th class="text-center"></th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php
                                        $s = $this->Db_model->selectGroup("*", "funding", "ORDER BY id DESC, status");
                                        if ($s->num_rows() > 0) {
                                            foreach ($s->result_array() as $row) {
                                                $bank = $this->Util_model->get_info("banks", "name", "WHERE code='$row[bank]'");
                                                $amount = number_format($row['amount']);
                                                $username = $this->Util_model->get_info("user_profile", "username", "WHERE uid=$row[uid]");

                                                if ($row['status'] == 0) {
                                                    $status = "<span class='text-red'>Pending</span>";
                                                } else if ($row['status'] == 1) {
                                                    $status = "<span class='text-green'>Completed</span>";
                                                } else if ($row['status'] == 2) {
                                                    $status = "<span class='text-gray'>Cancelled</span>";
                                                }
                                                echo "
                                                <tr class='text-center'>
                                                    <td>$status</td>
                                                    <td>$username</td>
                                                    <td>$row[method]</td>
                                                    <td>$bank</td>
                                                    <td>₦$amount</td>
                                                    <td>".$this->General_model->get_balance($row['uid'])."</td>
                                                    <td>$row[phone]</td>
                                                    <td>$row[reference]</td>
                                                    <td>$row[date]</td>
                                                    <td>
                                                        <a href='".base_url()."wallet/funding/$row[id]' class='btn btn-success btn-xs' data-toggle='tooltip'> Confirm</a>
                                                        <a href='".base_url()."wallet/funding-cancel/$row[id]' class='btn btn-danger btn-xs' data-toggle='tooltip'> Cancel</a>
                                                    </td>
                                                </tr>\n
                                                ";
                                            }
                                        }
                                        ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- /.box-body -->
                    <div class="box-footer">
                        <small class="text-warning">NB: Slide table left on <i>mobile</i></small>
                    </div>
                    <!--/.box-footer-->
                </div>
                <!-- /.box -->
            </div>
        </div>
        <!--/.row-->
    </section>
</div>

<!-- DataTables -->
<script src="<?php echo base_url(); ?>assets/plugins/datatables/jquery.dataTables.min.js"></script>
<script src="<?php echo base_url(); ?>assets/plugins/datatables/dataTables.bootstrap.min.js"></script>

<script>
    $(function () {

        $('.transTable').DataTable({
            "order":[0, "desc"]
        });

    });

</script>
