<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Store
            <small>Manage the store items</small>
        </h1>
        <?php echo $breadcrumb; ?>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-xs-12" id="msg">
                <?php echo $this->session->userdata('msg'); ?>
            </div>
        </div>
        <div class="row">
            <div class="col-xs-12">
                <div class="box no-border">
                    <div class="box-body">
                        <div class="nav-tabs-custom">
                            <ul class="nav nav-tabs">
                                <li class="active"><a href="#items" data-toggle="tab">ITEMS</a></li>
                                <li><a href="#categories" data-toggle="tab">ADD CATEGORIES</a></li>
                                <li><a href="#new" data-toggle="tab">ADD ITEMS</a></li>
                            </ul>
                            <div class="tab-content">
                                <div class="tab-pane active" id="items">
                                    <h4 class="bottom-2x">ITEMS</h4>
                                    <div class="table-responsive">
                                        <table class="table table-condensed table-striped">
                                            <thead>
                                            <tr>
                                                <th>Thumbnail</th>
                                                <th>Item</th>
                                                <th>Category</th>
                                                <th>Price</th>
                                                <th>Condition</th>
                                                <th>Status</th>
                                                <th></th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <?php
                                            $s = $this->Db_model->selectGroup("*", "store_products", "WHERE status=1");
                                            if ($s->num_rows() == 0) {
                                                echo "
                                                <tr>
                                                    <td colspan='7'>No product found</td>
                                                </tr>
                                                ";
                                            } else {
                                                foreach ($s->result_array() as $row) {
                                                    if ($row['status'] == 0) {
                                                        $status = "Inactive";
                                                    } else {
                                                        $status = "Active";
                                                    }
                                                    $category = $this->Util_model->get_info("store_categories", "name", "WHERE id=$row[cat_id]");
                                                    echo "
                                                        <tr>
                                                            <td>
                                                                <img src='".base_url()."$row[picture]' width='75' height='75' alt='$row[name]'>
                                                            </td>
                                                            <td>
                                                                $row[name]
                                                            </td>
                                                            <td>
                                                                $category
                                                            </td>
                                                            <td>
                                                                ₦".number_format($row['selling_price'])."
                                                            </td>
                                                            <td>
                                                                $row[condition]
                                                            </td>
                                                            <td>
                                                                $status
                                                            </td>
                                                            <td>
                                                                <a href='".base_url()."admin/store_item_delete/$row[id]' class='btn btn-danger btn-sm'>Delete</a>
                                                            </td>
                                                        </tr>
                                                    ";
                                                }
                                            }
                                            ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                <!-- /.tab-pane -->
                                <div class="tab-pane" id="categories">
                                    <h4 class="bottom-2x">CATEGORIES</h4>
                                    <?php echo form_open(base_url()."admin/store_add_category"); ?>
                                    <div class="well">
                                        <label>Add New Category</label>
                                        <div class="input-group top-1x bottom-2x">
                                            <input class="form-control" type="text" name="category">
                                            <div class="input-group-btn">
                                                <button class="btn btn-primary" type="submit">Add Category</button>
                                            </div>
                                        </div>
                                    </div>
                                    <?php echo form_close(); ?>
                                    <hr>
                                    <ul class="list-group">
                                        <?php
                                        $s = $this->Db_model->selectGroup("*", "store_categories", "WHERE status=1");
                                        if ($s->num_rows() == 0) {
                                            echo "
                                                <li class='list-group-item'>
                                                    No category found
                                                </li>
                                            ";
                                        } else {
                                            foreach ($s->result_array() as $row) {
                                                echo "
                                                <li class='list-group-item'>
                                                    $row[name] <a style='float: right; width: auto;' class='text-red' href='".base_url()."admin/store_delete_category/$row[id]'>Delete</a>
                                                </li>
                                            ";
                                            }
                                        }
                                        ?>
                                    </ul>
                                </div>
                                <!-- /.tab-pane -->
                                <div class="tab-pane" id="new">
                                    <h4 class="bottom-2x">ADD NEW ITEM</h4>
                                    <?php echo form_open_multipart(base_url()."admin/store_add_item");?>
                                    <div class="row">
                                        <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                            <div class="form-group">
                                                <label>Name</label>
                                                <input class="form-control" type="text" name="name">
                                            </div>
                                        </div>
                                        <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                            <div class="form-group">
                                                <label>Category</label>
                                                <select class="form-control" name="category">
                                                    <?php echo $this->Util_model->list_from_table("store_categories", "id", "name", "WHERE status=1"); ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                            <div class="form-group">
                                                <label>Price</label>
                                                <input class="form-control" name="price" type="number" step="0.01">
                                            </div>
                                        </div>
                                        <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                            <div class="form-group">
                                                <label>Condition</label>
                                                <select class="form-control" name="condition">
                                                    <option value="Used">Used</option>
                                                    <option value="New">New</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                            <div class="form-group">
                                                <label>Picture</label>
                                                <input type="file" name="image" class="form-control">
                                            </div>
                                        </div>
                                        <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                            <div class="form-group">
                                                <label>&nbsp;</label>
                                                <button class="btn btn-success" type="submit">Add Item</button>
                                            </div>
                                        </div>
                                    </div>
                                    <?php echo form_close(); ?>
                                </div>
                                <!-- /.tab-pane -->
                            </div>
                            <!-- /.tab-content -->
                        </div>
                        <!-- nav-tabs-custom -->
                    </div>
                    <!-- /.box-body -->
                    <div class="box-footer">
                        <small class="text-warning">NB: Slide table left on <i>mobile</i></small>
                    </div>
                    <!--/.box-footer-->
                </div>
                <!-- /.box -->
            </div>
        </div>
        <!--/.row-->
    </section>
</div>

<!-- DataTables -->
<script src="<?php echo base_url(); ?>assets/plugins/datatables/jquery.dataTables.min.js"></script>
<script src="<?php echo base_url(); ?>assets/plugins/datatables/dataTables.bootstrap.min.js"></script>

<script>
    $(function () {

        $('#transTable').DataTable({
            "order":[0, "desc"]
        });

    });

</script>
