<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Transactions
            <small>All the users of the program</small>
        </h1>
        <?php echo $breadcrumb; ?>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-xs-12" id="msg">
                <?php echo $this->session->userdata('msg'); ?>
            </div>
        </div>
        <div class="row">
            <div class="col-xs-12">
                <div class="box no-border">
                    <div class="box-header with-border bottom-1x">
                        <div class="col-md-5 col-sm-12 col-xs-12 pull-right">
                            <?php echo form_open(base_url()."wallet/transactions"); ?>
                            <div class="input-group">
                                <div class="input-group-addon">
                                    <i class="fa fa-calendar"></i>
                                </div>
                                <input type="date" class="form-control pull-right" name="daterange" value="<?php echo $date; ?>">
                                <div class="input-group-btn">
                                    <button class="btn btn-primary" type="submit">View</button>
                                </div>
                            </div>
                            <!-- /.input group -->
                            <?php echo form_close(); ?>
                        </div>
                    </div>
                    <div class="box-body table-responsive">
                        <div class="nav-tabs-custom">
                            <ul class="nav nav-tabs">
                                <li class="active"><a href="#system" data-toggle="tab">System <span class="badge bg-black"><?php echo count_format($system->num_rows()); ?></span></a> </li>
                                <li><a href="#merchant" data-toggle="tab">Merchants <span class="badge bg-black"><?php echo count_format($merchant->num_rows()); ?></span></a>  </li>
                            </ul>
                            <div class="tab-content table-responsive">
                                <div class="tab-pane active" id="system">
                                    <h4 class="bottom-2x">System Transactions</h4>
                                    <table class="table table-bordered table-striped transTable">
                                        <thead>
                                        <tr>
                                            <th class="text-center">Time</th>
                                            <th class="text-center">Business</th>
                                            <th class="text-center">Type</th>
                                            <th class="text-center">Extra</th>
                                            <th class="text-center">Reference</th>
                                            <th class="text-center">From</th>
                                            <th class="text-center">To</th>
                                            <th class="text-center">Amount</th>
                                            <th class="text-center">Status</th>
                                            <th class="text-center">Deposit/Withdraw</th>
                                            <th class="text-center"></th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php
                                        if ($system->num_rows() > 0) {
                                            foreach ($system->result_array() as $row) {
                                                $amount = $row['amount'];
                                                $deposit_withdraw = ($row['debitor'] == 0) ? "Deposit" : "Withdraw";

                                                if ($row['status'] == 0) {
                                                    $status = "<span class='text-red'>Pending</span>";
                                                } else if ($row['status'] == 1) {
                                                    $status = "<span class='text-green'>Success</span>";
                                                } else if ($row['status'] == 2) {
                                                    $status = "<span class='text-gray'>Failed</span>";
                                                }
                                                $biz = $this->Util_model->get_info("merchant_main", "name", "WHERE mid=$row[mid]");
                                                if ($row['debitor'] == 0) {
                                                    $from = "System";
                                                } else if ($row['debitor'] == $row['mid']) {
                                                    $from = $biz;
                                                } else {
                                                    $from = $this->Util_model->get_user_info($row['debitor'],'username','profile');
                                                }
                                                if ($row['creditor'] == 0) {
                                                    $to = "System";
                                                } else if ($row['creditor'] == $row['mid']) {
                                                    $to = $biz;
                                                } else {
                                                    $to = $this->Util_model->get_user_info($row['creditor'],'username','profile');
                                                }
                                                echo "
                                                    <tr class='text-center'>
                                                        <td>$row[date]</td>
                                                        <td>$biz</td>
                                                        <td>$row[type]</td>
                                                        <td>$row[extra]</td>
                                                        <td>$row[ref]</td>
                                                        <td>$from</td>
                                                        <td>$to</td>
                                                        <td>₦".number_format($amount, 2)."</td>
                                                        <td>$status</td>
                                                        <td>$deposit_withdraw</td>
                                                        <td>
                                                            <button class='btn btn-danger btn-xs' type='button' title='Decline' data-toggle='tooltip' onclick='update_status(\"user_wallet\",2,\"$row[id]\")'><i class='fa fa-times'></i></button>
                                                            <button class='btn btn-warning btn-xs' type='button' title='Pending' data-toggle='tooltip' onclick='update_status(\"user_wallet\",0,\"$row[id]\")'><i class='fa fa-spinner'></i></button>
                                                            <button class='btn btn-success btn-xs' type='button' title='Success' data-toggle='tooltip' onclick='update_status(\"user_wallet\",1,\"$row[id]\")'><i class='fa fa-check'></i></button>
                                                        </td>
                                                    </tr>\n
                                                ";
                                            }
                                        }
                                        ?>
                                        </tbody>
                                    </table>
                                </div>
                                <div class="tab-pane" id="merchant">
                                    <h4 class="bottom-2x">Merchant Transactions</h4>
                                    <table class="table table-bordered table-striped transTable">
                                        <thead>
                                        <tr>
                                            <th class="text-center">Time</th>
                                            <th class="text-center">Type</th>
                                            <th class="text-center">Extra</th>
                                            <th class="text-center">Reference</th>
                                            <th class="text-center">From</th>
                                            <th class="text-center">To</th>
                                            <th class="text-center">Amount</th>
                                            <th class="text-center">Status</th>
                                            <th class="text-center">Deposit/Withdraw</th>
                                            <th class="text-center"></th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php
                                        if ($merchant->num_rows() > 0) {
                                            foreach ($merchant->result_array() as $row) {
                                                $amount = $row['amount'];
                                                $deposit_withdraw = ($row['debitor'] == 0) ? "Deposit" : "Withdraw";

                                                if ($row['status'] == 0) {
                                                    $status = "<span class='text-red'>Pending</span>";
                                                } else if ($row['status'] == 1) {
                                                    $status = "<span class='text-green'>Success</span>";
                                                } else if ($row['status'] == 2) {
                                                    $status = "<span class='text-gray'>Failed</span>";
                                                }
                                                if ($row['debitor'] == 0) {
                                                    $from = "System";
                                                } else {
                                                    $from = $this->Util_model->get_info("merchant_main", "name", "WHERE mid=$row[debitor]");
                                                }
                                                if ($row['creditor'] == 0) {
                                                    $to = "System";
                                                } else {
                                                    $to = $this->Util_model->get_info("merchant_main", "name", "WHERE mid=$row[creditor]");
                                                }
                                                echo "
                                                    <tr class='text-center'>
                                                        <td>$row[date]</td>
                                                        <td>$row[type]</td>
                                                        <td>$row[extra]</td>
                                                        <td>$row[ref]</td>
                                                        <td>$from</td>
                                                        <td>$to</td>
                                                        <td>₦".number_format($amount, 2)."</td>
                                                        <td>$status</td>
                                                        <td>$deposit_withdraw</td>
                                                        <td>
                                                            <button class='btn btn-danger btn-xs' type='button' title='Decline' data-toggle='tooltip' onclick='update_status(\"merchant_wallet\",2,\"$row[id]\")'><i class='fa fa-times'></i></button>
                                                            <button class='btn btn-warning btn-xs' type='button' title='Pending' data-toggle='tooltip' onclick='update_status(\"merchant_wallet\",0,\"$row[id]\")'><i class='fa fa-spinner'></i></button>
                                                            <button class='btn btn-success btn-xs' type='button' title='Success' data-toggle='tooltip' onclick='update_status(\"merchant_wallet\",1,\"$row[id]\")'><i class='fa fa-check'></i></button>
                                                        </td>
                                                    </tr>\n
                                                ";
                                            }
                                        }
                                        ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- /.box-body -->
                    <div class="box-footer">
                        <small class="text-warning">NB: Slide table left on <i>mobile</i></small>
                    </div>
                    <!--/.box-footer-->
                </div>
                <!-- /.box -->
            </div>
        </div>
        <!--/.row-->
    </section>
</div>

<!-- DataTables -->
<script src="<?php echo base_url(); ?>assets/plugins/datatables/jquery.dataTables.min.js"></script>
<script src="<?php echo base_url(); ?>assets/plugins/datatables/dataTables.bootstrap.min.js"></script>
<!-- date-picker -->
<script src="<?php echo base_url(); ?>assets/plugins/datepicker/bootstrap-datepicker.js"></script>

<script>
    $(function () {

        $('.transTable').DataTable({
            "order":[0, "desc"]
        });

    });
</script>
