<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Users
            <small>All the users of the program</small>
        </h1>
        <?php echo $breadcrumb; ?>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-xs-12" id="msg">
                <?php echo $this->session->userdata('msg'); ?>
            </div>
        </div>
        <div class="row">
            <div class="col-xs-12">
                <div class="box no-border">
                    <div class="box-header">
                        <h3 class="box-title">All Users</h3>
                    </div>
                    <!-- /.box-header -->
                    <div class="box-body table-responsive">
                        <table id="dataTable" class="table table-striped">
                            <thead>
                                <tr>
                                    <th style="width: 10px">#</th>
                                    <th>Business</th>
                                    <th>Username</th>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Phone number</th>
                                    <th>Referred by</th>
                                    <th>Balance</th>
                                    <th>Registered</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                            <?php
                            $s = $this->Db_model->selectGroup("*", "user_profile", "WHERE role=1");
                            if ($s->num_rows() > 0) {
                                $count = 0;
                                foreach ($s->result_array() as $row) {
                                    $count++;
                                    if ($this->Util_model->get_user_info($row['uid'], 'status', 'main') == 1) {
                                        $btn = "<button class='btn btn-warning btn-xs' title='Block' data-toggle='tooltip' onclick='update_status(\"user_main\",2,\"$row[id]\")'><i class='fa fa-ban'></i> Block</button>";
                                    } else {
                                        $btn = "<button class='btn btn-success btn-xs' title='Unblock' data-toggle='tooltip' onclick='update_status(\"user_main\",1,\"$row[id]\")'><i class='fa fa-ban'></i> Unblock</button>";
                                    }
                                    $business = $this->Util_model->get_info("merchant_main", "name", "WHERE mid=$row[mid]");
                                    echo "
                                    <tr>
                                        <td>$count.</td>
                                        <td><a href='".base_url()."business/view/$row[mid]'>$business</a></td>
                                        <td>$row[username]</td>
                                        <td>".$this->Util_model->get_user_info($row['uid'])."</td>
                                        <td>$row[email]</td>
                                        <td>0$row[phone]</td>
                                        <td>@".$this->Util_model->get_user_info($this->Util_model->get_info("user_referrer", "refID", "WHERE uid=$row[uid]"), "username", "profile")."</td>
                                        <td>".$this->General_model->get_balance($row['uid'])."</td>
                                        <td>".$this->Util_model->get_user_info($row['uid'], "date")."</td>
                                        <td>
                                            $btn
                                        </td>
                                    </tr>
                                    ";
                                }

                            } else {
                                echo "
                                <tr>
                                    <td colspan='8' class='text-danger'>No user found</td>
                                </tr>
                                ";
                            }
                            ?>
                            </tbody>
                        </table>
                    </div>
                    <!-- /.box-body -->
                    <div class="box-footer">
                        <small class="text-warning">NB: Slide table left on <i>mobile</i></small>
                    </div>
                    <!--/.box-footer-->
                </div>
                <!-- /.box -->
            </div>
        </div>
        <!--/.row-->
    </section>
</div>

<!-- DataTables -->
<script src="<?php echo base_url(); ?>assets/plugins/datatables/jquery.dataTables.min.js"></script>
<script src="<?php echo base_url(); ?>assets/plugins/datatables/dataTables.bootstrap.min.js"></script>

<script>
    $(document).ready(function() {
        $('#dataTable').DataTable({
            "paging": true,
            "lengthChange": false,
            "searching": true,
            "ordering": true,
            "info": true,
            "autoWidth": false
        });
    });
</script>
