<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            Withdrawals
            <small>All the users withdrawals</small>
        </h1>
        <?php echo $breadcrumb; ?>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-xs-12" id="msg">
                <?php echo $this->session->userdata('msg'); ?>
            </div>
        </div>
        <div class="row">
            <div class="col-xs-12">
                <div class="box no-border">
                    <div class="box-header">
                        <h3 class="box-title">Withdrawals</h3>
                    </div>
                    <!-- /.box-header -->
                    <div class="box-body table-responsive">
                        <div class="nav-tabs-custom">
                            <ul class="nav nav-tabs">
                                <li class="active"><a href="#merchant" data-toggle="tab">Merchants <span class="badge bg-black"><?php echo count_format($merchant->num_rows()); ?></span></a>  </li>
                                <li><a href="#user" data-toggle="tab">Users <span class="badge bg-black"><?php echo count_format($user->num_rows()); ?></span></a> </li>
                            </ul>
                            <div class="tab-content table-responsive">
                                <div class="tab-pane active" id="merchant">
                                    <h4 class="bottom-2x">Merchants Withdrawals</h4>
                                    <table id="transTable" class="table table-bordered table-striped">
                                        <thead>
                                        <tr>
                                            <th class="text-center">Status</th>
                                            <th class="text-center">Reference</th>
                                            <th class="text-center">Merchant</th>
                                            <th class="text-center">Bank</th>
                                            <th class="text-center">Acct. Name</th>
                                            <th class="text-center">Acct. Number</th>
                                            <th class="text-center">Amount</th>
                                            <th class="text-center">Date</th>
                                            <th class="text-center"></th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php
                                        if ($merchant->num_rows() > 0) {
                                            foreach ($merchant->result_array() as $row) {
                                                $amount = number_format($row['amount']);
                                                $username = $this->Util_model->get_info("merchant_main", "name", "WHERE mid=$row[mid]");
                                                $bank = $this->Util_model->get_info("banks", "name", "WHERE code='$row[bank]'");

                                                if ($row['status'] == 0) {
                                                    $status = "<span class='text-red'>Pending</span>";
                                                } else if ($row['status'] == 1) {
                                                    $status = "<span class='text-green'>Completed</span>";
                                                } else if ($row['status'] == 2) {
                                                    $status = "<span class='text-gray'>Cancelled</span>";
                                                }
                                                echo "
                                        <tr class='text-center'>
                                            <td>$status</td>
                                            <td>$row[reference]</td>
                                            <td>$username</td>
                                            <td>$bank</td>
                                            <td>$row[acct_name]</td>
                                            <td>$row[acct_num]</td>
                                            <td>₦$amount</td>
                                            <td>$row[date]</td>
                                            <td>
                                                <button class='btn btn-danger btn-xs' type='button' title='Decline' data-toggle='tooltip' onclick='update_withdraw_status(\"$row[reference]\", 2)'><i class='fa fa-times'></i></button>
                                                <button class='btn btn-warning btn-xs' type='button' title='Pending' data-toggle='tooltip' onclick='update_withdraw_status(\"$row[reference]\", 0)'><i class='fa fa-spinner'></i></button>
                                                <button class='btn btn-success btn-xs' type='button' title='Success' data-toggle='tooltip' onclick='update_withdraw_status(\"$row[reference]\", 1)'><i class='fa fa-check'></i></button>
                                            </td>
                                        </tr>\n
                                    ";


                                            }
                                        }
                                        ?>
                                        </tbody>
                                    </table>
                                </div>
                                <div class="tab-pane" id="user">
                                    <h4 class="bottom-2x">User Withdrawals</h4>
                                    <table id="transTable" class="table table-bordered table-striped">
                                        <thead>
                                        <tr>
                                            <th class="text-center">Status</th>
                                            <th class="text-center">Reference</th>
                                            <th class="text-center">Username</th>
                                            <th class="text-center">Bank</th>
                                            <th class="text-center">Acct. Name</th>
                                            <th class="text-center">Acct. Number</th>
                                            <th class="text-center">Amount</th>
                                            <th class="text-center">Date</th>
                                            <th class="text-center"></th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php
                                        if ($user->num_rows() > 0) {
                                            foreach ($user->result_array() as $row) {
                                                $amount = number_format($row['amount']);
                                                $amount_received = number_format($row['amount_received']);
                                                $username = $this->Util_model->get_info("user_main", "name", "WHERE mid=$row[mid]");
                                                $bank = $this->Util_model->get_info("banks", "name", "WHERE code='$row[bank]'");

                                                if ($row['status'] == 0) {
                                                    $status = "<span class='text-red'>Pending</span>";
                                                } else if ($row['status'] == 1) {
                                                    $status = "<span class='text-green'>Completed</span>";
                                                } else if ($row['status'] == 2) {
                                                    $status = "<span class='text-gray'>Cancelled</span>";
                                                }
                                                echo "
                                        <tr class='text-center'>
                                            <td>$status</td>
                                            <td>$row[reference]</td>
                                            <td>$username</td>
                                            <td>$bank</td>
                                            <td>$row[acct_name]</td>
                                            <td>$row[acct_num]</td>
                                            <td>₦$amount (₦$amount_received)</td>
                                            <td>$row[date]</td>
                                            <td>
                                                <button class='btn btn-danger btn-xs' type='button' title='Decline' data-toggle='tooltip' onclick='update_withdraw_status(\"$row[reference]\", 2, \"user\")'><i class='fa fa-times'></i></button>
                                                <button class='btn btn-warning btn-xs' type='button' title='Pending' data-toggle='tooltip' onclick='update_withdraw_status(\"$row[reference]\", 0, \"user\")'><i class='fa fa-spinner'></i></button>
                                                <button class='btn btn-success btn-xs' type='button' title='Success' data-toggle='tooltip' onclick='update_withdraw_status(\"$row[reference]\", 1, \"user\")'><i class='fa fa-check'></i></button>
                                            </td>
                                        </tr>\n
                                    ";


                                            }
                                        }
                                        ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- /.box-body -->
                    <div class="box-footer">
                        <small class="text-warning">NB: Slide table left on <i>mobile</i></small>
                    </div>
                    <!--/.box-footer-->
                </div>
                <!-- /.box -->
            </div>
        </div>
        <!--/.row-->
    </section>
</div>

<!-- DataTables -->
<script src="<?php echo base_url(); ?>assets/plugins/datatables/jquery.dataTables.min.js"></script>
<script src="<?php echo base_url(); ?>assets/plugins/datatables/dataTables.bootstrap.min.js"></script>

<script>
    $(function () {

        $('#transTable').DataTable({
            "order":[0, "desc"]
        });

    });

    function update_withdraw_status (ref, status, type) {
        var type = (!type) ? "merchant" : type;
        $.post('<?php echo base_url(); ?>wallet/withdraw_status', {"reference":ref, "status":status, "type":type}, function () {
            msg("<i class='fa fa-check-circle'></i> Status updated successfully", "alert-success", 1, _('msg'));
            reloadPage(200);
        });
    }
</script>
