<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta content="width=device-width, initial-scale=1.0" name="viewport">

    <title><?php echo $this->Util_model->get_option('site_title'); ?> - <?php echo $this->Util_model->get_option('site_tagline'); ?></title>
    <!--  Social tags      -->
    <meta name="keywords" content="loan,investment,data,airtime,buy airtime, buy data, print recharge card,recharge card,online money,make money online,easy money,covid19 support,fast money,easy money,payout,free money,ponzi,peer to peer">
    <meta name="description" content="A financial support platform that boosts the financial strength of its members">
    <!-- Schema.org markup for Google+ -->
    <meta itemprop="name" content="Drip2Drop">
    <meta itemprop="description" content="Drip2Drop is a financial support platform that boosts the financial strenth of its members.">
    <meta itemprop="image" content="<?php echo base_url(); ?>assets/img/thumbnail.png">
    <!-- Twitter Card data -->
    <meta name="twitter:card" content="product">
    <meta name="twitter:site" content="@drip2drop">
    <meta name="twitter:title" content="Drip2Drop">
    <meta name="twitter:description" content="Drip2Drop is a financial support platform that boosts the financial strenth of its members.">
    <meta name="twitter:creator" content="@drip2drop">
    <meta name="twitter:image" content="<?php echo base_url(); ?>assets/img/thumbnail.png">
    <!-- Open Graph data -->
    <meta property="fb:app_id" content="235636677648239">
    <meta property="og:title" content="Drip2Drop" />
    <meta property="og:type" content="A money making platform" />
    <meta property="og:url" content="<?php echo base_url(); ?>" />
    <meta property="og:image" content="<?php echo base_url(); ?>assets/img/thumbnail.png" />
    <meta property="og:description" content="Drip2Drop is a financial support platform that boosts the financial strenth of its members." />
    <meta property="og:site_name" content="Drip2Drop" />
    <!-- Favicons -->
    <link href="<?php echo base_url(); ?>assets/img/favicon.png" rel="icon">
    <link href="<?php echo base_url(); ?>assets/img/apple-touch-icon.png" rel="apple-touch-icon">

    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Raleway:300,300i,400,400i,500,500i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">

    <!-- Vendor CSS Files -->
    <link href="<?php echo base_url(); ?>assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <link href="<?php echo base_url(); ?>assets/vendor/icofont/icofont.min.css" rel="stylesheet">
    <link href="<?php echo base_url(); ?>assets/vendor/boxicons/css/boxicons.min.css" rel="stylesheet">
    <link href="<?php echo base_url(); ?>assets/vendor/venobox/venobox.css" rel="stylesheet">
    <link href="<?php echo base_url(); ?>assets/vendor/owl.carousel/assets/owl.carousel.min.css" rel="stylesheet">
    <link href="<?php echo base_url(); ?>assets/vendor/aos/aos.css" rel="stylesheet">

    <!-- Template Main CSS File -->
    <link href="<?php echo base_url(); ?>assets/dist/css/util.css" rel="stylesheet">
    <link href="<?php echo base_url(); ?>assets/css/style.css" rel="stylesheet">

    <!-- =======================================================
    * Template Name: Flexor - v2.0.0
    * Template URL: https://bootstrapmade.com/flexor-free-multipurpose-bootstrap-template/
    * Author: BootstrapMade.com
    * License: https://bootstrapmade.com/license/
    ======================================================== -->
</head>

<body>

<!-- ======= Top Bar ======= -->
<section id="topbar" class="d-none d-lg-block">
    <div class="container d-flex">
        <div class="contact-info mr-auto">
            <ul>
                <li><i class="icofont-envelope"></i><a href="mailto:contact@drip2drop.com">contact@drip2drop.com</a></li>
                <li><i class="icofont-clock-time icofont-flip-horizontal"></i> Mon-Sat 9am - 6pm, Sun 2pm - 6pm</li>
            </ul>

        </div>
        <div class="cta">
            <?php if ($this->session->has_userdata(UID)) : ?>
                <a href="<?php echo base_url(); ?>home">My Account</a>
            <?php else : ?>
                <a href="<?php echo base_url(); ?>sign-in">Sign In</a>
            <?php endif; ?>
        </div>
    </div>
</section>

<!-- ======= Header ======= -->
<header id="header">
    <div class="container d-flex">

        <div class="logo mr-auto">
            <h1 class="text-light"><a href="<?php echo base_url(); ?>"><span><?php echo $this->Util_model->get_option('site_title'); ?></span></a></h1>
            <!-- Uncomment below if you prefer to use an image logo -->
            <!-- <a href="index.html"><img src="<?php echo base_url(); ?>assets/img/logo.png" alt="" class="img-fluid"></a>-->
        </div>

        <nav class="nav-menu d-none d-lg-block">
            <ul>
                <li class="active"><a href="<?php echo base_url(); ?>">Home</a></li>
                <li><a href="<?php echo base_url(); ?>#about">About</a></li>
                <li><a href="<?php echo base_url(); ?>#services">Services</a></li>
                <li><a href="<?php echo base_url(); ?>#pricing">Packages</a></li>
                <li><a href="<?php echo base_url(); ?>#contact">Contact</a></li>
                <?php if ($this->session->has_userdata(UID)) : ?>
                    <li><a href="<?php echo base_url(); ?>home">My Account</a></li>
                <?php else : ?>
                    <li class="drop-down"><a href="">Sign In / Sign Up</a>
                        <ul>
                            <li><a href="<?php echo base_url(); ?>sign-in">Sign In</a></li>
                            <li><a href="<?php echo base_url(); ?>sign-up">Create Account</a></li>
                        </ul>
                    </li>
                <?php endif; ?>
            </ul>
        </nav><!-- .nav-menu -->

    </div>
</header><!-- End Header -->

<main id="main" style="margin-top: 20px">
    <!-- ======= About Section ======= -->
    <section id="blog" class="about section-bg" style="background-color: #FFFFFF">
        <div class="container">

            <div class="row">
                <div class="col-xl-5 col-lg-6 justify-content-center align-items-stretch" data-aos="fade-right">
                    <img src="<?php echo base_url().$thumb; ?>" style="width: 100%; height: auto;">
                </div>

                <div class="col-xl-7 col-lg-6 icon-boxes d-flex flex-column align-items-stretch justify-content-center py-5 px-lg-5">
                    <h4 data-aos="fade-up">Posted <?php echo new_date_format($date, "Y-m-d H:i:s", "j    M, Y g:i a"); ?></h4>
                    <h3 data-aos="fade-up"><?php echo $title; ?></h3>
                    <p data-aos="fade-up"><?php echo $description; ?></p>
                </div>
            </div>

        </div>
    </section><!-- End About Section -->
</main>

<!-- ======= Footer ======= -->
<footer id="footer">

    <div class="footer-top">
        <div class="container">
            <div class="row">

                <div class="col-lg-3 col-md-6 footer-contact">
                    <h3>Drip2Drop</h3>
                    <p>
                        27 Akerele lane <br>
                        Maryland, Lagos<br>
                        Nigeria <br><br>
                        <strong>Email:</strong> info@drip2drop.com<br>
                    </p>
                </div>

                <div class="col-lg-2 col-md-6 footer-links">
                    <h4>Useful Links</h4>
                    <ul>
                        <li><i class="bx bx-chevron-right"></i> <a href="<?php echo base_url(); ?>">Home</a></li>
                        <li><i class="bx bx-chevron-right"></i> <a href="<?php echo base_url(); ?>#about">About us</a></li>
                        <li><i class="bx bx-chevron-right"></i> <a href="<?php echo base_url(); ?>#services">Services</a></li>
                        <li><i class="bx bx-chevron-right"></i> <a href="<?php echo base_url(); ?>terms_conditions">Terms of service</a></li>
                        <li><i class="bx bx-chevron-right"></i> <a href="<?php echo base_url(); ?>privacy_policy">Privacy policy</a></li>
                    </ul>
                </div>

                <div class="col-lg-3 col-md-6 footer-links">
                    <h4>Our Services</h4>
                    <ul>
                        <li><i class="bx bx-chevron-right"></i> <a href="<?php echo base_url(); ?>airtime">Airtime</a></li>
                        <li><i class="bx bx-chevron-right"></i> <a href="<?php echo base_url(); ?>airtime/print-recharge-card">Recharge card printing</a></li>
                        <li><i class="bx bx-chevron-right"></i> <a href="<?php echo base_url(); ?>data">Internet Data</a></li>
                        <li><i class="bx bx-chevron-right"></i> <a href="<?php echo base_url(); ?>home">Daily Auction</a></li>
                        <li><i class="bx bx-chevron-right"></i> <a href="<?php echo base_url(); ?>investment/new">Investment</a></li>
                        <li><i class="bx bx-chevron-right"></i> <a href="<?php echo base_url(); ?>loan">Business Loan</a></li>
                    </ul>
                </div>

                <div class="col-lg-4 col-md-6 footer-newsletter">
                    <h4>Join Our Newsletter</h4>
                    <p>Get notified on any of our new update and promotion</p>
                    <form action="" method="post">
                        <input type="email" name="email"><input type="submit" value="Subscribe">
                    </form>
                </div>

            </div>
        </div>
    </div>

    <div class="container d-lg-flex py-4">

        <div class="mr-lg-auto text-center text-lg-left">
            <div class="copyright">
                &copy; Copyright <strong><span>Drip2Drop</span></strong>. All Rights Reserved
            </div>
            <div class="credits">
                <!-- All the links in the footer should remain intact. -->
                <!-- You can delete the links only if you purchased the pro version. -->
                <!-- Licensing information: https://bootstrapmade.com/license/ -->
                <!-- Purchase the pro version with working PHP/AJAX contact form: https://bootstrapmade.com/flexor-free-multipurpose-bootstrap-template/ -->
                Powered by <a href="#">Global Tech & Services LTD</a>
            </div>
        </div>
        <div class="social-links text-center text-lg-right pt-3 pt-lg-0">
            <a href="#" class="twitter"><i class="bx bxl-twitter"></i></a>
            <a href="fb.me/drip2drop" class="facebook"><i class="bx bxl-facebook"></i></a>
            <a href="#" class="instagram"><i class="bx bxl-instagram"></i></a>
            <a href="#" class="google-plus"><i class="bx bxl-skype"></i></a>
            <a href="#" class="linkedin"><i class="bx bxl-linkedin"></i></a>
        </div>
    </div>
</footer><!-- End Footer -->

<a href="#" class="back-to-top"><i class="icofont-simple-up"></i></a>

<!-- Vendor JS Files -->
<script src="<?php echo base_url(); ?>assets/vendor/jquery/jquery.min.js"></script>
<script src="<?php echo base_url(); ?>assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="<?php echo base_url(); ?>assets/vendor/jquery.easing/jquery.easing.min.js"></script>
<script src="<?php echo base_url(); ?>assets/vendor/php-email-form/validate.js"></script>
<script src="<?php echo base_url(); ?>assets/vendor/jquery-sticky/jquery.sticky.js"></script>
<script src="<?php echo base_url(); ?>assets/vendor/venobox/venobox.min.js"></script>
<script src="<?php echo base_url(); ?>assets/vendor/owl.carousel/owl.carousel.min.js"></script>
<script src="<?php echo base_url(); ?>assets/vendor/isotope-layout/isotope.pkgd.min.js"></script>
<script src="<?php echo base_url(); ?>assets/vendor/aos/aos.js"></script>

<!-- Template Main JS File -->
<script src="<?php echo base_url(); ?>assets/js/main.js"></script>

<!--Start of Tawk.to Script-->
<script type="text/javascript">
    var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
    (function(){
        var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
        s1.async=true;
        s1.src='https://embed.tawk.to/5ea0df0b35bcbb0c9ab3c88b/default';
        s1.charset='UTF-8';
        s1.setAttribute('crossorigin','*');
        s0.parentNode.insertBefore(s1,s0);
    })();
</script>
<!--End of Tawk.to Script-->
</body>

</html>
