<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta content="width=device-width, initial-scale=1.0" name="viewport">

    <title><?php echo $this->Util_model->get_option('site_title'); ?> - <?php echo $this->Util_model->get_option('site_tagline'); ?></title>
    <!--  Social tags      -->
    <meta name="keywords" content="loan,investment,data,airtime,buy airtime, buy data, print recharge card,recharge card,online money,make money online,easy money,covid19 support,fast money,easy money,payout,free money,ponzi,peer to peer">
    <meta name="description" content="A financial support platform that boosts the financial strength of its members">
    <!-- Schema.org markup for Google+ -->
    <meta itemprop="name" content="Drip2Drop">
    <meta itemprop="description" content="Drip2Drop is a financial support platform that boosts the financial strenth of its members.">
    <meta itemprop="image" content="<?php echo base_url(); ?>assets/img/thumbnail.png">
    <!-- Twitter Card data -->
    <meta name="twitter:card" content="product">
    <meta name="twitter:site" content="@drip2drop">
    <meta name="twitter:title" content="Drip2Drop">
    <meta name="twitter:description" content="Drip2Drop is a financial support platform that boosts the financial strenth of its members.">
    <meta name="twitter:creator" content="@drip2drop">
    <meta name="twitter:image" content="<?php echo base_url(); ?>assets/img/thumbnail.png">
    <!-- Open Graph data -->
    <meta property="fb:app_id" content="235636677648239">
    <meta property="og:title" content="Drip2Drop" />
    <meta property="og:type" content="A money making platform" />
    <meta property="og:url" content="<?php echo base_url(); ?>" />
    <meta property="og:image" content="<?php echo base_url(); ?>assets/img/thumbnail.png" />
    <meta property="og:description" content="Drip2Drop is a financial support platform that boosts the financial strenth of its members." />
    <meta property="og:site_name" content="Drip2Drop" />
    <!-- Favicons -->
    <link href="<?php echo base_url(); ?>assets/img/favicon.png" rel="icon">
    <link href="<?php echo base_url(); ?>assets/img/apple-touch-icon.png" rel="apple-touch-icon">

    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Raleway:300,300i,400,400i,500,500i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">

    <!-- Vendor CSS Files -->
    <link href="<?php echo base_url(); ?>assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <link href="<?php echo base_url(); ?>assets/vendor/icofont/icofont.min.css" rel="stylesheet">
    <link href="<?php echo base_url(); ?>assets/vendor/boxicons/css/boxicons.min.css" rel="stylesheet">
    <link href="<?php echo base_url(); ?>assets/vendor/venobox/venobox.css" rel="stylesheet">
    <link href="<?php echo base_url(); ?>assets/vendor/owl.carousel/assets/owl.carousel.min.css" rel="stylesheet">
    <link href="<?php echo base_url(); ?>assets/vendor/aos/aos.css" rel="stylesheet">

    <!-- Template Main CSS File -->
    <link href="<?php echo base_url(); ?>assets/dist/css/util.css" rel="stylesheet">
    <link href="<?php echo base_url(); ?>assets/css/style.css" rel="stylesheet">

    <!-- =======================================================
    * Template Name: Flexor - v2.0.0
    * Template URL: https://bootstrapmade.com/flexor-free-multipurpose-bootstrap-template/
    * Author: BootstrapMade.com
    * License: https://bootstrapmade.com/license/
    ======================================================== -->
</head>

<body>

<!-- ======= Top Bar ======= -->
<section id="topbar" class="d-none d-lg-block">
    <div class="container d-flex">
        <div class="contact-info mr-auto">
            <ul>
                <li><i class="icofont-envelope"></i><a href="mailto:contact@drip2drop.com">contact@drip2drop.com</a></li>
                <li><i class="icofont-clock-time icofont-flip-horizontal"></i> Mon-Sat 9am - 6pm, Sun 2pm - 6pm</li>
            </ul>

        </div>
        <div class="cta">
            <?php if ($this->session->has_userdata(UID)) : ?>
                <a href="<?php echo base_url(); ?>home">My AD2Dount</a>
            <?php else : ?>
                <a href="<?php echo base_url(); ?>sign-in">Sign In</a>
            <?php endif; ?>
        </div>
    </div>
</section>

<!-- ======= Header ======= -->
<header id="header">
    <div class="container d-flex">

        <div class="logo mr-auto">
            <h1 class="text-light"><a href="<?php echo base_url(); ?>"><span><?php echo $this->Util_model->get_option('site_title'); ?></span></a></h1>
            <!-- Uncomment below if you prefer to use an image logo -->
            <!-- <a href="index.html"><img src="<?php echo base_url(); ?>assets/img/logo.png" alt="" class="img-fluid"></a>-->
        </div>

        <nav class="nav-menu d-none d-lg-block">
            <ul>
                <li class="active"><a href="<?php echo base_url(); ?>">Home</a></li>
                <li><a href="<?php echo base_url(); ?>#about">About</a></li>
                <li><a href="<?php echo base_url(); ?>#services">Services</a></li>
                <li><a href="<?php echo base_url(); ?>#pricing">Packages</a></li>
                <li><a href="<?php echo base_url(); ?>#contact">Contact</a></li>
                <?php if ($this->session->has_userdata(UID)) : ?>
                    <li><a href="<?php echo base_url(); ?>home">My AD2Dount</a></li>
                <?php else : ?>
                    <li class="drop-down"><a href="">Sign In / Sign Up</a>
                        <ul>
                            <li><a href="<?php echo base_url(); ?>sign-in">Sign In</a></li>
                            <li><a href="<?php echo base_url(); ?>sign-up">Create AD2Dount</a></li>
                        </ul>
                    </li>
                <?php endif; ?>
            </ul>
        </nav><!-- .nav-menu -->

    </div>
</header><!-- End Header -->

<main id="main" style="margin-top: 20px">
    <!-- ======= About Section ======= -->
    <section id="blog" class="about section-bg" style="background-color: #FFFFFF">
        <div class="container">

            <div class="row">
                <div class="col-md-12">
                    <h2>Welcome to Drip2Drop</h2>
                    <p>These terms and conditions outline the rules and regulations for the use of Drip2Drop's Website.</p> <br />
                    <span style="text-transform: capitalize;"> Drip2Drop</span> is located at:<br />
                    <address>27 Akerele lane Maryland Maryland <br />100001 - Lagos , Nigeria<br />
                    </address>
                    <p>By accessing this website we assume you accept these terms and conditions in full. Do not continue to use Drip2Drop's website
                        if you do not accept all of the terms and conditions stated on this page.</p>
                    <p>The following terminology applies to these Terms and Conditions, Privacy Statement and Disclaimer Notice
                        and any or all Agreements: "Client", "You" and "Your" refers to you, the person accessing this website
                        and accepting the Company's terms and conditions. "The Company", "Ourselves", "We", "Our" and "Us", refers
                        to our Company. "Party", "Parties", or "Us", refers to both the Client and ourselves, or either the Client
                        or ourselves. All terms refer to the offer, acceptance and consideration of payment necessary to undertake
                        the process of our assistance to the Client in the most appropriate manner, whether by formal meetings
                        of a fixed duration, or any other means, for the express purpose of meeting the Client's needs in respect
                        of provision of the Company's stated services/products, in accordance with and subject to, prevailing law
                        of Nigeria. Any use of the above terminology or other words in the singular, plural,
                        capitalisation and/or he/she or they, are taken as interchangeable and therefore as referring to same.</p><h2>Cookies</h2>
                    <p>We employ the use of cookies. By using Drip2Drop's website you consent to the use of cookies
                        in accordance with Drip2Drop's privacy policy.</p><p>Most of the modern day interactive web sites
                        use cookies to enable us to retrieve user details for each visit. Cookies are used in some areas of our site
                        to enable the functionality of this area and ease of use for those people visiting. Some of our
                        affiliate / advertising partners may also use cookies.</p><h2>License</h2>
                    <p>Unless otherwise stated, Drip2Drop and/or it's licensors own the intellectual property rights for
                        all material on Drip2Drop. All intellectual property rights are reserved. You may view and/or print
                        pages from https://www.drip2drop.com for your own personal use subject to restrictions set in these terms and conditions.</p>
                    <p>You must not:</p>
                    <ol>
                        <li>Republish material from https://www.drip2drop.com</li>
                        <li>Sell, rent or sub-license material from https://www.drip2drop.com</li>
                        <li>Reproduce, duplicate or copy material from https://www.drip2drop.com</li>
                    </ol>
                    <p>Redistribute content from Drip2Drop (unless content is specifically made for redistribution).</p>
                    <h2>Hyperlinking to our Content</h2>
                    <ol>
                        <li>The following organizations may link to our Web site without prior written approval:
                            <ol>
                                <li>Government agencies;</li>
                                <li>Search engines;</li>
                                <li>News organizations;</li>
                                <li>Online directory distributors when they list us in the directory may link to our Web site in the same
                                    manner as they hyperlink to the Web sites of other listed businesses; and</li>
                                <li>Systemwide Accredited Businesses except soliciting non-profit organizations, charity shopping malls,
                                    and charity fundraising groups which may not hyperlink to our Web site.</li>
                            </ol>
                        </li>
                    </ol>
                    <ol start="2">
                        <li>These organizations may link to our home page, to publications or to other Web site information so long
                            as the link: (a) is not in any way misleading; (b) does not falsely imply sponsorship, endorsement or
                            approval of the linking party and its products or services; and (c) fits within the context of the linking
                            party's site.
                        </li>
                        <li>We may consider and approve in our sole discretion other link requests from the following types of organizations:
                            <ol>
                                <li>commonly-known consumer and/or business information sources such as Chambers of Commerce, American
                                    Automobile Association, AARP and Consumers Union;</li>
                                <li>dot.com community sites;</li>
                                <li>associations or other groups representing charities, including charity giving sites,</li>
                                <li>online directory distributors;</li>
                                <li>internet portals;</li>
                                <li>accounting, law and consulting firms whose primary clients are businesses; and</li>
                                <li>educational institutions and trade associations.</li>
                            </ol>
                        </li>
                    </ol>
                    <p>We will approve link requests from these organizations if we determine that: (a) the link would not reflect
                        unfavorably on us or our accredited businesses (for example, trade associations or other organizations
                        representing inherently suspect types of business, such as work-at-home opportunities, shall not be allowed
                        to link); (b)the organization does not have an unsatisfactory record with us; (c) the benefit to us from
                        the visibility associated with the hyperlink outweighs the absence of Drip2Drop; and (d) where the
                        link is in the context of general resource information or is otherwise consistent with editorial content
                        in a newsletter or similar product furthering the mission of the organization.</p>

                    <p>These organizations may link to our home page, to publications or to other Web site information so long as
                        the link: (a) is not in any way misleading; (b) does not falsely imply sponsorship, endorsement or approval
                        of the linking party and it products or services; and (c) fits within the context of the linking party's
                        site.</p>

                    <p>If you are among the organizations listed in paragraph 2 above and are interested in linking to our website,
                        you must notify us by sending an e-mail to <a href="mailto:info@drip2drop.com" title="send an email to info@drip2drop.com">info@drip2drop.com</a>.
                        Please include your name, your organization name, contact information (such as a phone number and/or e-mail
                        address) as well as the URL of your site, a list of any URLs from which you intend to link to our Web site,
                        and a list of the URL(s) on our site to which you would like to link. Allow 2-3 weeks for a response.</p>

                    <p>Approved organizations may hyperlink to our Web site as follows:</p>

                    <ol>
                        <li>By use of our corporate name; or</li>
                        <li>By use of the uniform resource locator (Web address) being linked to; or</li>
                        <li>By use of any other description of our Web site or material being linked to that makes sense within the
                            context and format of content on the linking party's site.</li>
                    </ol>
                    <p>No use of Drip2Drop's logo or other artwork will be allowed for linking absent a trademark license
                        agreement.</p>
                    <h2>Iframes</h2>
                    <p>Without prior approval and express written permission, you may not create frames around our Web pages or
                        use other techniques that alter in any way the visual presentation or appearance of our Web site.</p>
                    <h2>Reservation of Rights</h2>
                    <p>We reserve the right at any time and in its sole discretion to request that you remove all links or any particular
                        link to our Web site. You agree to immediately remove all links to our Web site upon such request. We also
                        reserve the right to amend these terms and conditions and its linking policy at any time. By continuing
                        to link to our Web site, you agree to be bound to and abide by these linking terms and conditions.</p>
                    <h2>Removal of links from our website</h2>
                    <p>If you find any link on our Web site or any linked web site objectionable for any reason, you may contact
                        us about this. We will consider requests to remove links but will have no obligation to do so or to respond
                        directly to you.</p>
                    <p>Whilst we endeavour to ensure that the information on this website is correct, we do not warrant its completeness
                        or accuracy; nor do we commit to ensuring that the website remains available or that the material on the
                        website is kept up to date.</p>
                    <h2>Content Liability</h2>
                    <p>We shall have no responsibility or liability for any content appearing on your Web site. You agree to indemnify
                        and defend us against all claims arising out of or based upon your Website. No link(s) may appear on any
                        page on your Web site or within any context containing content or materials that may be interpreted as
                        libelous, obscene or criminal, or which infringes, otherwise violates, or advocates the infringement or
                        other violation of, any third party rights.</p>
                    <h2>Disclaimer</h2>
                    <p>To the maximum extent permitted by applicable law, we exclude all representations, warranties and conditions relating to our website and the use of this website (including, without limitation, any warranties implied by law in respect of satisfactory quality, fitness for purpose and/or the use of reasonable care and skill). Nothing in this disclaimer will:</p>
                    <ol>
                        <li>limit or exclude our or your liability for death or personal injury resulting from negligence;</li>
                        <li>limit or exclude our or your liability for fraud or fraudulent misrepresentation;</li>
                        <li>limit any of our or your liabilities in any way that is not permitted under applicable law; or</li>
                        <li>exclude any of our or your liabilities that may not be excluded under applicable law.</li>
                    </ol>
                    <p>The limitations and exclusions of liability set out in this Section and elsewhere in this disclaimer: (a)
                        are subject to the preceding paragraph; and (b) govern all liabilities arising under the disclaimer or
                        in relation to the subject matter of this disclaimer, including liabilities arising in contract, in tort
                        (including negligence) and for breach of statutory duty.</p>
                    <p>To the extent that the website and the information and services on the website are provided free of charge,
                        we will not be liable for any loss or damage of any nature.</p>
                    <p></p>
                </div>
                <div class="col-md-12">
                    <h2><b>INVESTOR</b></h2>
                    <p><span style="font-weight: 400;">These terms and conditions (these “</span><b>terms</b><span style="font-weight: 400;">”) set out the terms of the agreement between you (“</span><b>you</b><span style="font-weight: 400;">”) as the user of D2D’s Site, and us, Drip2Drop (“</span><b>we</b><span style="font-weight: 400;">”, “</span><b>us</b><span style="font-weight: 400;">” or “</span><b>D2D</b><span style="font-weight: 400;">”). </span></p>
                    <p><span style="font-weight: 400;">The Custodian provides its service of holding any shares and Client Money in aD2Dordance with the Custodian’s Terms and Conditions of Business. When you enter this agreement, you also agree to the Custodian’s Terms and Conditions of Business, which are available here: </span><a href="https://www.drip2drop.com/terms_conditions"><span style="font-weight: 400;">https://www.drip2drop.com/terms_conditions</span></a></p>
                    <p><span style="font-weight: 400;">These terms must be read in conjunction with D2D’s terms of website use capitalcell.co.uk/terms-and-conditions/ and privacy policy capitalcell.co.uk/privacy-and-cookie-policy/ and the Custodian’s Terms and Conditions of Business and they apply to your use of the Site as an investor (“</span><b>Investor</b><span style="font-weight: 400;">”), including as the lead investor(s) in respect of a particular Fund Raising (“</span><b>Lead Investor</b><span style="font-weight: 400;">”). Use of D2D’s Site is conditional upon your aD2Deptance of these terms. If you do not agree to these terms you should immediately discontinue use of D2D’s Site.</span></p>
                    <p><span style="font-weight: 400;">These terms shall become binding as soon as you have completed the registration process. Your ability to invest through the Site will be conditional upon you suD2Dessfully passing D2D’s anti-money laundering checks.</span></p>
                    <p>&nbsp;</p>
                    <h3><b>1. DEFINITIONS</b></h3>
                    <p><span style="font-weight: 400;">“</span><b>Articles</b><span style="font-weight: 400;">” means the articles of association of the Company concerned as adopted and in force from time to time.</span></p>
                    <p><span style="font-weight: 400;">“</span><b>Client Money</b><span style="font-weight: 400;">” means </span><span style="font-weight: 400;">money</span> <span style="font-weight: 400;">of any currency which the Escrow Agent holds on behalf of the Investor, as defined and regulated under the Custodian’s T&amp;Cs and subject to the prevailing rules contained in the CASS Sourcebook of the FCA.</span></p>
                    <p><span style="font-weight: 400;">“</span><b>Commitment</b><span style="font-weight: 400;">” means the process executed by an Investor on the Site, by means of which they (i) confirm the amount they wish to invest in the Company; (ii) transfer the funds to the Pre-Closing AD2Dount; (iii) authorise the payment to the Company upon completion of certain conditions; and (iv) authorise the Custodian to enter into the Investment Agreement. </span></p>
                    <p><span style="font-weight: 400;">“</span><b>Company</b><span style="font-weight: 400;">” means a private company limited by shares which is seeking to raise funds in whole or part through D2D’s Site.</span></p>
                    <p><span style="font-weight: 400;">“</span><b>Completion Conditions</b><span style="font-weight: 400;">” means the conditions that must be met to proceed to completion and execution of the investment for a given Posting, as set forth under clause 4.15. The Completion Conditions are deemed to be met when they are certified as such by D2D under its responsibility, acting on behalf of the Investor under these terms.</span></p>
                    <p><span style="font-weight: 400;">“</span><b>Custodian’s T&amp;Cs</b><span style="font-weight: 400;">” or “</span><b>Custodian’s Terms and Conditions of Business</b><span style="font-weight: 400;">” mean the Reyker Securities Plc Group General Terms and Conditions, as published from time to time at the following URL: </span><a href="https://www.drip2drop.com/terms_conditions"><span style="font-weight: 400;">https://www.drip2drop.com/terms_conditions</span></a><span style="font-weight: 400;">;</span></p>
                    <p><span style="font-weight: 400;">“</span><b>Escrow Agent</b><span style="font-weight: 400;">” means the Custodian, when referred to in connection with its handling of Client Money and of the Pre-Closing AD2Dount. </span><span style="font-weight: 400;">The Escrow Agent acts in the interest of the Investor to ensure that the monies collected in a Fund Raising are treated in aD2Dordance with these terms and the applicable subscription agreement.</span></p>
                    <p><span style="font-weight: 400;">“</span><b>Fund Raising</b><span style="font-weight: 400;">” means a fund raising performed by a Company in whole or part through D2D’s Site.</span></p>
                    <p><span style="font-weight: 400;">“</span><b>HMRC</b><span style="font-weight: 400;">” means HM Revenue and Customs.</span></p>
                    <p><span style="font-weight: 400;">“</span><b>Investor</b><span style="font-weight: 400;">” means a user of the Site who has followed the step to formalise a Commitment to invest in a Company.</span></p>
                    <p><span style="font-weight: 400;">“</span><b>Lead Investor</b><span style="font-weight: 400;">” means an Investor whose investment in a given Fund Raising represents 20% or more of the relevant Target Amount, and who has been approved as such by D2D.</span></p>
                    <p><span style="font-weight: 400;">“</span><b>Maximum Target Amount</b><span style="font-weight: 400;">” means the maximum total amount that a Company seeks to raise in a Fund Raising through the Site and through other sources. </span></p>
                    <p><span style="font-weight: 400;">“</span><b>Minimum Target Amount</b><span style="font-weight: 400;">” means the minimum total amount that a Company seeks to raise in a Fund Raising which, in any event, is no less than 90% of the Target Amount.</span></p>
                    <p><span style="font-weight: 400;">“</span><b>Nominated AD2Dount</b><span style="font-weight: 400;">” means the bank aD2Dount of an Investor (in the name of the Investor) nominated by such Investor at the time of registration on the Site, as may be subsequently changed by such Investor. </span></p>
                    <p><span style="font-weight: 400;">“</span><b>Nominee</b><span style="font-weight: 400;">” means a nominee controlled and wholly owned nominee company used by the Custodian from time to time at its sole option, being the registered holder of shares, stocks, securities and cash held as safe custodian on behalf of you, the beneficial owner. Reyker nominee companies are wholly owned non-trading subsidiaries in the Reyker Group and are not themselves authorised under the Financial Services and Markets Act 2000. It is deemed by Reyker and agreed by you that you agree that your investment assets and client money shall be held in such nominee company controlled by such Reyker Group regulated entity as the Custodian considers appropriate from time to time and that the Custodian may transfer your assets and client money from one nominee to another should they consider this to be necessary or appropriate to protect your interests better or for business or administrative efficiency. This shall not adversely affect your legal rights. The Reyker Group does not permit any Nominee to trade, sign contracts that may be construed as a trade, or enter into a liability or arrangement that may incur a liability. All Client Assets and client monies held by any Reyker Nominees are held in a general pool which contains all retail client assets and monies and this general pool is not commingled with any Reyker group assets and is protected at all times.</span></p>
                    <p><span style="font-weight: 400;">“</span><b>Period”</b><span style="font-weight: 400;"> means the initial period of between 30-60 days, as set out on a Company’s Posting, during which the Posting will remain open for investment.</span></p>
                    <p><span style="font-weight: 400;">“</span><b>Posting</b><span style="font-weight: 400;">” means a listing for a Company on the Site. </span></p>
                    <p><span style="font-weight: 400;">“</span><b>Pre-Closing AD2Dount</b><span style="font-weight: 400;">” means the aD2Dount of the Escrow Agent open at the UK bank NATIONAL WESTMINSTER BANK PLC, which will receive all the money transferred by the Investors for any ongoing Fund Raising within the Site, with due identification and tracking of the funds that correspond to each Investor and each Fund Raising. Upon execution of the Commitment by the Investor, the funds shall be transferred to the Pre-Closing AD2Dount to be held in escrow by the Escrow Agent until completion. In the event that the Completion Conditions are duly fulfilled, the funds shall be released to the Company as payment of the Investor’s investment.</span></p>
                    <p><span style="font-weight: 400;">“</span><b>Relevant Person</b><span style="font-weight: 400;">” means each Lead Investor, the Custodian, D2D and any and all of D2D and the Custodian’s directors, employees, consultants, agents or advisers.</span></p>
                    <p><span style="font-weight: 400;">“</span><b>Relief</b><span style="font-weight: 400;">” or “</span><b>Reliefs</b><span style="font-weight: 400;">” mean certain types of tax relief for investments in small businesses, in particular those offered to UK tax resident individuals, among which are the Enterprise Investment Scheme (EIS) and the Seed Enterprise Investment Scheme (SEIS).</span></p>
                    <p><span style="font-weight: 400;">“</span><b>Site</b><span style="font-weight: 400;">” means D2D’s online crowdfunding site at </span><a href="http://www.capitalcell.co.uk"><span style="font-weight: 400;">www.capitalcell.co.uk</span></a><span style="font-weight: 400;">, which allows the user to aD2Dess information about companies working in the area of life sciences that are seeking money to finance the development or expansion of their business utilising D2D’s website, and to invest in such companies subject to these terms and conditions. </span></p>
                    <p><span style="font-weight: 400;">“</span><b>Investment Agreement</b><span style="font-weight: 400;">” means an agreement between the Custodian and the Company under which the Custodian applies for the shares, which shall be held by the Nominee, on behalf of the Investor(s), and which sets out the full terms on which the Custodian (acting on behalf of the Investors) agrees to subscribe for such shares. </span></p>
                    <p><span style="font-weight: 400;">“</span><b>Target Amount</b><span style="font-weight: 400;">” means the amount a Company is seeking to raise through the relevant Fund Raising. </span></p>
                    <p><span style="font-weight: 400;">“</span><b>Target Date</b><span style="font-weight: 400;">” means the date by which the Minimum Target Amount must be raised. </span></p>
                    <p>&nbsp;</p>
                    <h3><b>2. INVESTMENT RISKS AND WARNINGS</b></h3>
                    <p><span style="font-weight: 400;">By using D2D’s Site in any capacity you acknowledge and agree that you have read and understood the following risks and warnings. If you do not understand any of the risks or warnings set out below you must take advice from an independent financial advisor, solicitor or similar qualified professional before using D2D’s Site. The following list contains what we believe to be the main risk factors of your investment, and is not intended to be exhaustive, nor a complete explanation of the risks involved. Each Company will have risks that are specific to it. Any decision to make an investment through D2D’s Site is made entirely at your own risk. </span></p>
                    <p>&nbsp;</p>
                    <ol>
                        <li><b>Potential for loss. <span style="font-weight: 400;">Investing in start-up businesses is inherently risky and most start-ups will fail. There is a significant chance that you will lose all of the monies you invest in companies that appear on the Site. Given the risks involved in investing in start-up companies, these investments should form part of a diversified portfolio of investments. You should not invest any more in these opportunities than you can afford to lose. </span></b></li>
                        <li><b>History. <span style="font-weight: 400;">As the majority of Companies that appear on D2D’s Site are recently formed start-up companies, they may lack any trading or other operating history. The suD2Dess of the Company will depend upon the ability of the Company’s management team to implement a strategy for growing the Company, as well as other factors including overall market conditions, the Company’s future ability to raise funds, the adequacy of its finances, etc. Any financial information provided is unlikely to be audited and may not have be verified by an independent third party.</span></b></li>
                        <li><b>Statements of anticipated performance and forecasts. <span style="font-weight: 400;">A Posting for a Company may contain certain statements, estimates, projections, forecasts and data provided by the Company with respect to the anticipated future performance of the Company’s business and/or its industry. Such statements, estimates, projections, forecasts and data reflect various assumptions by the Company’s management concerning anticipated results, which assumptions may or may not prove to be correct. Actual results may vary from such statements, estimates, projections, forecasts and data, and such variations may be material. This may result in the Company and your shares performing worse than expected in the forecast. Therefore, you should not rely on any forecasts or statements of anticipated performance of a Company which may be included in the Site. </span></b></li>
                        <li><b>Liquidity risk. <span style="font-weight: 400;">It is unlikely that, in the short to medium term, any secondary market for shares that you acquire in companies seeking investment on D2D’s Site will develop, nor is it likely that any of them will be listed on any recognised stock market. As such you are unlikely to be able to sell your shares unless and until an exit event happens, such as an offer by a buyer for the whole of the Company’s issued share capital or a public offer of shares. Except in such events, you will normally be unable to sell your shares and withdraw your money from the Company.</span></b></li>
                        <li><b>Dividends. <span style="font-weight: 400;">Start-up companies rarely pay dividends so you are unlikely to receive any return on your investment unless and until an exit event happens, such as an offer by a buyer for the whole of the Company’s issued share capital. Therefore, for most of your investment you will probably not receive any income from the investment. </span></b></li>
                        <li><b>Dilution. <span style="font-weight: 400;">Any investment you make is subject to dilution. It is likely that the Company will need to raise additional capital in the future which is likely to require one or more issues of shares to existing and/or new investors. Therefore, the proportion of the Company which your shares correspond to at the time you make your investment may subsequently be diluted by such subsequent issue(s) of shares. This means that you may lose voting power and that your shares may lose part or all of their value. </span></b>In order to incentivise, retain or attract directors, employees or service providers the Company may also choose to issue shares or grant share options to them, which would also dilute your shareholding. New shares issued in subsequent fund raising(s) by the Company may also carry preferential rights to the shares acquired by you on the Site. For example, they may carry a right to participate in the proceeds of sale before any proceeds of sale are distributed to shareholders who applied for shares through the Site or to receive one or more times the amount invested by the relevant investor.</li>
                        <li><b>Tax treatment of shares. <span style="font-weight: 400;">The UK government provides certain types of tax Reliefs for investments in small businesses by UK tax resident individuals. Certain investments made through the Site may be eligible for EIS, SEIS or similar relief. Your eligibility to benefit from a Relief will depend both on the Company’s and your own personal circumstances, as well as other conditions that may apply under the relevant law. There is a risk that the Company may carry out activities or a change in legislation that result in such Reliefs being lost. </span></b>You must normally be a UK resident in order to apply for Reliefs under UK tax law. Other jurisdictions may offer other Reliefs along the lines (or not) of the ones described above. We will not be liable to you for any losses, damages or costs arising in the event that you are not able to claim a Relief on a particular investment or because any Relief you have claimed is lost, due to any of the circumstances described in these terms or otherwise. You should speak with your tax adviser and/or a solicitor before making any investment on the basis that you will be able to receive any Relief.</li>
                        <li><b>Compensation. <span style="font-weight: 400;">Investors will not be able to bring any claim under the Financial Services Compensation Scheme in the event that any Company fails. </span></b></li>
                        <li><b>Pre-Closing AD2Dount.</b><span style="font-weight: 400;"> Your money will be held in the Pre-Closing AD2Dount prior to completion. </span><span style="font-weight: 400;">Funds held in the pre-closing aD2Dount by the Escrow Agent will be held in a bank aD2Dount held with trust status as required by FCA rules and may be protected under the FSCS compensation scheme subject to the limitations of the scheme. The amount of protection available to you may be dependent on individual circumstances and exposures and you acknowledge that the Custodian does not have knowledge of any other bank aD2Dount holdings you may have or circumstances that may affect your FSCS cover.</span></li>
                    </ol>
                    <p>&nbsp;</p>
                    <h3><b>3. PRE-INVESTMENT</b></h3>
                    <ol>
                        <li><b>Site profile.<span style="font-weight: 400;"> Upon registration to use the Site, you will be asked to provide certain information about yourself as part of your Site profile. The information you provide in your profile is the basis on which D2D and the Custodian identify you for purposes of communicating with you, fulfilling any reporting obligations that D2D and/or the Custodian have to any regulatory or governmental authorities, and conducting any anti-money laundering or other checks they run on you.</span></b></li>
                        <li><b>Self-certification.<span style="font-weight: 400;"> If you make an investment in a Company through the Site you will become a “retail” client of D2D and of the Custodian (under the Custodian’s T&amp;Cs) for the purposes of the FCA (Financial Conduct Authority, www.fca.org.uk) Rules. As part of your registration process, you will be required to answer self-certification questions. You must answer such questions truthfully and in a factually correct way to the best of your knowledge</span></b></li>
                        <li><b>No advice. <span style="font-weight: 400;">You acknowledge and agree that D2D and the Custodian have not provided you with any advice in relation to the transactions conducted through the Site. In addition, you confirm to both D2D and the Custodian that, for the purposes of entering into any investment, you enter into it entirely on the basis of your own assessment of the risks involved, and/or on independent advice you have obtained from your professional advisor.</span></b></li>
                        <li><b>Fund raising updates. <span style="font-weight: 400;">As part of the registration process, you will be able to sign up for regular updates in respect of the progress of a Company’s Fund Raising. These updates will be sent to you via email to the address you provide as part of the registration process. You can opt-out of receiving these updates at any time by contacting us at info@capitalcell.net.</span></b></li>
                    </ol>
                    <h3></h3>
                    <h3><b>4. INVESTMENT PROCESS</b></h3>
                    <p><b>1. Restricted aD2Dess to investment. <span style="font-weight: 400;">The opportunity to invest in a Company through the Site is only aD2Dessible to registered users falling in one of the categories that lawfully allow them to receive information on non-readily realisable securities as per the FCA handbook (in particular, COBS 4.7.7R). By agreeing to these terms you agree that you are at least one of the following:</span></b></p>
                    <p><span style="font-weight: 400;">a) A certified high net worth investor in aD2Dordance with COBS 4.7.9R;</span></p>
                    <p><span style="font-weight: 400;">b) A certified or self-certified sophisticated investor in aD2Dordance with COBS 4.7.9R;</span></p>
                    <p><span style="font-weight: 400;">c) A restricted investor in aD2Dordance with COBS 4.7.10R</span></p>
                    <p><span style="font-weight: 400;">d) An investment professional (within the meaning of article 19(5) of the Financial Services and Market Act 2000 (Financial Promotion) Order 2005 (FPO).</span></p>
                    <p><span style="font-weight: 400;">You agree that you are subscribing for shares in the Company for your own aD2Dount for investment purposes only and not with a view to the resale or distribution of the shares.</span></p>
                    <p><span style="font-weight: 400;">You agree that if you are in doubt about any investment that you should seek independent advice from a professional adviser who is qualified to advise in the acquisition of shares and securities.</span></p>
                    <p><span style="font-weight: 400;">You agree that no offer to the public has or is being made in connection with any investment and that you are acting for yourself and no other person when investing in a Company.</span></p>
                    <p><span style="font-weight: 400;">You also expressly agree that you consider, and will treat for all purposes, any such offer (a) as &#8220;not being calculated to result, directly or indirectly, in such shares becoming available to persons other than those receiving the offer,&#8221; as that phrase is used in section 756(3) of the Companies Act, and, as a consequence, (b) as not being a &#8220;public offer&#8221; for purposes of section 755 of the Companies Act. </span></p>
                    <p><b>2. Information contained in a Posting.<span style="font-weight: 400;"> On becoming a registered user you will be able to view the Postings on the Site. The information that you will have aD2Dess to in respect of each Posting that you can view will normally include without limitation:</span></b></p>
                    <p><span style="font-weight: 400;">a) the name, legal status, physical address and website address of the Company;</span></p>
                    <p><span style="font-weight: 400;">b) the names of the directors and 20% or greater shareholders;</span></p>
                    <p><span style="font-weight: 400;">c) a description of the business and intended use of the proceeds from the Fund Raising;</span></p>
                    <p><span style="font-weight: 400;">d) the Minimum Target Amount and the Maximum Target Amount that the Company wishes to raise and the Target Date by which the Minimum Target Amount must have been raised;</span></p>
                    <p><span style="font-weight: 400;">e) </span><span style="font-weight: 400;">details about the Lead Investor(s), unless they wish to remain anonymous, in which case you will only see the amount invested or agreed to be invested by the Lead Investor(s); details of the Lead Investor will be revealed when the Fund Raising is suD2Dessful, as defined under clause 4.10</span></p>
                    <p><span style="font-weight: 400;">f) details of the ownership and capital structure of the Company including the rights attaching to the shares being offered on the Site;</span></p>
                    <p><span style="font-weight: 400;">g) any due diligence reports prepared on the Company; </span></p>
                    <p><span style="font-weight: 400;">h) a description of the Company’s proposed exit strategy (please note that this is subject to, and is likely to, change as the Company develops); </span></p>
                    <p><span style="font-weight: 400;">i) whether the Company has received advance assurance from HMRC that it is eligible for EIS or SEIS relief and, if not, whether the Company (i) appears to D2D to be eligible for a EIS or SEIS; and (ii) has agreed to allow Investors to claim such Relief;</span></p>
                    <p><span style="font-weight: 400;">j) the Investment Agreement that the Company will enter into with the Custodian on completion of the Fund Raising; and the Articles or, as the case may be, the form of Articles of Association that will be adopted on completion of the Fund Raising (which will set out in detail the rights attaching to shares issued to Investors). </span></p>
                    <p><b>3. Confidentiality. <span style="font-weight: 400;">An Investor shall not use any information contained in the Posting except for the purposes of considering an investment in the Company (this analysis to be either made on your own or with advice obtained independently from D2D or the Custodian). Without limitation, each Investor agrees with D2D and with each Company that it will not directly or indirectly seek to use the information to enter into competition with the Company or to solicit employees, customers or suppliers of the Company. Any information contained in a Posting is confidential and must not be disclosed or distributed to any third party except with the prior written consent of the Company given in its absolute discretion. You may disclose this information to your external advisors (including without limitation your aD2Dountant, solicitor or financial advisors) on a confidential basis, and for the purposes of considering an investment only. You may also disclose information if you are required to do so by law or any securities exchange or regulatory or governmental body or authority. </span></b></p>
                    <p><b>4. D2D&#8217;s review of a Posting.<span style="font-weight: 400;"> D2D will perform a limited review of each Posting before Investors are able to review it. Such review will focus on the technical merits of the Company’s scientific project and of their business plan. D2D will ask the Company to disclose any information on matters that could be detrimental to Investors. However, for this review D2D will rely on the Company acting honestly and with reasonable care. The Posting may also include opinions and forward-looking statements by the Company that are not possible to verify. </span></b></p>
                    <p><b>5. No recommendation.<span style="font-weight: 400;"> An Investor shall not take D2D’s approval of a Company to publish a Posting as any form of recommendation to invest in a Company nor as to the merits of the Company’s business or its likelihood of suD2Dess. Any decision to invest in the Company shall be the Investor’s, either on their own or based on that they may obtain independently from D2D or the Custodian.</span></b></p>
                    <p><b>6. Terms of the investment agreement.<span style="font-weight: 400;"> Although, in most cases, an Investor will not be a party to the investment agreement, an Investor will be able to see the agreement either as part of the Posting, or at a later stage before the completion and execution of the investment. In any event, the investment agreement may contain, amongst other provisions, some or all of the following provisions:</span></b></p>
                    <p><span style="font-weight: 400;">a) The Company being obliged to secure investment through the Site of at least the Minimum Target Amount. If the Lead Investor(s) have already invested or agreed to invest the Minimum Target Amount then the fund raising will be certain to be suD2Dessful whether or not any funds are raised through the Site;</span></p>
                    <p><span style="font-weight: 400;">b) The Company and Company’s management may agree to provide the Custodian and the Investors that are parties to an investment agreement with representations and warranties relating to the Company and its business which will be true at the date of completion of the Fund Raising, and which will continue to be true during the investment. In the event of a breach of any of these representation and warranties, the Investor may have a claim to a loss and the Custodian may follow the Investor’s instructions in relation to such claim. </span></p>
                    <p><span style="font-weight: 400;">c) Non-competition, non-solicitation and confidentiality undertakings which will apply to the Investor(s);</span></p>
                    <p><span style="font-weight: 400;">d) The consent of the Investor may be required for certain key decisions of the Company such as, by way of example only, issuing new shares or changing the share capital, amending the Articles of Association, acquiring any new business, shares or other securities or doing any act or thing other than in ordinary course of business; and</span></p>
                    <p><span style="font-weight: 400;">e) The Company’s undertaking to supply financial and operational information about the Company to the Custodian for investors as required by law. </span></p>
                    <p>&nbsp;</p>
                    <p><b>7. Terms of the Articles of Association.<span style="font-weight: 400;"> The Articles will be made available to the Investor as part of the Posting, or at some later point of the investment process. While the Company’s current Articles will be publicly available at the Companies’ House, the final text of the Articles which will be adopted upon completion will be provided to the Investor as part of the Posting or prior to completion so that the Investor can agree to them before an investment completes. </span></b></p>
                    <p><b>8. Rights attaching to shares<span style="font-weight: 400;">. All investments made through the Site will take the form of subscriptions for voting ordinary shares which rank equally with each other in terms of the right to receive any dividends and the right to participate in the proceeds of sale on a sale of the Company or otherwise. </span></b></p>
                    <p><b>9. Investment Period<span style="font-weight: 400;">. A Company’s Posting will remain open for investment for an initial Period as set out on the Posting. If the Company has not received its Minimum Target Amount by the end of the Period then the Posting will be withdrawn. Otherwise, it will be deemed suD2Dessful as defined below. </span></b></p>
                    <p><b>10. SuD2Dessful Fund Raising:<span style="font-weight: 400;"> If the Company has received its Minimum Target Amount by the end of the Period then the Fund Raising will be deemed to be suD2Dessful. In such case, the Company will proceed to completion. </span></b></p>
                    <p><span style="font-weight: 400;">As an exception to the above, when the relevant Posting has not included the terms of the Company’s Investment Agreement and/or of the Articles of Association, upon suD2Dess of the Fund Raising the Company shall instruct D2D to circulate such terms by e-mail to each Investor. Such e-mail shall (i) request the investors to aD2Dess the Site and confirm their intention to invest in the Company, providing their specific consent to the Investment Agreement and the Articles of Association as they have been disclosed to them; and (ii) inform the maximum time that the investors will have to confirm their intention to invest. If an Investor does not confirm their intention to invest as requested in D2D’s e-mail it will be deemed that the Investor has cancelled the investment The Company will proceed to completion with the Investors that have remained in the Fund Raising, except in case that the aggregate investment of the remaining investors is below the Minimum Target Amount. In such case, the Fund Raising will no longer be considered suD2Dessful and the Company will not be able to proceed to completion. </span></p>
                    <p><span style="font-weight: 400;">For any Investor that has decided not to proceed with the Investment, D2D will issue the relevant instructions to the Escrow Agent (on behalf of the Investor) to credit that Investor’s Nominated AD2Dount with the amount the Investor transferred to the Pre-Closing AD2Dount. The provisions under clause 4.14 (“Cancellation”) below will apply to the procedure regarding this credit. </span></p>
                    <p><b>11. </b><b>Investing in the Company.<span style="font-weight: 400;"> An Investor may execute their Commitment to invest in a Company at any time during the Period by following the process set out on the Site. This will require the Investor to (i) confirm the amount they wish to invest in the Company (the shares of which shall be held by the Nominee); (ii) transfer such funds to the Pre-Closing AD2Dount, (iii) authorise the payment to the Company upon completion of the relevant conditions (or upon confirmation of the investment as provided under clause 4.10); and (iv) authorise the Custodian to enter into the Investment Agreement. Upon execution of the Commitment and transfer of the funds to the Pre-Closing AD2Dount, the funds shall be held in escrow by the Escrow Agent until fulfilment of the Completion Conditions.</span></b></p>
                    <p><b>12. Custodian and Nominee. <span style="font-weight: 400;">When you choose to make an investment through the Site, your shares in the Company will be held for your benefit by a nominee company controlled by the Custodian and you agree that the Custodian shall administer the shares on your behalf. The full terms of the custodian and nominee arrangement are set out below under the Custodian’s T&amp;Cs. </span></b></p>
                    <p><span style="font-weight: 400;">This means that you will receive an economic interest in the Company that is equivalent to the economic interest you would hold if you purchased its shares directly (subject to D2D’s fees), but you will not hold or administer the shares and will therefore not be in the same legal position as a direct shareholder would be. </span></p>
                    <p><b>13. Overfunding.<span style="font-weight: 400;"> If at the end of the Period (extended if necessary by such number of days as is necessary to allow for the expiry of all 14-day cancellation periods), Investors have applied to invest in aggregate for more than the Maximum Target Amount then applications by the Investors will be satisfied on a ‘first come first served’ basis. If any Investor has an application that is not satisfied in full (because it partly exceeds the Maximum Target Amount) then D2D will send an e-mail to such Investor, substantially in the terms defined under clause 4.10, requesting the Investor to confirm their investment for the part of their investment that is not in excess of the Maximum Target Amount. </span></b></p>
                    <p><b>14. Cancellation<span style="font-weight: 400;">: After the Commitment (which includes the moment when the Investor agrees to the investment contracts as offered on the site and pays in the amount they wish to invest), the Investor(s) has the right at any time during the period of 14 calendar days commencing on the date of the Commitment to cancel its subscription for the shares by notifying D2D in aD2Dordance with the notice provisions set out in these terms and D2D will issue the relevant instructions to the Escrow Agent, on behalf of the Investor, to credit that Investor’s Nominated AD2Dount with the amount the Investor transferred to the Pre-Closing AD2Dount.</span></b></p>
                    <p><span style="font-weight: 400;">In order to effect this credit, the Escrow Agent may need to carry out additional anti-money laundering or other checks to verify the identity of the transferee of the investment and the recipient of the funds to be returned. AD2Dordingly, in order to ensure compliance with its own anti-money laundering obligations, the Escrow Agent may therefore be required to withhold or delay returning funds to an Investor who cancels their investment until these checks have been completed satisfactorily and in compliance with those obligations.</span></p>
                    <p><span style="font-weight: 400;">If an Investor does not exercise their cancellation right during such 14-calendar-day period then they will no longer be able to cancel their investment, except when the investment is subject to subsequent confirmation as set out under clause 4.10.</span></p>
                    <p><b>15. Completion.<span style="font-weight: 400;"> The Posting shall define the conditions to be met to proceed to completion and execution of the investment. The set of applicable conditions precedent for completion within a given Posting may be:</span></b></p>
                    <p><span style="font-weight: 400;">a) For Postings that include the complete text of the investment agreement and of the Articles of Association to be adopted upon completion: completion and execution of the investment shall be conditional to (i) the Minimum Target Amount being raised during the investment Period, and (ii) that the Minimum Target Amount continues to be met upon expiration of the cancellation period for each of the investors (as set forth under clause 4.14).</span></p>
                    <p><span style="font-weight: 400;">b) For Postings that do not include the complete text of the investment agreement and of the Articles of Association to be adopted upon completion: completion and execution of the investment shall be conditional to (i) the Minimum Target Amount being raised during the investment Period; and (ii) that the Minimum Target Amount continues to be met upon expiration of the confirmation period for each of the investors (as set forth under clause 4.10).</span></p>
                    <p><span style="font-weight: 400;">It is D2D’s responsibility to certify that the completion conditions have been met for a given Posting. Upon such confirmation from D2D, (i) the Escrow Agent shall transfer the monies held in the Pre-Closing AD2Dount to a solicitor nominated by the Company, or directly to the bank aD2Dount of the Company, as payment for the shares to be subscribed by the Nominee; and (ii) the Custodian shall execute the relevant investment agreement in the terms that it has been approved by the investors.</span></p>
                    <p><b>16. D2D fees, Company&#8217;s legal fees and other fees.<span style="font-weight: 400;"> At completion of a Fund Raising, D2D’s fees will be payable by the Company. These fees will be payable by the Company on the same date when they receive the investment amount held in the Pre-Closing AD2Dount. In the event that any Company raises funds directly from any Investor(s) who is registered with D2D during the period of 12 months commencing on the date of the Posting for that Company then the Company agrees and acknowledges that D2D’s fees shall be due and payable as if those funds had been raised through the D2D Site.</span></b></p>
                    <p><span style="font-weight: 400;">We will only charge the Investor a fee in the following cases: (a) if the Investor receives dividends or any other distributions from the Company, D2D will charge a fee of 10% of their gross amount (prior to any withholding tax that may apply); and (b) if the Investor receives proceeds from the sale of an investment where the sale price exceeds the amount of capital paid in by the Investor to purchase the investment, we will deduct 10% of the excess money returned on a pre-tax basis. </span></p>
                    <p><b>17. Minimum investment amount.<span style="font-weight: 400;"> The minimum amount an Investor can invest is indicated in the Posting. </span></b></p>
                    <p><b>18.  Authorisation to transfer funds to the Company.</b><span style="font-weight: 400;"> When the applicable Completion Conditions have been met and the Company has executed and delivered to Capital Cell all the relevant completion documents, Capital Cell shall instruct the Escrow Agent to transfer the funds from the Pre-Closing AD2Dount to the Company, so that the Investor’s investment shall be duly paid in and the Company can issue the relevant share certificate to the Custodian, who will hold the shares on behalf of the Investor. By executing the Commitment, the Investor authorises the Escrow Agent to transfer the funds to the Company on completion, when so instructed by Capital Cell.</span></p>
                    <p>&nbsp;</p>
                    <h3><b>5. LEAD INVESTOR(S) (the following clauses apply only to Lead Investor(s))</b></h3>
                    <p><b>1. The process for Lead Investors<span style="font-weight: 400;">. Except as set out above or in the relevant Posting, the investment process for a Lead Investor(s) investing in a Company is the same as the investment process for any other Investor. </span></b></p>
                    <p><b>2. Obtaining Lead Investor status<span style="font-weight: 400;">. An Investor is only able to obtain Lead Investor status with the prior approval of D2D given in its discretion. </span></b></p>
                    <p><b>3. Further investments by a supporting Lead Investor: <span style="font-weight: 400;">A Lead Investor may agree to invest further amounts over and above its initial commitment at any time during the Period.</span></b></p>
                    <h3></h3>
                    <h3><b>6. CUSTODIAN AND NOMINEE </b></h3>
                    <p><span style="font-weight: 400;">Shares in a Company in which you invest shall be registered in the name of the Nominee and held for your benefit. The services to be provided by the Custodian, shall be governed by the Custodian’s T&amp;Cs. The full terms and conditions of the Custodian and Nominee Service are under the Custodian’s T&amp;C at </span><a href="https://www.drip2drop.com/terms_conditions"><span style="font-weight: 400;">https://www.drip2drop.com/terms_conditions</span></a><span style="font-weight: 400;">.</span> <span style="font-weight: 400;">You acknowledge and agree that you aD2Dept the Custodian’s T&amp;Cs and to become a retail client of the Custodian under the COBS rules in the FCA rules.</span></p>
                    <p><span style="font-weight: 400;">You acknowledge and agree that the Nominee holds the shares as nominee in aD2Dordance with the FCA rules. You understand that the Nominee will be the legal owner of the shares and you will be the beneficial owner of the shares. </span></p>
                    <p><span style="font-weight: 400;">In the event of any transfer of shares from the Nominee to the Investor or the Investor’s estate or beneficiaries, such transfer shall be conditional upon the person to whom the Shares are transferred entering into a deed of adherence to the Investment Agreement at the time of such transfer. If and until the transferee agrees to execute the deed of adherence, the Custodian may refuse to execute the transfer of the Shares, and will not aD2Dept instructions from the transferee in connection with the shares.</span></p>
                    <p><span style="font-weight: 400;">The Custodian will report any shares it holds on your behalf at cost and is not responsible for any valuation of the shares that it holds for you.</span></p>
                    <p><span style="font-weight: 400;">Where you request or instruct the Custodian to transfer or hold client monies or client assets into an aD2Dount operated by a solicitor or agent (such as a solicitor’s escrow aD2Dount or a solicitor’s general client aD2Dount), the Custodian shall do so on the strict basis, that you aD2Dept and agree, that no member of Reyker Group (including nominees and regulated entities) and/or Capital Cell Group aD2Depts any liability for such previously designated client money or client assets whilst held by the solicitor, or after they have been transferred out by the Custodian to the solicitor, or for inward transaction flows, until they have been received by the Custodian from the solicitor or other third party.</span></p>
                    <h3></h3>
                    <h3><b>7. LIABILITY</b></h3>
                    <p><span style="font-weight: 400;">The Company is solely liable for the Posting and the information provided in support of the Posting. Except as stated under clause 4.4, the contents of the Posting have not been verified by any Relevant Person and it is likely that no Relevant Person(s) has carried out any due diligence exercise in respect of the information in the Posting or the Company or its business generally. All investments made through the Site are made entirely at the Investor’s own risk and are based on the Investor’s own judgment, or on the basis of the advice they have received independently of any Relevant Person.</span></p>
                    <p><span style="font-weight: 400;">No Relevant Person shall be liable or responsible to any Investor or any Company for any of the following matters and each Relevant Person hereby excludes, to the fullest extent permitted under law (including contract, tort or breach of statutory duty), any and all liability for, or in respect of: </span></p>
                    <ol>
                        <li style="font-weight: 400;"><span style="font-weight: 400;">The performance of any Company, the market opportunity, or the Company’s ability to meet its business plan;</span></li>
                        <li style="font-weight: 400;">The suitability of any Company for investment;</li>
                        <li style="font-weight: 400;">The terms of any investment in a Company (including without limitation the investment agreement and the Articles);</li>
                        <li style="font-weight: 400;">The undertaking or outcome of any due diligence exercise in respect of a Company or any due diligence report in respect of a Company (whether legal, financial, technical or otherwise); nor</li>
                        <li style="font-weight: 400;">Obtaining any Relief in relation to an investment in a Company or that Company remaining eligible for a Relief after the investment has been made.</li>
                    </ol>
                    <p><span style="font-weight: 400;">Except for any matter for which it would be illegal for a Relevant Person to limit its liability, the total aggregate liability of any Relevant Person including any legal and other costs and expenses under or in connection with these terms or any investment made through the Site howsoever arising and whether in contract, tort, or otherwise (including for negligence) shall be £1,000. </span></p>
                    <h3></h3>
                    <h3><b>8. ANTI-MONEY LAUNDERING REGULATIONS</b></h3>
                    <p><span style="font-weight: 400;">We are required to establish your identity before you can invest. We will use third party organisations to assist you with this process at the point when you register for D2D’s Site, or at the point when you indicate your intent to make an investment. Electronic verification may leave a ‘soft footprint’ or enquiry trace on your third-party records in order to complete a conclusive identity check. This check is for identification verification and AML only and we have been informed by the agencies we use who provide these services that it will not adversely affect your credit rating.</span></p>
                    <p><span style="font-weight: 400;">You must provide sufficient documentation about yourself to enable us, the Custodian and other relevant parties to ascertain and verify your identity. This may include providing certified copies of identification documents such as your passport, driving licence and recent utility bills and providing personal information such as your address, residency and date of birth. Full details will be requested as part of the investment process. The information required may change from time to time and should that prove to be the case we will notify you that additional documentation has become necessary. Until you provide that additional documentation you will be unable to invest.</span></p>
                    <p><span style="font-weight: 400;">Your identification information (including the documents you will provide and the result of D2D’s own verifications) will be shared with the Custodian, who will use them to comply with their own identification requirements. </span></p>
                    <h3></h3>
                    <h3><b>9. GENERAL</b></h3>
                    <ol>
                        <li><b><span style="font-weight: 400;">Your aD2Dount on the Site may be terminated and closed at any time either by you or us, or suspended at any time by us. In the event that we suspend, terminate or close your aD2Dount then we will notify you by e-mail at the address associated with your aD2Dount. These terms will continue in full force and effect following termination, closing or suspension of your aD2Dount in respect of prior acts and events. In any event, all disclaimers, indemnities and exclusions in these terms shall survive termination of these terms for any reason, as shall any other provisions of these terms that by their nature are intended to survive such termination. This will not affect your relationship with the Custodian and with any companies you may have invested on through D2D’s Site. In such case we will continue to provide you with any communication to you from the Custodian, which are not dependent on you remaining as a registered user of D2D’s Site.</span></b></li>
                        <li><b><span style="font-weight: 400;">These terms may be varied by us, at D2D’s absolute discretion, from time to time. If these terms are varied we will notify you by posting the revised terms on the Site and sending an email to the email address you provide to us as part of your registration process.</span></b></li>
                        <li><b><span style="font-weight: 400;">These terms and conditions, the Custodian’s T&amp;Cs, together with the terms of website use and privacy policy referred to within them, constitute the entire agreement between us relating to their subject matter and you acknowledge that you have not relied upon any representations, statements or pre-contractual statements that are not expressly set out in these terms.</span></b></li>
                        <li><b><span style="font-weight: 400;">These terms do not confer any rights on any person or party (other than the parties hereto) pursuant to the Contracts (Rights of Third Parties) Act 1999.</span></b></li>
                        <li><b><span style="font-weight: 400;">All communications between us will be carried out by e-mail. Notices to D2D should be sent to D2D at info@capitalcell.net. D2D will contact you using the e-mail address associated with your aD2Dount. Notices will be deemed served at the time of sending unless this falls on a day which is a weekend or bank holiday in the United Kingdom, in which case they will be deemed served on the next working day after they were sent. </span></b>Any communications to and from the Custodian will be provided by and received by D2D on behalf of the Custodian.</li>
                        <li><b><span style="font-weight: 400;">Should you have any complaints in relation to your use of the Site, please notify us by email at info@capitalcell.net. We will aim to reply to your complaint promptly, investigate the circumstances and revert back to you with the results of D2D’s investigation within 8 weeks of the date of your complaint. If your complaint is unresolved 8 weeks from the date you first made the complaint you may refer it directly to The Financial Ombudsmen Service at www.financial-ombudsman.org.uk. </span></b>If you have a complaint about the Custodian then it should be given in aD2Dordance with the Custodian’s T&amp;Cs.</li>
                        <li><b><span style="font-weight: 400;">You shall from time to time (both during the continuance of these terms and after its termination) do all such acts and execute all such documents as may be reasonably necessary in order to give effect to the provisions of these terms. </span></b>Your and D2D’s costs and expenses (including professional, legal and aD2Dountancy expenses) of the preparation, negotiation and execution of these terms and any associated documentation shall be borne by you and us respectively.</li>
                        <li><b><span style="font-weight: 400;">No failure or delay by you or us in exercising any rights under these terms shall be deemed to be a waiver of that right, and no waiver by you or us of a breach of any provision of these terms shall be deemed to be a waiver of any subsequent breach of the same or any other provision.</span></b></li>
                        <li><b><span style="font-weight: 400;">If any provision of these terms is held by any court or other competent authority to be invalid or unenforceable in whole or in part, these terms shall continue to be valid as to their other provisions and the remainder of the affected provision.</span></b></li>
                        <li><b><span style="font-weight: 400;">These terms shall not be construed so as to create a partnership or joint venture between you and us.</span></b></li>
                        <li><b><span style="font-weight: 400;">You shall not be entitled to assign, transfer, sub-contract or delegate any of your rights or obligations under this agreement, except when the transferee is your legal spouse, or in case of death. D2D may assign the whole or part of any of its rights in this agreement to any person.</span></b></li>
                        <li><b><b><span style="font-weight: 400;">We shall not be in breach of these terms, and we shall not be liable or have responsibility of any kind for any loss or damage incurred by you as a result of:<br />
                        </span></b></b></p>
                            <ol>
                                <li style="font-weight: 400;"><span style="font-weight: 400;">any total or partial failure, </span></li>
                                <li style="font-weight: 400;"><span style="font-weight: 400;">interruption or </span></li>
                                <li style="font-weight: 400;"><span style="font-weight: 400;">delay </span></li>
                            </ol>
                            <p><span style="font-weight: 400;">in the performance of D2D’s duties and obligations oD2Dasioned by any </span></p>
                            <ol>
                                <li style="font-weight: 400;"><span style="font-weight: 400;">act of God, </span></li>
                                <li style="font-weight: 400;"><span style="font-weight: 400;">fire, </span></li>
                                <li style="font-weight: 400;"><span style="font-weight: 400;">act of government, state, governmental or supranational body or regulatory authority; </span></li>
                                <li style="font-weight: 400;"><span style="font-weight: 400;">war, civil commotion, terrorism,</span></li>
                                <li style="font-weight: 400;"><span style="font-weight: 400;">failure of any internet or computer system, </span></li>
                                <li style="font-weight: 400;"><span style="font-weight: 400;">interruptions of power supplies, </span></li>
                                <li style="font-weight: 400;"><span style="font-weight: 400;">labour disputes of whatever nature </span></li>
                                <li style="font-weight: 400;"><span style="font-weight: 400;">or any other reason (whether or not similar in kind to any of the above) </span></li>
                            </ol>
                            <p>beyond D2D’s reasonable control.</li>
                        <li><b><span style="font-weight: 400;">In the event that we cease to trade for any reason, any amounts contained in the Pre-Closing AD2Dount will be refunded to you and any live Postings will be withdrawn immediately.</span></b></li>
                        <li><b><span style="font-weight: 400;">This agreement (and any dispute or claim relating to it or its subject matter (including non-contractual claims) is governed by and is to be construed in aD2Dordance with English law. The parties irrevocably agree that the courts of England and Wales shall have exclusive jurisdiction to settle any claim, dispute or issue (including non-contractual claims) which may arise out of or in connection with this agreement.</span></b></li>
                    </ol>
                </div>
            </div>

        </div>
    </section><!-- End About Section -->
</main>

<!-- ======= Footer ======= -->
<footer id="footer">

    <div class="footer-top">
        <div class="container">
            <div class="row">

                <div class="col-lg-3 col-md-6 footer-contact">
                    <h3>Drip2Drop</h3>
                    <p>
                        27 Akerele lane <br>
                        Maryland, Lagos<br>
                        Nigeria <br><br>
                        <strong>Email:</strong> info@drip2drop.com<br>
                    </p>
                </div>

                <div class="col-lg-2 col-md-6 footer-links">
                    <h4>Useful Links</h4>
                    <ul>
                        <li><i class="bx bx-chevron-right"></i> <a href="<?php echo base_url(); ?>">Home</a></li>
                        <li><i class="bx bx-chevron-right"></i> <a href="<?php echo base_url(); ?>#about">About us</a></li>
                        <li><i class="bx bx-chevron-right"></i> <a href="<?php echo base_url(); ?>#services">Services</a></li>
                        <li><i class="bx bx-chevron-right"></i> <a href="<?php echo base_url(); ?>terms_conditions">Terms of service</a></li>
                        <li><i class="bx bx-chevron-right"></i> <a href="<?php echo base_url(); ?>privacy_policy">Privacy policy</a></li>
                    </ul>
                </div>

                <div class="col-lg-3 col-md-6 footer-links">
                    <h4>Our Services</h4>
                    <ul>
                        <li><i class="bx bx-chevron-right"></i> <a href="<?php echo base_url(); ?>airtime">Airtime</a></li>
                        <li><i class="bx bx-chevron-right"></i> <a href="<?php echo base_url(); ?>airtime/print-recharge-card">Recharge card printing</a></li>
                        <li><i class="bx bx-chevron-right"></i> <a href="<?php echo base_url(); ?>data">Internet Data</a></li>
                        <li><i class="bx bx-chevron-right"></i> <a href="<?php echo base_url(); ?>home">Daily Auction</a></li>
                        <li><i class="bx bx-chevron-right"></i> <a href="<?php echo base_url(); ?>investment/new">Investment</a></li>
                        <li><i class="bx bx-chevron-right"></i> <a href="<?php echo base_url(); ?>loan">Business Loan</a></li>
                    </ul>
                </div>

                <div class="col-lg-4 col-md-6 footer-newsletter">
                    <h4>Join Our Newsletter</h4>
                    <p>Get notified on any of our new update and promotion</p>
                    <form action="" method="post">
                        <input type="email" name="email"><input type="submit" value="Subscribe">
                    </form>
                </div>

            </div>
        </div>
    </div>

    <div class="container d-lg-flex py-4">

        <div class="mr-lg-auto text-center text-lg-left">
            <div class="copyright">
                &copy; Copyright <strong><span>Drip2Drop</span></strong>. All Rights Reserved
            </div>
            <div class="credits">
                <!-- All the links in the footer should remain intact. -->
                <!-- You can delete the links only if you purchased the pro version. -->
                <!-- Licensing information: https://bootstrapmade.com/license/ -->
                <!-- Purchase the pro version with working PHP/AJAX contact form: https://bootstrapmade.com/flexor-free-multipurpose-bootstrap-template/ -->
                Powered by <a href="#">Global Tech & Services LTD</a>
            </div>
        </div>
        <div class="social-links text-center text-lg-right pt-3 pt-lg-0">
            <a href="#" class="twitter"><i class="bx bxl-twitter"></i></a>
            <a href="fb.me/drip2drop" class="facebook"><i class="bx bxl-facebook"></i></a>
            <a href="#" class="instagram"><i class="bx bxl-instagram"></i></a>
            <a href="#" class="google-plus"><i class="bx bxl-skype"></i></a>
            <a href="#" class="linkedin"><i class="bx bxl-linkedin"></i></a>
        </div>
    </div>
</footer><!-- End Footer -->

<a href="#" class="back-to-top"><i class="icofont-simple-up"></i></a>

<!-- Vendor JS Files -->
<script src="<?php echo base_url(); ?>assets/vendor/jquery/jquery.min.js"></script>
<script src="<?php echo base_url(); ?>assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="<?php echo base_url(); ?>assets/vendor/jquery.easing/jquery.easing.min.js"></script>
<script src="<?php echo base_url(); ?>assets/vendor/php-email-form/validate.js"></script>
<script src="<?php echo base_url(); ?>assets/vendor/jquery-sticky/jquery.sticky.js"></script>
<script src="<?php echo base_url(); ?>assets/vendor/venobox/venobox.min.js"></script>
<script src="<?php echo base_url(); ?>assets/vendor/owl.carousel/owl.carousel.min.js"></script>
<script src="<?php echo base_url(); ?>assets/vendor/isotope-layout/isotope.pkgd.min.js"></script>
<script src="<?php echo base_url(); ?>assets/vendor/aos/aos.js"></script>

<!-- Template Main JS File -->
<script src="<?php echo base_url(); ?>assets/js/main.js"></script>

<!--Start of Tawk.to Script-->
<script type="text/javascript">
    var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
    (function(){
        var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
        s1.async=true;
        s1.src='https://embed.tawk.to/5ea0df0b35bcbb0c9ab3c88b/default';
        s1.charset='UTF-8';
        s1.setAttribute('crossorigin','*');
        s0.parentNode.insertBefore(s1,s0);
    })();
</script>
<!--End of Tawk.to Script-->
</body>

</html>
