/**
 * Created by testing on 10/2/2019.
 */

var initial_html;

function uploadFile(fileName, url) {
    //var fileReader = new FileReader();
    var file = document.getElementById(fileName).files[0];
    //alert(file.name+" | "+file.size+" | "+file.type);
    var fsize = file.size;
    var ftype = file.type;

    var filter = /^(?:image\/bmp|image\/cis\-cod|image\/gif|image\/ief|image\/jpeg|image\/jpeg|image\/jpeg|image\/pipeg|image\/png|image\/svg\+xml|image\/tiff|image\/x\-cmu\-raster|image\/x\-cmx|image\/x\-icon|image\/x\-portable\-anymap|image\/x\-portable\-bitmap|image\/x\-portable\-graymap|image\/x\-portable\-pixmap|image\/x\-rgb|image\/x\-xbitmap|image\/x\-xpixmap|image\/x\-xwindowdump)$/i;

    if (!filter.test(ftype)) {
        msg("<i class='fa fa-times-circle'></i> Unsupported file format...", "alert-danger", 1, _("msg"));
        return;
    }

    //Check file size to make sure it didn't exceed 200kb max
    var allowed_file_size = 2200000;
    if (fsize > allowed_file_size) {
        msg("<i class='fa fa-times-circle'></i> File too large! Allowed size 2 MB", "alert-danger", 1, _("msg"));
        return;
    }

    var formdata = new FormData();
    formdata.append("image",file);
    var ajax = new XMLHttpRequest();
    ajax.upload.addEventListener("progress", progressHandler, false);
    ajax.addEventListener("load",completeHandler,false);
    ajax.addEventListener("error",errorHandler,false);
    ajax.addEventListener("abort",abortHandler,false);
    ajax.open("POST",url);
    ajax.send(formdata);
}
function progressHandler(event) {
    // Show loader image
    initial_html = _('picture-btn').html();
    _('picture-btn').html("<i class='fa fa-spinner fa-spin'></i> Uploading picture");
    _('picture-btn').attr('disabled', 'disabled');
}
function completeHandler(event) {
    _('picture-btn').html(initial_html);
    _('picture-btn').removeAttr('disabled');
    _('pictures').html(event.target.responseText);
}
function errorHandler(event) {
    ajax.abort();
    setTimeout(function() {
        _('picture-btn').html("<span style='color:red'>Error: not uploaded</span>");
    }, 1500);
    _('picture-btn').html(initial_html);
    _('picture-btn').removeAttr('disabled');
}
function abortHandler(event) {
    ajax.abort();
    setTimeout(function() {
        _('picture-btn').html("<span style='color:red'>Upload cancelled</span>");
    }, 1500);
    _('picture-btn').html(initial_html);
    _('picture-btn').removeAttr('disabled');
}
